/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appstate;

import android.content.Context;
import com.google.android.gms.appstate.OnSignOutCompleteListener;
import com.google.android.gms.appstate.OnStateDeletedListener;
import com.google.android.gms.appstate.OnStateListLoadedListener;
import com.google.android.gms.appstate.OnStateLoadedListener;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.cw;
import com.google.android.gms.internal.dm;

public final class AppStateClient
implements GooglePlayServicesClient {
    public static final int STATUS_OK = 0;
    public static final int STATUS_INTERNAL_ERROR = 1;
    public static final int STATUS_CLIENT_RECONNECT_REQUIRED = 2;
    public static final int STATUS_NETWORK_ERROR_STALE_DATA = 3;
    public static final int STATUS_NETWORK_ERROR_NO_DATA = 4;
    public static final int STATUS_NETWORK_ERROR_OPERATION_DEFERRED = 5;
    public static final int STATUS_NETWORK_ERROR_OPERATION_FAILED = 6;
    public static final int STATUS_DEVELOPER_ERROR = 7;
    public static final int STATUS_WRITE_OUT_OF_DATE_VERSION = 2000;
    public static final int STATUS_WRITE_SIZE_EXCEEDED = 2001;
    public static final int STATUS_STATE_KEY_NOT_FOUND = 2002;
    public static final int STATUS_STATE_KEY_LIMIT_EXCEEDED = 2003;
    private final cw io;

    private AppStateClient(Context context, GooglePlayServicesClient.ConnectionCallbacks connectedListener, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener, String accountName, String[] scopes) {
        this.io = new cw(context, connectedListener, connectionFailedListener, accountName, scopes);
    }

    public void connect() {
        this.io.connect();
    }

    public boolean isConnected() {
        return this.io.isConnected();
    }

    public boolean isConnecting() {
        return this.io.isConnecting();
    }

    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.io.registerConnectionCallbacks(listener);
    }

    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.io.isConnectionCallbacksRegistered(listener);
    }

    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.io.unregisterConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.io.registerConnectionFailedListener(listener);
    }

    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.io.isConnectionFailedListenerRegistered(listener);
    }

    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.io.unregisterConnectionFailedListener(listener);
    }

    public void disconnect() {
        this.io.disconnect();
    }

    public void reconnect() {
        this.io.disconnect();
        this.io.connect();
    }

    public int getMaxStateSize() {
        return this.io.getMaxStateSize();
    }

    public int getMaxNumKeys() {
        return this.io.getMaxNumKeys();
    }

    public void updateState(int stateKey, byte[] data) {
        this.io.a(null, stateKey, data);
    }

    public void updateStateImmediate(OnStateLoadedListener listener, int stateKey, byte[] data) {
        dm.a(listener, (Object)"Must provide a valid listener");
        this.io.a(listener, stateKey, data);
    }

    public void deleteState(OnStateDeletedListener listener, int stateKey) {
        this.io.deleteState(listener, stateKey);
    }

    public void loadState(OnStateLoadedListener listener, int stateKey) {
        this.io.loadState(listener, stateKey);
    }

    public void listStates(OnStateListLoadedListener listener) {
        this.io.listStates(listener);
    }

    public void resolveState(OnStateLoadedListener listener, int stateKey, String resolvedVersion, byte[] resolvedData) {
        this.io.resolveState(listener, stateKey, resolvedVersion, resolvedData);
    }

    public void signOut() {
        this.io.signOut(null);
    }

    public void signOut(OnSignOutCompleteListener listener) {
        dm.a(listener, (Object)"Must provide a valid listener");
        this.io.signOut(listener);
    }

    public static final class Builder {
        private static final String[] ip = new String[]{"https://www.googleapis.com/auth/appstate"};
        private Context mContext;
        private GooglePlayServicesClient.ConnectionCallbacks iq;
        private GooglePlayServicesClient.OnConnectionFailedListener ir;
        private String[] is;
        private String it;

        public Builder(Context context, GooglePlayServicesClient.ConnectionCallbacks connectedListener, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener) {
            this.mContext = context;
            this.iq = connectedListener;
            this.ir = connectionFailedListener;
            this.is = ip;
            this.it = "<<default account>>";
        }

        public Builder setScopes(String ... scopes) {
            this.is = scopes;
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.it = dm.e(accountName);
            return this;
        }

        public AppStateClient create() {
            return new AppStateClient(this.mContext, this.iq, this.ir, this.it, this.is);
        }
    }
}

