/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.ListenerList;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.IUndoManagerListener;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.UndoManagerAdapter;

public class WorkspaceTracker {
    public static final WorkspaceTracker INSTANCE = new WorkspaceTracker();
    private ListenerList fListeners = new ListenerList();
    private JavaModelListener fJavaModelListener;
    private ResourceListener fResourceListener;
    private UndoManagerListener fUndoManagerListener;

    private WorkspaceTracker() {
    }

    private void workspaceChanged() {
        if (this.fUndoManagerListener != null && this.fUndoManagerListener.isPerformingChange()) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((Listener)listeners[i]).workspaceChanged();
        }
    }

    public void addListener(Listener l) {
        this.fListeners.add(l);
        if (this.fUndoManagerListener == null) {
            this.fUndoManagerListener = new UndoManagerListener();
            RefactoringCore.getUndoManager().addListener((IUndoManagerListener)this.fUndoManagerListener);
        }
        if (this.fJavaModelListener == null) {
            this.fJavaModelListener = new JavaModelListener();
            JavaCore.addElementChangedListener((IElementChangedListener)this.fJavaModelListener);
        }
        if (this.fResourceListener == null) {
            this.fResourceListener = new ResourceListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fResourceListener);
        }
    }

    public void removeListener(Listener l) {
        this.fListeners.remove(l);
        if (this.fListeners.size() == 0) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fResourceListener);
            this.fResourceListener = null;
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fJavaModelListener);
            this.fJavaModelListener = null;
            RefactoringCore.getUndoManager().removeListener((IUndoManagerListener)this.fUndoManagerListener);
            this.fUndoManagerListener = null;
        }
    }

    private class ResourceListener
    implements IResourceChangeListener {
        private ResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    ICompilationUnit unit;
                    String ext;
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1 && delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0 && (ext = ((IFile)resource).getFileExtension()) != null && "java".equals(ext) && (unit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource))) != null && unit.exists()) {
                        WorkspaceTracker.this.workspaceChanged();
                        return false;
                    }
                    return true;
                }
            };
            try {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    delta.accept(visitor);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e.getStatus());
            }
        }
    }

    private class JavaModelListener
    implements IElementChangedListener {
        private JavaModelListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            this.processDelta(event.getDelta());
        }

        private boolean processDelta(IJavaElementDelta delta) {
            int kind = delta.getKind();
            int details = delta.getFlags();
            int type = delta.getElement().getElementType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (kind == 4 && details == 8) break;
                    WorkspaceTracker.this.workspaceChanged();
                    return false;
                }
                case 5: {
                    if ((details & 0x10000) != 0) {
                        return true;
                    }
                    ICompilationUnit unit = (ICompilationUnit)delta.getElement();
                    if (unit.isWorkingCopy()) {
                        return true;
                    }
                    WorkspaceTracker.this.workspaceChanged();
                    return false;
                }
                case 6: {
                    return true;
                }
                default: {
                    WorkspaceTracker.this.workspaceChanged();
                    return false;
                }
            }
            IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
            if (affectedChildren == null) {
                return true;
            }
            for (int i = 0; i < affectedChildren.length; ++i) {
                if (this.processDelta(affectedChildren[i])) continue;
                return false;
            }
            return true;
        }
    }

    private class UndoManagerListener
    extends UndoManagerAdapter {
        private int fInRefactoringCount;

        private UndoManagerListener() {
        }

        public void aboutToPerformChange(IUndoManager manager, Change change) {
            ++this.fInRefactoringCount;
        }

        public void changePerformed(IUndoManager manager, Change change) {
            --this.fInRefactoringCount;
        }

        public boolean isPerformingChange() {
            return this.fInRefactoringCount > 0;
        }
    }

    public static interface Listener {
        public void workspaceChanged();
    }
}

