/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.help.WorkbenchHelp;

class SelectWorkingSetAction
extends Action {
    private final SearchScopeActionGroup fGroup;

    public SelectWorkingSetAction(SearchScopeActionGroup group) {
        super(CallHierarchyMessages.getString("SearchScopeActionGroup.workingset.select.text"));
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.getString("SearchScopeActionGroup.workingset.select.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.call_hierarchy_search_scope_action_context");
    }

    public void run() {
        try {
            IWorkingSet[] workingSets = JavaSearchScopeFactory.getInstance().queryWorkingSets();
            if (workingSets != null) {
                this.fGroup.setActiveWorkingSets(workingSets);
                SearchUtil.updateLRUWorkingSets(workingSets);
            } else {
                this.fGroup.setActiveWorkingSets(null);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), JavaPlugin.getActiveWorkbenchShell(), CallHierarchyMessages.getString("SelectWorkingSetAction.error.title"), CallHierarchyMessages.getString("SelectWorkingSetAction.error.message"));
        }
    }
}

