/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JarPackagerUtil {
    static final String JAR_EXTENSION = "jar";
    static final String DESCRIPTION_EXTENSION = "jardesc";

    public static boolean askToCreateDirectory(Shell parent, File directory) {
        if (parent == null) {
            return false;
        }
        return JarPackagerUtil.queryDialog(parent, JarPackagerMessages.getString("JarPackage.confirmCreate.title"), JarPackagerMessages.getFormattedString("JarPackage.confirmCreate.message", directory.toString()));
    }

    public static List asResources(Object[] fSelectedElements) {
        if (fSelectedElements == null) {
            return null;
        }
        ArrayList<Object> selectedResources = new ArrayList<Object>(fSelectedElements.length);
        for (int i = 0; i < fSelectedElements.length; ++i) {
            Object element = fSelectedElements[i];
            if (element instanceof IJavaElement) {
                selectedResources.add(((IJavaElement)element).getResource());
                continue;
            }
            if (!(element instanceof IResource)) continue;
            selectedResources.add(element);
        }
        return selectedResources;
    }

    public static boolean askForOverwritePermission(Shell parent, String filePath) {
        if (parent == null) {
            return false;
        }
        return JarPackagerUtil.queryDialog(parent, JarPackagerMessages.getString("JarPackage.confirmReplace.title"), JarPackagerMessages.getFormattedString("JarPackage.confirmReplace.message", filePath));
    }

    static boolean canOverwrite(Shell parent, IFile file) {
        if (file.isAccessible()) {
            return true;
        }
        return JarPackagerUtil.askForOverwritePermission(parent, file.getFullPath().toString());
    }

    static String getMainClassName(JarPackageData jarPackage) {
        if (jarPackage.getManifestMainClass() == null) {
            return "";
        }
        return jarPackage.getManifestMainClass().getFullyQualifiedName();
    }

    private static boolean queryDialog(final Shell parent, final String title, final String message) {
        Display display = parent.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final boolean[] returnValue = new boolean[1];
        Runnable runnable = new Runnable(){

            public void run() {
                returnValue[0] = MessageDialog.openQuestion((Shell)parent, (String)title, (String)message);
            }
        };
        display.syncExec(runnable);
        return returnValue[0];
    }

    public static CoreException createCoreException(String message, Exception ex) {
        if (message == null) {
            message = "";
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 10001, message, (Throwable)ex));
    }

    public static boolean isMainClassValid(JarPackageData data, IRunnableContext context) {
        if (data == null) {
            return false;
        }
        IType mainClass = data.getManifestMainClass();
        if (mainClass == null) {
            return true;
        }
        try {
            IFile file = (IFile)mainClass.getResource();
            if (file == null || !JarPackagerUtil.contains(JarPackagerUtil.asResources(data.getElements()), file)) {
                return false;
            }
            return JavaModelUtil.hasMainMethod(mainClass);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e.getStatus());
            return false;
        }
    }

    static boolean contains(List resources, IFile file) {
        if (resources == null || file == null) {
            return false;
        }
        if (resources.contains(file)) {
            return true;
        }
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (resource == null || resource.getType() == 1) continue;
            List<IResource> children = null;
            try {
                children = Arrays.asList(((IContainer)resource).members());
            }
            catch (CoreException ex) {
                continue;
            }
            if (children == null || !JarPackagerUtil.contains(children, file)) continue;
            return true;
        }
        return false;
    }
}

