/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.SourceOutlinePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.model.IEditingModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class PDESourcePage
extends TextEditor
implements IFormPage,
IGotoMarker {
    private PDEFormEditor editor;
    private Control control;
    private int index;
    private String id;
    private InputContext inputContext;
    private IContentOutlinePage outlinePage;

    public PDESourcePage(PDEFormEditor editor, String id, String title) {
        this.id = id;
        this.initialize(editor);
        this.setPreferenceStore(PDEPlugin.getDefault().getPreferenceStore());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
    }

    public void initialize(FormEditor editor) {
        this.editor = (PDEFormEditor)editor;
    }

    public void dispose() {
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        super.dispose();
    }

    protected void editorSaved() {
        super.editorSaved();
    }

    protected abstract ILabelProvider createOutlineLabelProvider();

    protected abstract ITreeContentProvider createOutlineContentProvider();

    protected abstract void outlineSelectionChanged(SelectionChangedEvent var1);

    protected ViewerSorter createViewerSorter() {
        return null;
    }

    protected IContentOutlinePage createOutlinePage() {
        SourceOutlinePage outline = new SourceOutlinePage((IEditingModel)this.getInputContext().getModel(), (IBaseLabelProvider)this.createOutlineLabelProvider(), (IContentProvider)this.createOutlineContentProvider(), this.createViewerSorter());
        outline.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PDESourcePage.this.outlineSelectionChanged(event);
            }
        });
        this.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)outline);
        return outline;
    }

    public IContentOutlinePage getContentOutline() {
        if (this.outlinePage == null) {
            this.outlinePage = this.createOutlinePage();
        }
        return this.outlinePage;
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.editor.fireSaveNeeded(this.getEditorInput(), true);
        } else {
            super.firePropertyChange(type);
        }
    }

    public void setActive(boolean active) {
        this.inputContext.setSourceEditingMode(active);
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public boolean isActive() {
        return ((Object)((Object)this)).equals(this.editor.getActivePageInstance());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.control = children[children.length - 1];
        WorkbenchHelp.setHelp((Control)this.control, (String)"org.eclipse.pde.doc.user.manifest_source_page");
    }

    public Control getPartControl() {
        return this.control;
    }

    public String getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isEditor() {
        return true;
    }

    public InputContext getInputContext() {
        return this.inputContext;
    }

    public void setInputContext(InputContext inputContext) {
        this.inputContext = inputContext;
        this.setDocumentProvider(inputContext.getDocumentProvider());
    }

    public boolean selectReveal(Object object) {
        if (object instanceof IMarker) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)((IMarker)object));
            return true;
        }
        return false;
    }
}

