/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Vector;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.schema.SchemaObjectPropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ElementPropertySource
extends SchemaObjectPropertySource {
    public static final String P_LABEL_ATTRIBUTE = "labelAttribute";
    public static final String P_ICON = "icon";
    public static final String P_NAME = "name";
    public static final String KEY_NAME = "SchemaEditor.ElementPR.name";
    public static final String KEY_ICON = "SchemaEditor.ElementPR.icon";
    public static final String KEY_LABEL_ATTRIBUTE = "SchemaEditor.ElementPR.labelAttribute";
    public static final String KEY_INVALID = "SchemaEditor.ElementPR.invalid";
    private Vector descriptors;

    public ElementPropertySource(ISchemaElement extension) {
        super(extension);
    }

    private void fixReferences(SchemaElement element) {
        ((Schema)element.getSchema()).updateReferencesFor((ISchemaElement)element);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new Vector();
            PropertyDescriptor desc = this.createTextPropertyDescriptor(P_LABEL_ATTRIBUTE, PDEPlugin.getResourceString(KEY_LABEL_ATTRIBUTE));
            desc.setValidator((ICellEditorValidator)new LabelAttributeValidator());
            this.descriptors.addElement(desc);
            desc = this.createTextPropertyDescriptor(P_ICON, PDEPlugin.getResourceString(KEY_ICON));
            this.descriptors.addElement(desc);
            desc = this.createTextPropertyDescriptor(P_NAME, PDEPlugin.getResourceString(KEY_NAME));
            this.descriptors.addElement(desc);
        }
        return this.toDescriptorArray(this.descriptors);
    }

    public Object getPropertyValue(Object name) {
        ISchemaElement element = (ISchemaElement)this.getSourceObject();
        if (name.equals(P_LABEL_ATTRIBUTE)) {
            return this.getNonzeroValue(element.getLabelProperty());
        }
        if (name.equals(P_ICON)) {
            return this.getNonzeroValue(element.getIconProperty());
        }
        if (name.equals(P_NAME)) {
            return this.getNonzeroValue(element.getName());
        }
        return "";
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    private boolean isValidAttribute(String name) {
        if (name == null || name.length() == 0) {
            return true;
        }
        ISchemaElement element = (ISchemaElement)this.getSourceObject();
        return element.getAttribute(name) != null;
    }

    public void resetPropertyValue(Object property) {
    }

    public void setPropertyValue(Object name, Object value) {
        SchemaElement element = (SchemaElement)this.getSourceObject();
        String svalue = (String)value;
        if (name.equals(P_LABEL_ATTRIBUTE)) {
            element.setLabelProperty(svalue);
        } else if (name.equals(P_ICON)) {
            element.setIconProperty(svalue);
        } else if (name.equals(P_NAME)) {
            element.setName(svalue);
            this.fixReferences(element);
        }
    }

    class LabelAttributeValidator
    implements ICellEditorValidator {
        LabelAttributeValidator() {
        }

        public String isValid(Object value) {
            String svalue = value.toString();
            if (!ElementPropertySource.this.isValidAttribute(svalue)) {
                return PDEPlugin.getFormattedMessage(ElementPropertySource.KEY_INVALID, svalue);
            }
            return null;
        }
    }
}

