/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Hashtable;
import org.eclipse.jface.action.Action;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;

public class NewAttributeAction
extends Action {
    private SchemaElement element;
    private static final String NAME_COUNTER_KEY = "__schema_attribute_name";
    public static final String KEY_LABEL = "SchemaEditor.NewAttribute.label";
    public static final String KEY_TOOLTIP = "SchemaEditor.NewAttribute.tooltip";
    public static final String KEY_INITIAL_NAME = "SchemaEditor.NewAttribute.initialName";

    public NewAttributeAction() {
        this.setText(PDEPlugin.getResourceString(KEY_LABEL));
        this.setImageDescriptor(PDEPluginImages.DESC_ATT_IMPL_OBJ);
        this.setToolTipText(PDEPlugin.getResourceString(KEY_TOOLTIP));
    }

    public SchemaElement getElement() {
        return this.element;
    }

    private String getInitialName() {
        Hashtable counters = PDEPlugin.getDefault().getDefaultNameCounters();
        Integer counter = (Integer)counters.get(NAME_COUNTER_KEY);
        counter = counter == null ? new Integer(1) : new Integer(counter + 1);
        counters.put(NAME_COUNTER_KEY, counter);
        return PDEPlugin.getFormattedMessage(KEY_INITIAL_NAME, counter + "");
    }

    public void run() {
        String name = this.getInitialName();
        SchemaAttribute att = new SchemaAttribute((ISchemaObject)this.element, name);
        att.setType((ISchemaSimpleType)new SchemaSimpleType(this.element.getSchema(), "string"));
        ISchemaType type = this.element.getType();
        SchemaComplexType complexType = null;
        if (!(type instanceof ISchemaComplexType)) {
            complexType = new SchemaComplexType(this.element.getSchema());
            this.element.setType((ISchemaType)complexType);
        } else {
            complexType = (SchemaComplexType)type;
        }
        complexType.addAttribute((ISchemaAttribute)att);
    }

    public void setElement(SchemaElement newElement) {
        this.element = newElement;
    }
}

