/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteDescription;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.site.BaseNewDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewCategoryDefinitionDialog
extends BaseNewDialog {
    private static final String KEY_TITLE = "NewCategoryDefinitionDialog.title";
    private static final String KEY_NAME = "NewCategoryDefinitionDialog.name";
    private static final String KEY_LABEL = "NewCategoryDefinitionDialog.label";
    private static final String KEY_DESC = "NewCategoryDefinitionDialog.desc";
    private static final String KEY_EMPTY = "NewCategoryDefinitionDialog.empty";
    private Text nameText;
    private Text labelText;
    private Text descText;

    public NewCategoryDefinitionDialog(Shell shell, ISiteModel siteModel, ISiteCategoryDefinition def) {
        super(shell, siteModel, (ISiteObject)def);
    }

    protected void createEntries(Composite container) {
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_NAME));
        this.nameText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.nameText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_LABEL));
        this.labelText = new Text(container, 2052);
        gd = new GridData(768);
        this.labelText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_DESC));
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        this.descText = new Text(container, 2114);
        gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 225;
        this.descText.setLayoutData((Object)gd);
        if (this.getCategoryDefinition() == null) {
            this.presetFields();
        }
    }

    private void presetFields() {
    }

    private ISiteCategoryDefinition getCategoryDefinition() {
        return (ISiteCategoryDefinition)this.getSiteObject();
    }

    protected String getDialogTitle() {
        return PDEPlugin.getResourceString(KEY_TITLE);
    }

    protected String getHelpId() {
        return "org.eclipse.pde.doc.user.new_category_def_dialog";
    }

    protected String getEmptyErrorMessage() {
        return PDEPlugin.getResourceString(KEY_EMPTY);
    }

    protected void hookListeners(ModifyListener modifyListener) {
        this.nameText.addModifyListener(modifyListener);
        this.labelText.addModifyListener(modifyListener);
        this.descText.addModifyListener(modifyListener);
    }

    protected void initializeFields() {
        super.initializeFields();
        ISiteCategoryDefinition categoryDef = this.getCategoryDefinition();
        this.setIfDefined(this.nameText, categoryDef.getName());
        this.setIfDefined(this.labelText, categoryDef.getLabel());
        this.setIfDefined(this.descText, categoryDef.getDescription() != null ? categoryDef.getDescription().getText() : null);
    }

    protected void dialogChanged() {
        boolean edit = this.getCategoryDefinition() != null;
        IStatus status = null;
        String name = this.nameText.getText();
        if (name.length() == 0 || this.labelText.getText().length() == 0) {
            status = this.getEmptyErrorStatus();
        } else if (!edit && this.alreadyExists(name)) {
            status = this.createErrorStatus(PDEPlugin.getResourceString("NewCategoryDefinitionDialog.alreadyExists"));
        }
        if (status == null) {
            status = this.getOKStatus();
        }
        this.updateStatus(status);
    }

    private boolean alreadyExists(String name) {
        ISiteCategoryDefinition[] defs = this.getSiteModel().getSite().getCategoryDefinitions();
        for (int i = 0; i < defs.length; ++i) {
            ISiteCategoryDefinition def = defs[i];
            String dname = def.getName();
            if (dname == null || !dname.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected void execute() {
        boolean add = false;
        ISiteCategoryDefinition categoryDef = this.getCategoryDefinition();
        ISiteModel siteModel = this.getSiteModel();
        if (categoryDef == null) {
            add = true;
            categoryDef = siteModel.getFactory().createCategoryDefinition();
        }
        try {
            categoryDef.setName(this.nameText.getText());
            categoryDef.setLabel(this.labelText.getText());
            String desc = this.descText.getText();
            if (desc.length() > 0) {
                ISiteDescription description = categoryDef.getDescription();
                if (description == null) {
                    description = siteModel.getFactory().createDescription((ISiteObject)categoryDef);
                }
                description.setText(desc);
                categoryDef.setDescription(description);
            } else {
                categoryDef.setDescription(null);
            }
            if (add) {
                siteModel.getSite().addCategoryDefinitions(new ISiteCategoryDefinition[]{categoryDef});
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }
}

