/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.PluginJavaSearchUtil;

public class UnusedDependenciesOperation
implements IRunnableWithProgress {
    private IPluginModelBase model;
    private IProject parentProject;
    HashSet unused = new HashSet();

    public UnusedDependenciesOperation(IPluginModelBase model) {
        this.model = model;
        this.parentProject = model.getUnderlyingResource().getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) {
        try {
            IPluginImport[] imports = this.model.getPluginBase().getImports();
            if (imports.length == 0) {
                return;
            }
            monitor.setTaskName(PDEPlugin.getResourceString("UnusedDependencies.analyze"));
            monitor.beginTask("", imports.length);
            for (int i = 0; i < imports.length; ++i) {
                if (!this.isUsed(imports[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                    this.unused.add(imports[i]);
                }
                monitor.setTaskName(PDEPlugin.getResourceString("UnusedDependencies.analyze") + this.unused.size() + " " + PDEPlugin.getResourceString("UnusedDependencies.unused") + " " + (this.unused.size() == 1 ? PDEPlugin.getResourceString("DependencyExtent.singular") : PDEPlugin.getResourceString("DependencyExtent.plural")) + " " + PDEPlugin.getResourceString("DependencyExtent.found"));
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUsed(IPluginImport dependency, IProgressMonitor monitor) {
        try {
            HashSet set = new HashSet();
            PluginJavaSearchUtil.collectAllPrerequisites(PDECore.getDefault().findPlugin(dependency.getId()), set);
            IPluginBase[] models = set.toArray(new IPluginBase[set.size()]);
            IPackageFragment[] packageFragments = new IPackageFragment[]{};
            if (this.parentProject.hasNature("org.eclipse.jdt.core.javanature")) {
                packageFragments = PluginJavaSearchUtil.collectPackageFragments(models, this.parentProject);
            }
            monitor.beginTask("", packageFragments.length + 1);
            if (this.providesExtensionPoint(models)) {
                boolean bl = true;
                return bl;
            }
            monitor.worked(1);
            if (packageFragments.length > 0) {
                boolean bl = this.doJavaSearch(packageFragments, (IProgressMonitor)new SubProgressMonitor(monitor, packageFragments.length));
                return bl;
            }
        }
        catch (JavaModelException e) {
        }
        catch (CoreException coreException) {
        }
        finally {
            monitor.done();
        }
        return false;
    }

    public IPluginImport[] getUnusedDependencies() {
        return this.unused.toArray(new IPluginImport[this.unused.size()]);
    }

    private boolean providesExtensionPoint(IPluginBase[] models) {
        IPluginExtension[] extensions = this.model.getPluginBase().getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            for (int j = 0; j < models.length; ++j) {
                if (!this.providesExtensionPoint(models[j], extensions[i].getPoint())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean providesExtensionPoint(IPluginBase model, String targetID) {
        IPluginExtensionPoint[] extPoints = model.getExtensionPoints();
        for (int i = 0; i < extPoints.length; ++i) {
            if (!extPoints[i].getFullId().equals(targetID)) continue;
            return true;
        }
        return false;
    }

    private boolean doJavaSearch(IPackageFragment[] packageFragments, IProgressMonitor monitor) throws JavaModelException {
        SearchEngine searchEngine = new SearchEngine();
        IJavaSearchScope scope = this.getSearchScope();
        for (int i = 0; i < packageFragments.length; ++i) {
            IPackageFragment packageFragment = packageFragments[i];
            boolean used = false;
            if (!packageFragment.hasSubpackages()) {
                SearchResultCollector collector = new SearchResultCollector();
                searchEngine.search(PDEPlugin.getWorkspace(), SearchEngine.createSearchPattern((String)(packageFragment.getElementName() + ".*"), (int)0, (int)2, (boolean)true), scope, (IJavaSearchResultCollector)collector);
                used = !collector.isEmpty();
            } else {
                used = this.searchForTypes(packageFragment, searchEngine, scope, monitor);
            }
            monitor.worked(1);
            if (!used) continue;
            return true;
        }
        return false;
    }

    private boolean searchForTypes(IPackageFragment fragment, SearchEngine searchEngine, IJavaSearchScope scope, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] children = fragment.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IJavaElement child = children[i];
            IType[] types = new IType[]{};
            if (child instanceof IClassFile) {
                types = new IType[]{((IClassFile)child).getType()};
            } else if (child instanceof ICompilationUnit) {
                types = ((ICompilationUnit)child).getAllTypes();
            }
            for (int j = 0; j < types.length; ++j) {
                SearchResultCollector collector = new SearchResultCollector();
                searchEngine.search(PDEPlugin.getWorkspace(), SearchEngine.createSearchPattern((IJavaElement)types[j], (int)2), scope, (IJavaSearchResultCollector)collector);
                if (collector.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private IJavaSearchScope getSearchScope() throws JavaModelException {
        IPackageFragmentRoot[] roots = JavaCore.create((IProject)this.parentProject).getPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> filteredRoots = new ArrayList<IPackageFragmentRoot>();
        for (int i = 0; i < roots.length; ++i) {
            if (roots[i].getResource() == null || !roots[i].getResource().getProject().equals(this.parentProject)) continue;
            filteredRoots.add(roots[i]);
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])filteredRoots.toArray(new IJavaElement[filteredRoots.size()]));
    }

    class SearchResultCollector
    implements IJavaSearchResultCollector {
        int count = 0;

        SearchResultCollector() {
        }

        public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
            if (accuracy == 0) {
                ++this.count;
            }
        }

        public void aboutToStart() {
        }

        public void done() {
        }

        public IProgressMonitor getProgressMonitor() {
            return null;
        }

        public boolean isEmpty() {
            return this.count == 0;
        }
    }
}

