/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Javadoc
extends ASTNode {
    public JavadocSingleNameReference[] parameters;
    public TypeReference[] thrownExceptions;
    public JavadocReturnStatement returnStatement;
    public Expression[] references;
    public boolean inherited = false;
    public JavadocSingleNameReference[] invalidParameters;

    public Javadoc(int sourceStart, int sourceEnd) {
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        int i;
        int length;
        Javadoc.printIndent(indent, output).append("/**\n");
        if (this.parameters != null) {
            length = this.parameters.length;
            for (i = 0; i < length; ++i) {
                Javadoc.printIndent(indent + 1, output).append(" * @param ");
                this.parameters[i].print(indent, output).append('\n');
            }
        }
        if (this.returnStatement != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @return\n");
        }
        if (this.thrownExceptions != null) {
            length = this.thrownExceptions.length;
            for (i = 0; i < length; ++i) {
                Javadoc.printIndent(indent + 1, output).append(" * @throws ");
                this.thrownExceptions[i].print(indent, output).append('\n');
            }
        }
        if (this.references != null) {
            length = this.references.length;
            for (i = 0; i < length; ++i) {
                Javadoc.printIndent(indent + 1, output).append(" * @see");
                this.references[i].print(indent, output).append('\n');
            }
        }
        Javadoc.printIndent(indent, output).append(" */\n");
        return output;
    }

    public void resolve(ClassScope classScope) {
        int paramTagsSize = this.parameters == null ? 0 : this.parameters.length;
        for (int i = 0; i < paramTagsSize; ++i) {
            JavadocSingleNameReference param = this.parameters[i];
            classScope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
        }
        if (this.returnStatement != null) {
            classScope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        int throwsTagsLength = this.thrownExceptions == null ? 0 : this.thrownExceptions.length;
        for (int i = 0; i < throwsTagsLength; ++i) {
            int end;
            int start;
            TypeReference typeRef = this.thrownExceptions[i];
            if (typeRef instanceof JavadocSingleTypeReference) {
                JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                start = singleRef.tagSourceStart;
                end = singleRef.tagSourceEnd;
            } else if (typeRef instanceof JavadocQualifiedTypeReference) {
                JavadocQualifiedTypeReference qualifiedRef = (JavadocQualifiedTypeReference)typeRef;
                start = qualifiedRef.tagSourceStart;
                end = qualifiedRef.tagSourceEnd;
            } else {
                start = typeRef.sourceStart;
                end = typeRef.sourceEnd;
            }
            classScope.problemReporter().javadocUnexpectedTag(start, end);
        }
        int seeTagsLength = this.references == null ? 0 : this.references.length;
        for (int i = 0; i < seeTagsLength; ++i) {
            this.references[i].resolveType(classScope);
            if (!(this.references[i] instanceof JavadocFieldReference)) continue;
            JavadocFieldReference fieldRef = (JavadocFieldReference)this.references[i];
            if (fieldRef.receiverType == null || fieldRef.binding != null) continue;
            JavadocMessageSend msgSend = new JavadocMessageSend(fieldRef.token, fieldRef.nameSourcePosition);
            msgSend.receiver = fieldRef.receiver;
            msgSend.receiverType = fieldRef.receiverType;
            msgSend.qualifyingType = fieldRef.receiverType;
            msgSend.superAccess = classScope.enclosingSourceType().isCompatibleWith(msgSend.receiverType);
            msgSend.binding = classScope.findMethod((ReferenceBinding)msgSend.receiverType, msgSend.selector, new TypeBinding[0], msgSend);
            this.references[i] = msgSend;
        }
    }

    public void resolve(MethodScope methScope) {
        AbstractMethodDeclaration methDecl = methScope.referenceMethod();
        boolean overriding = methDecl == null ? false : (methDecl.binding.modifiers & 0x30000000) != 0;
        int seeTagsLength = this.references == null ? 0 : this.references.length;
        boolean superRef = false;
        for (int i = 0; i < seeTagsLength; ++i) {
            this.references[i].resolveType(methScope);
            if (this.references[i] instanceof JavadocFieldReference) {
                JavadocFieldReference fieldRef = (JavadocFieldReference)this.references[i];
                if (fieldRef.receiverType != null && fieldRef.binding == null) {
                    JavadocMessageSend msgSend = new JavadocMessageSend(fieldRef.token, fieldRef.nameSourcePosition);
                    msgSend.receiver = fieldRef.receiver;
                    msgSend.receiverType = fieldRef.receiverType;
                    msgSend.qualifyingType = fieldRef.receiverType;
                    msgSend.superAccess = methScope.enclosingSourceType().isCompatibleWith(msgSend.receiverType);
                    msgSend.binding = methScope.findMethod((ReferenceBinding)msgSend.receiverType, msgSend.selector, new TypeBinding[0], msgSend);
                    this.references[i] = msgSend;
                }
            }
            try {
                if (methDecl == null || !methDecl.isConstructor() && !overriding || superRef) continue;
                if (this.references[i] instanceof JavadocMessageSend) {
                    JavadocMessageSend messageSend = (JavadocMessageSend)this.references[i];
                    if (messageSend.binding == null || !messageSend.binding.isValidBinding() || !methDecl.binding.declaringClass.isCompatibleWith(messageSend.receiverType) || !CharOperation.equals(messageSend.selector, methDecl.selector) || messageSend.binding.returnType != methDecl.binding.returnType) continue;
                    if (messageSend.arguments == null && methDecl.arguments == null) {
                        superRef = true;
                        continue;
                    }
                    if (messageSend.arguments == null || methDecl.arguments == null) continue;
                    superRef = methDecl.binding.areParametersEqual(messageSend.binding);
                    continue;
                }
                if (!(this.references[i] instanceof JavadocAllocationExpression)) continue;
                JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.references[i];
                if (allocationExpr.binding == null || !allocationExpr.binding.isValidBinding() || !methDecl.binding.declaringClass.isCompatibleWith(allocationExpr.resolvedType)) continue;
                if (allocationExpr.arguments == null && methDecl.arguments == null) {
                    superRef = true;
                    continue;
                }
                if (allocationExpr.arguments == null || methDecl.arguments == null) continue;
                superRef = methDecl.binding.areParametersEqual(allocationExpr.binding);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean reportMissing = methDecl == null || (!overriding || !this.inherited) && !superRef && (methDecl.binding.declaringClass == null || !methDecl.binding.declaringClass.isLocalType());
        this.resolveParamTags(methScope, reportMissing);
        if (this.returnStatement == null) {
            if (reportMissing && methDecl != null && !methDecl.isConstructor() && !methDecl.isClinit()) {
                MethodDeclaration meth = (MethodDeclaration)methDecl;
                if (meth.binding.returnType != BaseTypes.VoidBinding) {
                    methScope.problemReporter().javadocMissingReturnTag(meth.returnType.sourceStart, meth.returnType.sourceEnd, methDecl.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methScope);
        }
        this.resolveThrowsTags(methScope, reportMissing);
        int length = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        for (int i = 0; i < length; ++i) {
            this.invalidParameters[i].resolve(methScope, false);
        }
    }

    private void resolveParamTags(MethodScope methScope, boolean reportMissing) {
        block9: {
            int j;
            boolean found;
            int i;
            int argumentsSize;
            int paramTagsSize;
            AbstractMethodDeclaration md;
            block8: {
                md = methScope.referenceMethod();
                int n = paramTagsSize = this.parameters == null ? 0 : this.parameters.length;
                if (md == null) {
                    for (int i2 = 0; i2 < paramTagsSize; ++i2) {
                        JavadocSingleNameReference param = this.parameters[i2];
                        methScope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                    }
                    return;
                }
                int n2 = argumentsSize = md.arguments == null ? 0 : md.arguments.length;
                if (paramTagsSize != 0) break block8;
                if (!reportMissing) break block9;
                for (int i3 = 0; i3 < argumentsSize; ++i3) {
                    Argument arg = md.arguments[i3];
                    methScope.problemReporter().javadocMissingParamTag(arg, md.binding.modifiers);
                }
                break block9;
            }
            LocalVariableBinding[] bindings = new LocalVariableBinding[paramTagsSize];
            int maxBindings = 0;
            for (i = 0; i < paramTagsSize; ++i) {
                JavadocSingleNameReference param = this.parameters[i];
                param.resolve(methScope);
                if (param.binding == null || !param.binding.isValidBinding()) continue;
                found = false;
                for (j = 0; j < maxBindings && !found; ++j) {
                    if (bindings[j] != param.binding) continue;
                    methScope.problemReporter().javadocDuplicatedParamTag(param, md.binding.modifiers);
                    found = true;
                }
                if (found) continue;
                bindings[maxBindings++] = (LocalVariableBinding)param.binding;
            }
            if (reportMissing) {
                for (i = 0; i < argumentsSize; ++i) {
                    Argument arg = md.arguments[i];
                    found = false;
                    for (j = 0; j < maxBindings && !found; ++j) {
                        LocalVariableBinding binding = bindings[j];
                        if (arg.binding != binding) continue;
                        found = true;
                    }
                    if (found) continue;
                    methScope.problemReporter().javadocMissingParamTag(arg, md.binding.modifiers);
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methScope, boolean reportMissing) {
        block14: {
            int j;
            TypeReference typeRef;
            int i;
            int thrownExceptionLength;
            int boundExceptionLength;
            int throwsTagsLength;
            AbstractMethodDeclaration md;
            block13: {
                md = methScope.referenceMethod();
                int n = throwsTagsLength = this.thrownExceptions == null ? 0 : this.thrownExceptions.length;
                if (md == null) {
                    for (int i2 = 0; i2 < throwsTagsLength; ++i2) {
                        TypeReference typeRef2 = this.thrownExceptions[i2];
                        int start = typeRef2.sourceStart;
                        int end = typeRef2.sourceEnd;
                        if (typeRef2 instanceof JavadocQualifiedTypeReference) {
                            start = ((JavadocQualifiedTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocQualifiedTypeReference)typeRef2).tagSourceEnd;
                        } else if (typeRef2 instanceof JavadocSingleTypeReference) {
                            start = ((JavadocSingleTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocSingleTypeReference)typeRef2).tagSourceEnd;
                        }
                        methScope.problemReporter().javadocUnexpectedTag(start, end);
                    }
                    return;
                }
                boundExceptionLength = md.binding == null || md.binding.thrownExceptions == null ? 0 : md.binding.thrownExceptions.length;
                int n2 = thrownExceptionLength = md.thrownExceptions == null ? 0 : md.thrownExceptions.length;
                if (throwsTagsLength != 0) break block13;
                if (!reportMissing) break block14;
                for (int i3 = 0; i3 < boundExceptionLength; ++i3) {
                    int j2;
                    ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i3];
                    if (exceptionBinding == null || !exceptionBinding.isValidBinding()) continue;
                    for (j2 = i3; j2 < thrownExceptionLength && exceptionBinding != md.thrownExceptions[j2].resolvedType; ++j2) {
                    }
                    if (j2 >= thrownExceptionLength) continue;
                    methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[j2], md.binding.modifiers);
                }
                break block14;
            }
            int maxRef = 0;
            TypeReference[] typeReferences = new TypeReference[throwsTagsLength];
            for (i = 0; i < throwsTagsLength; ++i) {
                typeRef = this.thrownExceptions[i];
                typeRef.resolve(methScope);
                TypeBinding typeBinding = typeRef.resolvedType;
                if (typeBinding == null || !typeBinding.isValidBinding() || !typeBinding.isClass()) continue;
                typeReferences[maxRef++] = typeRef;
            }
            for (i = 0; i < boundExceptionLength; ++i) {
                int k;
                ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i];
                boolean found = false;
                for (j = 0; j < maxRef && !found; ++j) {
                    TypeBinding typeBinding;
                    if (typeReferences[j] == null || exceptionBinding != (typeBinding = typeReferences[j].resolvedType)) continue;
                    found = true;
                    typeReferences[j] = null;
                }
                if (found || !reportMissing || exceptionBinding == null || !exceptionBinding.isValidBinding()) continue;
                for (k = i; k < thrownExceptionLength && exceptionBinding != md.thrownExceptions[k].resolvedType; ++k) {
                }
                if (k >= thrownExceptionLength) continue;
                methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[k], md.binding.modifiers);
            }
            for (i = 0; i < maxRef; ++i) {
                typeRef = typeReferences[i];
                if (typeRef == null) continue;
                boolean compatible = false;
                for (j = 0; j < thrownExceptionLength && !compatible; ++j) {
                    TypeBinding exceptionBinding = md.thrownExceptions[j].resolvedType;
                    if (exceptionBinding == null) continue;
                    compatible = typeRef.resolvedType.isCompatibleWith(exceptionBinding);
                }
                if (compatible || typeRef.resolvedType.isCompatibleWith(methScope.getJavaLangRuntimeException()) || typeRef.resolvedType.isCompatibleWith(methScope.getJavaLangError())) continue;
                methScope.problemReporter().javadocInvalidThrowsClassName(typeRef, md.binding.modifiers);
            }
        }
    }

    public ASTNode getNodeStartingAt(int start) {
        JavadocSingleNameReference param;
        int i;
        if (this.parameters != null) {
            for (i = 0; i < this.parameters.length; ++i) {
                param = this.parameters[i];
                if (param.sourceStart != start) continue;
                return param;
            }
        }
        if (this.invalidParameters != null) {
            for (i = 0; i < this.invalidParameters.length; ++i) {
                param = this.invalidParameters[i];
                if (param.sourceStart != start) continue;
                return param;
            }
        }
        if (this.thrownExceptions != null) {
            for (i = 0; i < this.thrownExceptions.length; ++i) {
                TypeReference typeRef = this.thrownExceptions[i];
                if (typeRef.sourceStart != start) continue;
                return typeRef;
            }
        }
        if (this.references != null) {
            for (i = 0; i < this.references.length; ++i) {
                int j;
                Expression expression = this.references[i];
                if (expression.sourceStart == start) {
                    return expression;
                }
                if (expression instanceof JavadocAllocationExpression) {
                    JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.references[i];
                    if (allocationExpr.binding == null || !allocationExpr.binding.isValidBinding() || allocationExpr.arguments == null) continue;
                    for (j = 0; j < allocationExpr.arguments.length; ++j) {
                        if (allocationExpr.arguments[j].sourceStart != start) continue;
                        return allocationExpr.arguments[j];
                    }
                    continue;
                }
                if (!(expression instanceof JavadocMessageSend)) continue;
                JavadocMessageSend messageSend = (JavadocMessageSend)this.references[i];
                if (messageSend.binding == null || !messageSend.binding.isValidBinding() || messageSend.arguments == null) continue;
                for (j = 0; j < messageSend.arguments.length; ++j) {
                    if (messageSend.arguments[j].sourceStart != start) continue;
                    return messageSend.arguments[j];
                }
            }
        }
        return null;
    }
}

