/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.feature.FeatureObject;
import org.eclipse.pde.internal.core.feature.FeatureURLElement;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureURL
extends FeatureObject
implements IFeatureURL {
    private Vector updates = new Vector();
    private Vector discoveries = new Vector();

    public void addDiscovery(IFeatureURLElement discovery) throws CoreException {
        this.ensureModelEditable();
        this.discoveries.add(discovery);
        ((FeatureURLElement)discovery).setInTheModel(true);
        this.fireStructureChanged(discovery, 1);
    }

    public void addUpdate(IFeatureURLElement update) throws CoreException {
        this.ensureModelEditable();
        this.updates.add(update);
        ((FeatureURLElement)update).setInTheModel(true);
        this.fireStructureChanged(update, 1);
    }

    public IFeatureURLElement[] getDiscoveries() {
        Object[] result = new IFeatureURLElement[this.discoveries.size()];
        this.discoveries.copyInto(result);
        return result;
    }

    public IFeatureURLElement[] getUpdates() {
        Object[] result = new IFeatureURLElement[this.updates.size()];
        this.updates.copyInto(result);
        return result;
    }

    protected void parse(Node node, Hashtable lineTable) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String tag = child.getNodeName().toLowerCase();
            int urlType = -1;
            if (tag.equals("update")) {
                urlType = 1;
            } else if (tag.equals("discovery")) {
                urlType = 2;
            }
            if (urlType == -1) continue;
            IFeatureURLElement element = this.getModel().getFactory().createURLElement(this, urlType);
            ((FeatureURLElement)element).parse(child, lineTable);
            if (urlType == 1) {
                ((FeatureURLElement)element).setInTheModel(true);
                this.updates.add(element);
                continue;
            }
            if (urlType != 2) continue;
            ((FeatureURLElement)element).setInTheModel(true);
            this.discoveries.add(element);
        }
    }

    public void removeDiscovery(IFeatureURLElement discovery) throws CoreException {
        this.ensureModelEditable();
        this.discoveries.remove(discovery);
        ((FeatureURLElement)discovery).setInTheModel(false);
        this.fireStructureChanged(discovery, 2);
    }

    public void removeUpdate(IFeatureURLElement update) throws CoreException {
        this.ensureModelEditable();
        ((FeatureURLElement)update).setInTheModel(false);
        this.updates.remove(update);
        this.fireStructureChanged(update, 2);
    }

    public void write(String indent, PrintWriter writer) {
        IFeatureURLElement element;
        int i;
        writer.println(indent + "<url>");
        String indent2 = indent + "   ";
        for (i = 0; i < this.updates.size(); ++i) {
            element = (IFeatureURLElement)this.updates.elementAt(i);
            element.write(indent2, writer);
        }
        for (i = 0; i < this.discoveries.size(); ++i) {
            element = (IFeatureURLElement)this.discoveries.elementAt(i);
            element.write(indent2, writer);
        }
        writer.println(indent + "</url>");
    }
}

