/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.intro.IIntroDescriptor;
import org.eclipse.ui.internal.intro.IIntroRegistry;

public class IntroRegistry
implements IIntroRegistry {
    private static final String ATT_INTROID = "introId";
    private static final String ATT_PRODUCTID = "productId";
    private Map bindingMap = new HashMap(7);
    private ArrayList intros = new ArrayList(10);

    public void add(IIntroDescriptor descriptor) {
        this.intros.add(descriptor);
    }

    public void addBinding(IConfigurationElement element) throws CoreException {
        String introId = element.getAttribute(ATT_INTROID);
        String productId = element.getAttribute(ATT_PRODUCTID);
        if (introId == null || productId == null) {
            Status status = new Status(4, element.getDeclaringExtension().getNamespace(), 4, "introId and productId must be defined.", (Throwable)new IllegalArgumentException());
            throw new CoreException((IStatus)status);
        }
        if (this.bindingMap.containsKey(productId)) {
            Status status = new Status(2, element.getDeclaringExtension().getNamespace(), 2, productId + " already has an intro binding.  Omitting binding to" + introId, (Throwable)new IllegalArgumentException());
            throw new CoreException((IStatus)status);
        }
        this.bindingMap.put(productId, introId);
    }

    public int getIntroCount() {
        return this.intros.size();
    }

    public IIntroDescriptor[] getIntros() {
        return this.intros.toArray(new IIntroDescriptor[this.intros.size()]);
    }

    public IIntroDescriptor getIntroForProduct(String productId) {
        IIntroDescriptor descriptor = null;
        String introId = (String)this.bindingMap.get(productId);
        if (introId != null) {
            IIntroDescriptor[] introDescs = this.getIntros();
            for (int i = 0; i < introDescs.length; ++i) {
                if (!introDescs[i].getId().equals(introId)) continue;
                descriptor = introDescs[i];
                break;
            }
        }
        return descriptor;
    }

    public IIntroDescriptor getIntro(String id) {
        Iterator i = this.intros.iterator();
        while (i.hasNext()) {
            IIntroDescriptor desc = (IIntroDescriptor)i.next();
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }
}

