/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetEntryListener;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class PropertySheetEntry
implements IPropertySheetEntry {
    private Object[] values = new Object[0];
    private Map sources = new HashMap(0);
    private Object editValue;
    private PropertySheetEntry parent;
    private IPropertySourceProvider propertySourceProvider;
    private IPropertyDescriptor descriptor;
    private CellEditor editor;
    private String errorText;
    private PropertySheetEntry[] childEntries = null;
    private ListenerList listeners = new ListenerList();
    private ICellEditorListener cellEditorListener = new ICellEditorListener(){

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            if (!newValidState) {
                PropertySheetEntry.this.setErrorText(PropertySheetEntry.this.editor.getErrorMessage());
            } else {
                PropertySheetEntry.this.setErrorText(null);
            }
        }

        public void cancelEditor() {
            PropertySheetEntry.this.setErrorText(null);
        }

        public void applyEditorValue() {
            PropertySheetEntry.this.applyEditorValue();
        }
    };
    static /* synthetic */ Class class$org$eclipse$ui$views$properties$IPropertySource;

    public void addPropertySheetEntryListener(IPropertySheetEntryListener listener) {
        this.listeners.add((Object)listener);
    }

    public void applyEditorValue() {
        if (this.editor == null) {
            return;
        }
        if (!this.editor.isValueValid()) {
            this.setErrorText(this.editor.getErrorMessage());
            return;
        }
        this.setErrorText(null);
        Object newValue = this.editor.getValue();
        boolean changed = false;
        if (this.values.length > 1) {
            changed = true;
        } else if (this.editValue == null) {
            if (newValue != null) {
                changed = true;
            }
        } else if (!this.editValue.equals(newValue)) {
            changed = true;
        }
        if (changed) {
            this.setValue(newValue);
        }
    }

    private List computeMergedPropertyDescriptors() {
        if (this.values.length == 0) {
            return new ArrayList(0);
        }
        Map[] propertyDescriptorMaps = new Map[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            Object object = this.values[i];
            IPropertySource source = this.getPropertySource(object);
            if (source == null) {
                return new ArrayList(0);
            }
            propertyDescriptorMaps[i] = this.computePropertyDescriptorsFor(source);
        }
        Map intersection = propertyDescriptorMaps[0];
        for (int i = 1; i < propertyDescriptorMaps.length; ++i) {
            Object[] ids = intersection.keySet().toArray();
            for (int j = 0; j < ids.length; ++j) {
                Object object = propertyDescriptorMaps[i].get(ids[j]);
                if (object != null && ((IPropertyDescriptor)intersection.get(ids[j])).isCompatibleWith((IPropertyDescriptor)object)) continue;
                intersection.remove(ids[j]);
            }
        }
        ArrayList descriptors = new ArrayList(intersection.values());
        Collections.sort(descriptors, new Comparator(){
            Collator coll = Collator.getInstance(Locale.getDefault());

            public int compare(Object a, Object b) {
                IPropertyDescriptor d1 = (IPropertyDescriptor)a;
                String dname1 = d1.getDisplayName();
                IPropertyDescriptor d2 = (IPropertyDescriptor)b;
                String dname2 = d2.getDisplayName();
                return this.coll.compare(dname1, dname2);
            }
        });
        return descriptors;
    }

    private Map computePropertyDescriptorsFor(IPropertySource source) {
        IPropertyDescriptor[] descriptors = source.getPropertyDescriptors();
        HashMap<Object, IPropertyDescriptor> result = new HashMap<Object, IPropertyDescriptor>(descriptors.length * 2 + 1);
        for (int i = 0; i < descriptors.length; ++i) {
            result.put(descriptors[i].getId(), descriptors[i]);
        }
        return result;
    }

    private void createChildEntries() {
        List descriptors = this.computeMergedPropertyDescriptors();
        this.childEntries = new PropertySheetEntry[descriptors.size()];
        for (int i = 0; i < descriptors.size(); ++i) {
            IPropertyDescriptor d = (IPropertyDescriptor)descriptors.get(i);
            PropertySheetEntry entry = new PropertySheetEntry();
            entry.setDescriptor(d);
            entry.setParent(this);
            entry.setPropertySourceProvider(this.propertySourceProvider);
            entry.refreshValues();
            this.childEntries[i] = entry;
        }
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.childEntries != null) {
            for (int i = 0; i < this.childEntries.length; ++i) {
                if (this.childEntries[i] == null) continue;
                this.childEntries[i].dispose();
            }
        }
    }

    private void fireChildEntriesChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] array = this.listeners.getListeners();
        for (int i = 0; i < array.length; ++i) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.childEntriesChanged(this);
        }
    }

    private void fireErrorMessageChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] array = this.listeners.getListeners();
        for (int i = 0; i < array.length; ++i) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.errorMessageChanged(this);
        }
    }

    private void fireValueChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] array = this.listeners.getListeners();
        for (int i = 0; i < array.length; ++i) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.valueChanged(this);
        }
    }

    public String getCategory() {
        return this.descriptor.getCategory();
    }

    public IPropertySheetEntry[] getChildEntries() {
        if (this.childEntries == null) {
            this.createChildEntries();
        }
        return this.childEntries;
    }

    public String getDescription() {
        return this.descriptor.getDescription();
    }

    private IPropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    public CellEditor getEditor(Composite parent) {
        if (this.editor == null) {
            this.editor = this.descriptor.createPropertyEditor(parent);
            if (this.editor != null) {
                this.editor.addListener(this.cellEditorListener);
            }
        }
        if (this.editor != null) {
            this.editor.setValue(this.editValue);
            this.setErrorText(this.editor.getErrorMessage());
        }
        return this.editor;
    }

    protected Object getEditValue(int index) {
        Object value = this.values[index];
        IPropertySource source = this.getPropertySource(value);
        if (source != null) {
            value = source.getEditableValue();
        }
        return value;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public String[] getFilters() {
        return this.descriptor.getFilterFlags();
    }

    public Object getHelpContextIds() {
        return this.descriptor.getHelpContextIds();
    }

    public Image getImage() {
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider == null) {
            return null;
        }
        return provider.getImage(this.editValue);
    }

    private IPropertySource getPropertySource(Object object) {
        if (this.sources.containsKey(object)) {
            return (IPropertySource)this.sources.get(object);
        }
        IPropertySource result = null;
        if (this.propertySourceProvider != null) {
            result = this.propertySourceProvider.getPropertySource(object);
        } else if (object instanceof IPropertySource) {
            result = (IPropertySource)object;
        } else if (object instanceof IAdaptable) {
            result = (IPropertySource)((IAdaptable)object).getAdapter(class$org$eclipse$ui$views$properties$IPropertySource == null ? (class$org$eclipse$ui$views$properties$IPropertySource = PropertySheetEntry.class$("org.eclipse.ui.views.properties.IPropertySource")) : class$org$eclipse$ui$views$properties$IPropertySource);
        }
        this.sources.put(object, result);
        return result;
    }

    public String getValueAsString() {
        if (this.editValue == null) {
            return "";
        }
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider == null) {
            return this.editValue.toString();
        }
        return provider.getText(this.editValue);
    }

    private Object[] getValues() {
        return this.values;
    }

    public boolean hasChildEntries() {
        if (this.childEntries != null && this.childEntries.length > 0) {
            return true;
        }
        return this.computeMergedPropertyDescriptors().size() > 0;
    }

    private void refreshChildEntries() {
        int i;
        if (this.childEntries == null) {
            return;
        }
        List descriptors = this.computeMergedPropertyDescriptors();
        HashMap<Object, PropertySheetEntry> entryCache = new HashMap<Object, PropertySheetEntry>(this.childEntries.length * 2 + 1);
        for (int i2 = 0; i2 < this.childEntries.length; ++i2) {
            entryCache.put(this.childEntries[i2].getDescriptor().getId(), this.childEntries[i2]);
        }
        ArrayList<PropertySheetEntry> entriesToDispose = new ArrayList<PropertySheetEntry>(Arrays.asList(this.childEntries));
        this.childEntries = new PropertySheetEntry[descriptors.size()];
        boolean entriesChanged = descriptors.size() != entryCache.size();
        for (i = 0; i < descriptors.size(); ++i) {
            IPropertyDescriptor d = (IPropertyDescriptor)descriptors.get(i);
            PropertySheetEntry entry = (PropertySheetEntry)entryCache.get(d.getId());
            if (entry != null) {
                entry.setDescriptor(d);
                entriesToDispose.remove(entry);
            } else {
                entry = new PropertySheetEntry();
                entry.setDescriptor(d);
                entry.setParent(this);
                entry.setPropertySourceProvider(this.propertySourceProvider);
                entriesChanged = true;
            }
            entry.refreshValues();
            this.childEntries[i] = entry;
        }
        if (entriesChanged) {
            this.fireChildEntriesChanged();
        }
        for (i = 0; i < entriesToDispose.size(); ++i) {
            ((IPropertySheetEntry)entriesToDispose.get(i)).dispose();
        }
    }

    private void refreshFromRoot() {
        if (this.parent == null) {
            this.refreshChildEntries();
        } else {
            this.parent.refreshFromRoot();
        }
    }

    private void refreshValues() {
        Object[] currentSources = this.parent.getValues();
        Object[] newValues = new Object[currentSources.length];
        for (int i = 0; i < currentSources.length; ++i) {
            IPropertySource source = this.parent.getPropertySource(currentSources[i]);
            newValues[i] = source.getPropertyValue(this.descriptor.getId());
        }
        this.setValues(newValues);
    }

    public void removePropertySheetEntryListener(IPropertySheetEntryListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void resetPropertyValue() {
        if (this.parent == null) {
            return;
        }
        boolean change = false;
        Object[] objects = this.parent.getValues();
        for (int i = 0; i < objects.length; ++i) {
            IPropertySource2 extendedSource;
            IPropertySource source = this.getPropertySource(objects[i]);
            if (!source.isPropertySet(this.descriptor.getId()) || source instanceof IPropertySource2 && !(extendedSource = (IPropertySource2)source).isPropertyResettable(this.descriptor.getId())) continue;
            source.resetPropertyValue(this.descriptor.getId());
            change = true;
        }
        if (change) {
            this.refreshFromRoot();
        }
    }

    private void setDescriptor(IPropertyDescriptor newDescriptor) {
        if (this.descriptor != newDescriptor && this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        this.descriptor = newDescriptor;
    }

    private void setErrorText(String newErrorText) {
        this.errorText = newErrorText;
        this.fireErrorMessageChanged();
    }

    private void setParent(PropertySheetEntry propertySheetEntry) {
        this.parent = propertySheetEntry;
    }

    public void setPropertySourceProvider(IPropertySourceProvider provider) {
        this.propertySourceProvider = provider;
    }

    private void setValue(Object newValue) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = newValue;
        }
        this.parent.valueChanged(this);
        this.refreshFromRoot();
    }

    public void setValues(Object[] objects) {
        this.values = objects;
        this.sources = new HashMap(this.values.length * 2 + 1);
        if (this.values.length == 0) {
            this.editValue = null;
        } else {
            Object newValue = this.values[0];
            IPropertySource source = this.getPropertySource(newValue);
            if (source != null) {
                newValue = source.getEditableValue();
            }
            this.editValue = newValue;
        }
        this.refreshChildEntries();
        this.fireValueChanged();
    }

    protected void valueChanged(PropertySheetEntry child) {
        for (int i = 0; i < this.values.length; ++i) {
            IPropertySource source = this.getPropertySource(this.values[i]);
            source.setPropertyValue(child.getDescriptor().getId(), child.getEditValue(i));
        }
        if (this.parent != null) {
            this.parent.valueChanged(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

