/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;

public class BreakpointFieldLocator
extends ASTVisitor {
    private int fPosition;
    private String fTypeName;
    private String fFieldName;
    private boolean fFound;

    public BreakpointFieldLocator(int position) {
        this.fPosition = position;
        this.fFound = false;
    }

    public String getFieldName() {
        return this.fFieldName;
    }

    public String getTypeName() {
        return this.fTypeName;
    }

    private boolean containsPosition(ASTNode node) {
        int startPosition = node.getStartPosition();
        int endPosition = startPosition + node.getLength();
        return startPosition <= this.fPosition && this.fPosition <= endPosition;
    }

    public boolean visit(CompilationUnit node) {
        List types = node.types();
        Iterator iter = types.iterator();
        while (iter.hasNext() && !this.fFound) {
            ((TypeDeclaration)iter.next()).accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        if (this.containsPosition((ASTNode)node)) {
            List fragments = node.fragments();
            if (fragments.size() == 1 && this.containsPosition((ASTNode)node)) {
                this.fFieldName = ((VariableDeclarationFragment)fragments.get(0)).getName().getIdentifier();
                this.fTypeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)node);
                this.fFound = true;
                return false;
            }
            Iterator iter = fragments.iterator();
            while (iter.hasNext() && !this.fFound) {
                ((VariableDeclarationFragment)iter.next()).accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        if (this.containsPosition((ASTNode)node)) {
            FieldDeclaration[] fields = node.getFields();
            int length = fields.length;
            for (int i = 0; i < length && !this.fFound; ++i) {
                fields[i].accept((ASTVisitor)this);
            }
            if (!this.fFound) {
                TypeDeclaration[] types = node.getTypes();
                int length2 = types.length;
                for (int i = 0; i < length2 && !this.fFound; ++i) {
                    types[i].accept((ASTVisitor)this);
                }
            }
        }
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (this.containsPosition((ASTNode)node)) {
            this.fFieldName = node.getName().getIdentifier();
            this.fTypeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)node);
            this.fFound = true;
        }
        return false;
    }
}

