/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSStatus;

public class CVSException
extends TeamException {
    public CVSException(CoreException e) {
        super(e);
    }

    public CVSException(int severity, int code, String message, Throwable e) {
        super((IStatus)new CVSStatus(severity, code, message, e));
    }

    public CVSException(int severity, int code, String message) {
        this(severity, code, message, null);
    }

    public CVSException(String message) {
        super((IStatus)new CVSStatus(4, -6, message, null));
    }

    public CVSException(String message, Throwable e) {
        this(4, -6, message, e);
    }

    public CVSException(IStatus status) {
        super(status);
    }

    public static CVSException wrapException(IResource resource, String message, IOException e) {
        return new CVSException((IStatus)new CVSStatus(4, -4, message, e));
    }

    public static CVSException wrapException(IResource resource, String message, CoreException e) {
        return new CVSException((IStatus)new CVSStatus(4, e.getStatus().getCode(), message, e));
    }

    public static CVSException wrapException(Exception e) {
        Throwable t = e;
        if (e instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)e).getTargetException();
            if (target instanceof CVSException) {
                return (CVSException)((Object)target);
            }
            t = target;
        }
        return new CVSException((IStatus)new CVSStatus(4, -6, t.getMessage() != null ? t.getMessage() : "", t));
    }

    public static CVSException wrapException(CoreException e) {
        if (e instanceof CVSException) {
            return (CVSException)((Object)e);
        }
        return new CVSException(e);
    }

    public CoreException toCoreException() {
        IStatus status = this.getStatus();
        return new CoreException((IStatus)new Status(status.getSeverity(), status.getPlugin(), 0, status.getMessage(), (Throwable)((Object)this)));
    }
}

