/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.ThreadJob;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ImplicitJobs {
    private ThreadJob jobCache = null;
    protected JobManager manager;
    private final Set suspendedRules = new HashSet(20);
    private final Map threadJobs = new HashMap(20);

    ImplicitJobs(JobManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void begin(ISchedulingRule rule, IProgressMonitor monitor, boolean suspend) {
        ImplicitJobs implicitJobs;
        ThreadJob threadJob;
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("Begin rule: " + rule);
        }
        Thread currentThread = Thread.currentThread();
        ImplicitJobs implicitJobs2 = this;
        synchronized (implicitJobs2) {
            threadJob = (ThreadJob)this.threadJobs.get(currentThread);
            if (threadJob != null) {
                threadJob.push(rule);
                return;
            }
            if (rule == null) {
                return;
            }
            Job realJob = this.manager.currentJob();
            if (realJob != null && realJob.getRule() != null) {
                threadJob = this.newThreadJob(realJob.getRule());
            } else {
                threadJob = this.newThreadJob(rule);
                threadJob.acquireRule = true;
            }
            if (rule != null && this.isSuspended(rule)) {
                threadJob.acquireRule = false;
            }
            threadJob.setRealJob(realJob);
            threadJob.setThread(currentThread);
        }
        try {
            threadJob.push(rule);
            if (threadJob.acquireRule) {
                if (this.manager.runNow(threadJob)) {
                    this.manager.getLockManager().addLockThread(Thread.currentThread(), rule);
                } else {
                    threadJob.joinRun(monitor);
                }
            }
            Object var10_9 = null;
            implicitJobs = this;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ImplicitJobs implicitJobs3 = this;
            synchronized (implicitJobs3) {
                this.threadJobs.put(currentThread, threadJob);
                if (suspend && rule != null) {
                    this.suspendedRules.add(rule);
                }
            }
            throw throwable;
        }
        synchronized (implicitJobs) {
            this.threadJobs.put(currentThread, threadJob);
            if (suspend && rule != null) {
                this.suspendedRules.add(rule);
            }
        }
    }

    private boolean isSuspended(ISchedulingRule rule) {
        if (this.suspendedRules.size() == 0) {
            return false;
        }
        Iterator it = this.suspendedRules.iterator();
        while (it.hasNext()) {
            if (!((ISchedulingRule)it.next()).contains(rule)) continue;
            return true;
        }
        return false;
    }

    synchronized void end(ISchedulingRule rule, boolean resume) {
        Thread currentThread;
        ThreadJob threadJob;
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("End rule: " + rule);
        }
        if ((threadJob = (ThreadJob)this.threadJobs.get(currentThread = Thread.currentThread())) == null) {
            Assert.isLegal(rule == null, "endRule without matching beginRule: " + rule);
        } else if (threadJob.pop(rule)) {
            this.threadJobs.remove(currentThread);
            if (resume && rule != null) {
                this.suspendedRules.remove(rule);
            }
            if (threadJob.acquireRule) {
                this.manager.getLockManager().removeLockThread(Thread.currentThread(), threadJob.getRule());
            }
            if (threadJob.isRunning()) {
                this.manager.endJob(threadJob, Status.OK_STATUS, false);
            }
            this.recycle(threadJob);
        }
    }

    Job jobForThread(Thread thread) {
        return (Job)this.threadJobs.get(thread);
    }

    private ThreadJob newThreadJob(ISchedulingRule rule) {
        if (this.jobCache != null) {
            ThreadJob job = this.jobCache;
            job.setRule(rule);
            job.running = false;
            job.acquireRule = false;
            job.realJob = null;
            this.jobCache = null;
            return job;
        }
        return new ThreadJob(this.manager, rule);
    }

    private void recycle(ThreadJob job) {
        if (this.jobCache == null && job.recycle()) {
            this.jobCache = job;
        }
    }

    void resume(ISchedulingRule rule) {
        this.end(rule, true);
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("Resume rule: " + rule);
        }
    }

    void suspend(ISchedulingRule rule, IProgressMonitor monitor) {
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("Suspend rule: " + rule);
        }
        this.begin(rule, monitor, true);
    }
}

