/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.Serializable;
import javax.management.NotCompliantMBeanException;
import javax.management.relation.InvalidRoleInfoException;

public class RoleInfo
implements Serializable {
    private static final long serialVersionUID = 2504952983494636987L;
    public static int ROLE_CARDINALITY_INFINITY = -1;
    private String name;
    private String description;
    private String referencedMBeanClassName;
    private boolean isWritable;
    private boolean isReadable;
    private int minDegree;
    private int maxDegree;

    public RoleInfo(String roleName, String mbeanClassName, boolean isReadable, boolean isWritable, int minNumber, int maxNumber, String description) throws IllegalArgumentException, InvalidRoleInfoException, ClassNotFoundException, NotCompliantMBeanException {
        this.initialize(roleName, mbeanClassName, isReadable, isWritable, minNumber, maxNumber, description);
    }

    public RoleInfo(String roleName, String mbeanClassName, boolean isReadable, boolean isWritable) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        try {
            this.initialize(roleName, mbeanClassName, isReadable, isWritable, 1, 1, null);
        }
        catch (InvalidRoleInfoException ignored) {}
    }

    public RoleInfo(String roleName, String mbeanClassName) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        try {
            this.initialize(roleName, mbeanClassName, true, true, 1, 1, null);
        }
        catch (InvalidRoleInfoException ignored) {}
    }

    public RoleInfo(RoleInfo info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException("RoleInfo cannot be null");
        }
        try {
            this.initialize(info.getName(), info.getRefMBeanClassName(), info.isReadable(), info.isWritable(), info.getMinDegree(), info.getMaxDegree(), info.getDescription());
        }
        catch (Exception ignored) {}
    }

    private void initialize(String roleName, String mbeanClassName, boolean isReadable, boolean isWritable, int minNumber, int maxNumber, String description) throws IllegalArgumentException, InvalidRoleInfoException, ClassNotFoundException, NotCompliantMBeanException {
        if (roleName == null) {
            throw new IllegalArgumentException("Null Role name");
        }
        if (mbeanClassName == null) {
            throw new IllegalArgumentException("Null MBean class Name");
        }
        this.name = roleName;
        this.isReadable = isReadable;
        this.isWritable = isWritable;
        this.description = description;
        this.checkValidCardinality(maxNumber, minNumber);
        this.maxDegree = maxNumber;
        this.minDegree = minNumber;
        this.referencedMBeanClassName = mbeanClassName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMinDegree() {
        return this.minDegree;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public String getRefMBeanClassName() {
        return this.referencedMBeanClassName;
    }

    public boolean checkMaxDegree(int maxNumber) {
        return maxNumber >= ROLE_CARDINALITY_INFINITY && (this.maxDegree == ROLE_CARDINALITY_INFINITY || maxNumber != ROLE_CARDINALITY_INFINITY && maxNumber <= this.maxDegree);
    }

    public boolean checkMinDegree(int minNumber) {
        return minNumber >= ROLE_CARDINALITY_INFINITY && (this.minDegree == ROLE_CARDINALITY_INFINITY || minNumber >= this.minDegree);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Name: ");
        result.append(this.name);
        result.append("; isReadable: ").append(this.isReadable);
        result.append("; isWritable: ").append(this.isWritable);
        result.append("; description: ").append(this.description);
        result.append("; minimum degree: ").append(this.minDegree);
        result.append("; maximum degree: ").append(this.maxDegree);
        result.append("; MBean class: ").append(this.referencedMBeanClassName);
        return result.toString();
    }

    private void checkValidCardinality(int maxNumber, int minNumber) throws InvalidRoleInfoException {
        if (maxNumber != ROLE_CARDINALITY_INFINITY && (minNumber == ROLE_CARDINALITY_INFINITY || minNumber > maxNumber)) {
            throw new InvalidRoleInfoException("Role cardinality is invalid");
        }
        if (minNumber < ROLE_CARDINALITY_INFINITY || maxNumber < ROLE_CARDINALITY_INFINITY) {
            throw new InvalidRoleInfoException("Role cardinality is invalid");
        }
    }
}

