/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.internal.image.PngDecodingDataStream;

public class PngHuffmanTable {
    CodeLengthInfo[] codeLengthInfo;
    int[] codeValues;
    static final int MAX_CODE_LENGTH = 15;
    static final int BAD_CODE = 0xFFFFFFF;

    PngHuffmanTable(int[] lengths) {
        this.initialize(lengths);
        this.generateTable(lengths);
    }

    private void initialize(int[] lengths) {
        int i;
        this.codeValues = new int[lengths.length];
        for (i = 0; i < this.codeValues.length; ++i) {
            this.codeValues[i] = i;
        }
        this.codeLengthInfo = new CodeLengthInfo[15];
        for (i = 0; i < 15; ++i) {
            this.codeLengthInfo[i] = new CodeLengthInfo();
            this.codeLengthInfo[i].length = i;
            this.codeLengthInfo[i].baseIndex = 0;
            this.codeLengthInfo[i].min = 0xFFFFFFF;
            this.codeLengthInfo[i].max = -1;
        }
    }

    private void generateTable(int[] lengths) {
        for (int i = 0; i < lengths.length - 1; ++i) {
            for (int j = i + 1; j < lengths.length; ++j) {
                if (lengths[j] >= lengths[i] && (lengths[j] != lengths[i] || this.codeValues[j] >= this.codeValues[i])) continue;
                int tmp = lengths[j];
                lengths[j] = lengths[i];
                lengths[i] = tmp;
                tmp = this.codeValues[j];
                this.codeValues[j] = this.codeValues[i];
                this.codeValues[i] = tmp;
            }
        }
        int[] codes = new int[lengths.length];
        int lastLength = 0;
        int code = 0;
        for (int i = 0; i < lengths.length; ++i) {
            while (lastLength != lengths[i]) {
                ++lastLength;
                code <<= 1;
            }
            if (lastLength == 0) continue;
            codes[i] = code++;
        }
        int last = 0;
        for (int i = 0; i < lengths.length; ++i) {
            if (last != lengths[i]) {
                last = lengths[i];
                this.codeLengthInfo[last - 1].baseIndex = i;
                this.codeLengthInfo[last - 1].min = codes[i];
            }
            if (last == 0) continue;
            this.codeLengthInfo[last - 1].max = codes[i];
        }
    }

    int getNextValue(PngDecodingDataStream stream) {
        int codelength;
        int code = stream.getNextIdatBit();
        for (codelength = 0; codelength < 15 && code > this.codeLengthInfo[codelength].max; ++codelength) {
            code = code << 1 | stream.getNextIdatBit();
        }
        if (codelength >= 15) {
            stream.error();
        }
        int offset = code - this.codeLengthInfo[codelength].min;
        int index = this.codeLengthInfo[codelength].baseIndex + offset;
        return this.codeValues[index];
    }

    class CodeLengthInfo {
        int length;
        int max;
        int min;
        int baseIndex;

        CodeLengthInfo() {
        }
    }

    class CodeValuePair {
        int value;
        int code;

        CodeValuePair() {
        }
    }
}

