/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.AbstractTreeItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class TreeRoots
extends AbstractTreeItem {
    TreeRoots(Tree parent) {
        super(parent, 0);
        this.initialize();
    }

    void calculateVisibleItemCount() {
        Vector children = this.getChildren();
        int visibleItemCount = children.size();
        for (int i = 0; i < children.size(); ++i) {
            TreeItem child = (TreeItem)children.elementAt(i);
            visibleItemCount += child.getVisibleItemCount();
        }
        this.setVisibleItemCount(visibleItemCount);
    }

    void calculateVisibleItemCountParent() {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Tree parent = (Tree)this.getSelectableParent();
        parent.setRemovingAll(true);
        super.dispose();
        parent.setRemovingAll(false);
    }

    int getCheckboxXPosition() {
        return 0;
    }

    Point getSelectionExtent() {
        return new Point(0, 0);
    }

    int getSelectionX() {
        return 0;
    }

    int getVisibleIndex() {
        return -1;
    }

    int getVisibleIndex(int childIndex) {
        TreeItem child;
        Enumeration children = this.getChildren().elements();
        int globalItemIndex = 0;
        while (children.hasMoreElements() && (child = (TreeItem)children.nextElement()).getIndex() != childIndex) {
            globalItemIndex += child.getVisibleItemCount();
        }
        return globalItemIndex;
    }

    TreeItem getVisibleItem(int searchIndex) {
        TreeItem foundItem = null;
        Enumeration children = this.getChildren().elements();
        ++searchIndex;
        while (children.hasMoreElements() && foundItem == null) {
            TreeItem child = (TreeItem)children.nextElement();
            --searchIndex;
            if (child.internalGetExpanded()) {
                searchIndex -= child.getVisibleItemCount();
            }
            if (searchIndex > 0) continue;
            foundItem = child.getVisibleItem(searchIndex + child.getVisibleItemCount());
        }
        return foundItem;
    }

    void initialize() {
        this.internalSetExpanded(true);
    }

    Vector selectAll(Vector selectedItems) {
        Enumeration children = this.getChildren().elements();
        while (children.hasMoreElements()) {
            AbstractTreeItem treeItem = (AbstractTreeItem)children.nextElement();
            selectedItems = treeItem.selectAll(selectedItems);
        }
        return selectedItems;
    }
}

