/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.internal.dependencies.Dependency;
import org.eclipse.core.internal.dependencies.DependencySystem;
import org.eclipse.core.internal.dependencies.Element;
import org.eclipse.core.internal.dependencies.IMatchRule;
import org.eclipse.core.internal.dependencies.ISelectionPolicy;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class ResolverHelper {
    private static final Version NULL_VERSION = new Version(0, 0, 0);
    private static final IMatchRule GENERAL_MATCHRULE = new GeneralMatchRule();

    public static Element createElement(BundleDescription bundleDescription, DependencySystem system) {
        String name = ResolverHelper.getSymbolicName(bundleDescription);
        Version version = ResolverHelper.getVersion(bundleDescription);
        return system.createElement(name, version, ResolverHelper.createPrerequisites(bundleDescription, system), bundleDescription.isSingleton(), bundleDescription);
    }

    private static Version getVersion(BundleDescription bundleDescription) {
        Version version = bundleDescription.getVersion();
        if (version == null) {
            version = Version.emptyVersion;
        }
        return version;
    }

    private static String getSymbolicName(BundleDescription bundleDescription) {
        String name = bundleDescription.getSymbolicName();
        if (name == null) {
            name = Long.toString(bundleDescription.getBundleId());
        }
        return name;
    }

    private static Dependency[] createPrerequisites(BundleDescription bundleDesc, DependencySystem system) {
        int dependencyCount;
        BundleSpecification[] required = bundleDesc.getRequiredBundles();
        HostSpecification host = bundleDesc.getHost();
        int n = dependencyCount = required == null ? 0 : required.length;
        if (host != null) {
            ++dependencyCount;
        }
        if (dependencyCount == 0) {
            return new Dependency[0];
        }
        ArrayList<Dependency> prereqs = new ArrayList<Dependency>(dependencyCount);
        for (int i = 0; i < required.length; ++i) {
            if (required[i].getName().equals(bundleDesc.getSymbolicName())) continue;
            prereqs.add(ResolverHelper.createPrerequisite(system, (VersionConstraint)required[i]));
        }
        if (host != null) {
            prereqs.add(ResolverHelper.createPrerequisite(system, (VersionConstraint)host));
        }
        return prereqs.toArray(new Dependency[prereqs.size()]);
    }

    private static Dependency createPrerequisite(DependencySystem system, VersionConstraint constraint) {
        boolean optional = constraint instanceof BundleSpecification && ((BundleSpecification)constraint).isOptional();
        return system.createDependency(constraint.getName(), GENERAL_MATCHRULE, optional, constraint);
    }

    public static DependencySystem createDependencySystem(ISelectionPolicy policy) {
        return new DependencySystem(new BundleVersionComparator(), policy);
    }

    public static DependencySystem buildDependencySystem(State state, ISelectionPolicy selectionPolicy) {
        DependencySystem dependencySystem = ResolverHelper.createDependencySystem(selectionPolicy);
        BundleDescription[] bundles = state.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            dependencySystem.addElement(ResolverHelper.createElement(bundles[i], dependencySystem));
        }
        return dependencySystem;
    }

    public static void remove(BundleDescription description, DependencySystem system) {
        system.removeElement(ResolverHelper.getSymbolicName(description), ResolverHelper.getVersion(description));
    }

    public static void add(BundleDescription description, DependencySystem system) {
        system.addElement(ResolverHelper.createElement(description, system));
    }

    public static void unresolve(BundleDescription bundle, DependencySystem system) {
        Element element = system.getElement(ResolverHelper.getSymbolicName(bundle), ResolverHelper.getVersion(bundle));
        if (element != null) {
            system.unresolve(new Element[]{element});
        }
    }

    public static void update(BundleDescription newDescription, BundleDescription existing, DependencySystem system) {
        system.removeElement(ResolverHelper.getSymbolicName(existing), ResolverHelper.getVersion(existing));
        system.addElement(ResolverHelper.createElement(newDescription, system));
    }

    private static final class GeneralMatchRule
    implements IMatchRule {
        private GeneralMatchRule() {
        }

        public boolean isSatisfied(Object constraint, Object available) {
            return ((VersionConstraint)constraint).isSatisfiedBy((Version)available);
        }

        public String toString() {
            return "general";
        }
    }

    static class BundleVersionComparator
    implements Comparator {
        BundleVersionComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Version v1 = (Version)arg0;
            Version v2 = (Version)arg1;
            return v1.isGreaterThan(v2) ? 1 : (v1.equals((Object)v2) ? 0 : -1);
        }
    }
}

