/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;

public class WsdlToDotnet
extends Task {
    private File destFile = null;
    private String url = null;
    private File srcFile = null;
    private String language = "CS";
    private boolean server = false;
    private String namespace = null;
    private boolean failOnError = true;
    protected String extraOptions = null;

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setServer(boolean server) {
        this.server = server;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setExtraOptions(String extraOptions) {
        this.extraOptions = extraOptions;
    }

    protected void validate() throws BuildException {
        if (this.destFile == null) {
            throw new BuildException("destination file must be specified");
        }
        if (this.destFile.isDirectory()) {
            throw new BuildException("destination file is a directory");
        }
        if (this.url != null && this.srcFile != null) {
            throw new BuildException("you can not specify both a source file and a URL");
        }
        if (this.url == null && this.srcFile == null) {
            throw new BuildException("you must specify either a source file or a URL");
        }
        if (this.srcFile != null) {
            if (!this.srcFile.exists()) {
                throw new BuildException("source file does not exist");
            }
            if (this.srcFile.isDirectory()) {
                throw new BuildException("source file is a directory");
            }
        }
    }

    public void execute() throws BuildException {
        this.validate();
        NetCommand command = new NetCommand(this, "WSDL", "wsdl");
        command.setFailOnError(this.failOnError);
        command.addArgument("/nologo");
        command.addArgument("/out:" + this.destFile);
        command.addArgument("/language:", this.language);
        if (this.server) {
            command.addArgument("/server");
        }
        command.addArgument("/namespace:", this.namespace);
        command.addArgument(this.extraOptions);
        boolean rebuild = true;
        if (this.srcFile != null) {
            command.addArgument(this.srcFile.toString());
            if (this.srcFile.exists() && this.destFile.exists() && this.srcFile.lastModified() <= this.destFile.lastModified()) {
                rebuild = false;
            }
        } else {
            rebuild = true;
            command.addArgument(this.url);
        }
        if (rebuild) {
            command.runCommand();
        }
    }
}

