/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.connect;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdi.internal.VirtualMachineManagerImpl;
import org.eclipse.jdi.internal.connect.ConnectMessages;
import org.eclipse.jdi.internal.connect.ConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketTransportImpl;

public class SocketListeningConnectorImpl
extends ConnectorImpl
implements ListeningConnector {
    private int fPort;
    private int fTimeout;

    public SocketListeningConnectorImpl(VirtualMachineManagerImpl virtualMachineManager) {
        super(virtualMachineManager);
        SocketTransportImpl transport = new SocketTransportImpl();
        this.setTransport(transport);
    }

    public Map defaultArguments() {
        HashMap<String, ConnectorImpl.IntegerArgumentImpl> arguments = new HashMap<String, ConnectorImpl.IntegerArgumentImpl>(1);
        ConnectorImpl.IntegerArgumentImpl intArg = new ConnectorImpl.IntegerArgumentImpl("port", ConnectMessages.getString("SocketListeningConnectorImpl.Port_number_at_which_to_listen_for_VM_connections_1"), ConnectMessages.getString("SocketListeningConnectorImpl.Port_2"), true, 0, 65535);
        arguments.put(intArg.name(), intArg);
        intArg = new ConnectorImpl.IntegerArgumentImpl("timeout", ConnectMessages.getString("SocketListeningConnectorImpl.Timeout_before_accept_returns_3"), ConnectMessages.getString("SocketListeningConnectorImpl.Timeout_4"), false, 0, Integer.MAX_VALUE);
        arguments.put(intArg.name(), intArg);
        return arguments;
    }

    public String name() {
        return "com.sun.jdi.SocketListen";
    }

    public String description() {
        return ConnectMessages.getString("SocketListeningConnectorImpl.Accepts_socket_connections_initiated_by_other_VMs_5");
    }

    private void getConnectionArguments(Map connectionArgs) throws IllegalConnectorArgumentsException {
        String attribute = "port";
        try {
            this.fPort = ((Connector.IntegerArgument)connectionArgs.get(attribute)).intValue();
            attribute = "timeout";
            this.fTimeout = ((Connector.IntegerArgument)connectionArgs.get(attribute)).intValue();
        }
        catch (ClassCastException e) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.getString("SocketListeningConnectorImpl.Connection_argument_is_not_of_the_right_type_6"), attribute);
        }
        catch (NullPointerException e) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.getString("SocketListeningConnectorImpl.Necessary_connection_argument_is_null_7"), attribute);
        }
        catch (NumberFormatException e) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.getString("SocketListeningConnectorImpl.Connection_argument_is_not_a_number_8"), attribute);
        }
    }

    public String startListening(Map connectionArgs) throws IOException, IllegalConnectorArgumentsException {
        this.getConnectionArguments(connectionArgs);
        String result = ConnectMessages.getString("SocketListeningConnectorImpl.ListeningConnector_Socket_Port") + this.fPort;
        try {
            ((SocketTransportImpl)this.fTransport).listen(this.fPort);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalConnectorArgumentsException(e.getMessage(), "port");
        }
        return result;
    }

    public void stopListening(Map connectionArgs) throws IOException {
        ((SocketTransportImpl)this.fTransport).closeListen();
    }

    public VirtualMachine accept(Map connectionArgs) throws IOException {
        ((SocketTransportImpl)this.fTransport).setAcceptTimeout(this.fTimeout);
        ((SocketTransportImpl)this.fTransport).accept();
        if (this.fTransport.isOpen()) {
            return this.establishedConnection();
        }
        return null;
    }

    public boolean supportsMultipleConnections() {
        return true;
    }

    public int listeningPort() {
        return ((SocketTransportImpl)this.fTransport).listeningPort();
    }
}

