/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.IJDIEventListener;
import org.eclipse.jdt.internal.debug.core.JDIDebugMessages;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;

public class EventDispatcher
implements Runnable {
    private JDIDebugTarget fTarget;
    private boolean fShutdown;
    private HashMap fEventHandlers;
    private List fDebugEvents = new ArrayList(5);
    private List fDeferredEvents = new ArrayList(5);

    public EventDispatcher(JDIDebugTarget target) {
        this.fEventHandlers = new HashMap(10);
        this.fTarget = target;
        this.fShutdown = false;
    }

    protected void dispatch(EventSet eventSet) {
        if (this.isShutdown()) {
            return;
        }
        EventIterator iter = eventSet.eventIterator();
        boolean vote = false;
        boolean resume = true;
        while (iter.hasNext()) {
            if (this.isShutdown()) {
                return;
            }
            Event event = iter.nextEvent();
            if (event == null) continue;
            IJDIEventListener listener = (IJDIEventListener)this.fEventHandlers.get(event.request());
            if (listener != null) {
                if (listener instanceof IJavaLineBreakpoint) {
                    try {
                        if (((IJavaLineBreakpoint)((Object)listener)).isConditionEnabled()) {
                            this.defer(event);
                            continue;
                        }
                    }
                    catch (CoreException exception) {
                        JDIDebugPlugin.log(exception);
                    }
                }
                vote = true;
                resume = listener.handleEvent(event, this.fTarget) && resume;
                continue;
            }
            if (event instanceof VMDeathEvent) {
                this.fTarget.handleVMDeath((VMDeathEvent)event);
                this.shutdown();
                continue;
            }
            if (event instanceof VMDisconnectEvent) {
                this.fTarget.handleVMDisconnect((VMDisconnectEvent)event);
                this.shutdown();
                continue;
            }
            if (!(event instanceof VMStartEvent)) continue;
            this.fTarget.handleVMStart((VMStartEvent)event);
        }
        if (resume && !this.getDeferredEvents().isEmpty()) {
            Iterator deferredIter = this.getDeferredEvents().iterator();
            while (deferredIter.hasNext()) {
                IJDIEventListener listener;
                if (this.isShutdown()) {
                    return;
                }
                Event event = (Event)deferredIter.next();
                if (event == null || (listener = (IJDIEventListener)this.fEventHandlers.get(event.request())) == null) continue;
                vote = true;
                resume = listener.handleEvent(event, this.fTarget) && resume;
            }
        }
        this.getDeferredEvents().clear();
        this.fireEvents();
        if (vote && resume) {
            try {
                eventSet.resume();
            }
            catch (VMDisconnectedException e) {
            }
            catch (RuntimeException e) {
                try {
                    this.fTarget.targetRequestFailed(JDIDebugMessages.getString("EventDispatcher.0"), e);
                }
                catch (DebugException de) {
                    JDIDebugPlugin.log(de);
                }
            }
        }
    }

    public void run() {
        VirtualMachine vm = this.fTarget.getVM();
        if (vm != null) {
            EventQueue q = vm.eventQueue();
            EventSet eventSet = null;
            while (!this.isShutdown()) {
                try {
                    try {
                        eventSet = q.remove();
                        if (eventSet == null) {
                        }
                    }
                    catch (VMDisconnectedException e) {}
                    break;
                    if (this.isShutdown()) continue;
                    this.dispatch(eventSet);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    public void shutdown() {
        this.fShutdown = true;
    }

    protected boolean isShutdown() {
        return this.fShutdown;
    }

    public void addJDIEventListener(IJDIEventListener listener, EventRequest request) {
        this.fEventHandlers.put(request, listener);
    }

    public void removeJDIEventListener(IJDIEventListener listener, EventRequest request) {
        this.fEventHandlers.remove(request);
    }

    public void queue(DebugEvent event) {
        this.fDebugEvents.add(event);
    }

    protected void fireEvents() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null) {
            DebugEvent[] events = this.fDebugEvents.toArray(new DebugEvent[this.fDebugEvents.size()]);
            this.fDebugEvents.clear();
            plugin.fireDebugEventSet(events);
        }
    }

    protected void defer(Event event) {
        this.fDeferredEvents.add(event);
    }

    protected List getDeferredEvents() {
        return this.fDeferredEvents;
    }
}

