/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;

public abstract class ToggleHyperlink
extends AbstractHyperlink {
    protected int innerWidth;
    protected int innerHeight;
    private boolean expanded;
    protected boolean hover;
    private Color decorationColor;
    private Color hoverColor;

    public ToggleHyperlink(Composite parent, int style) {
        super(parent, style);
        this.addListener(6, new Listener(){

            public void handleEvent(Event e) {
                ToggleHyperlink.this.hover = true;
                ToggleHyperlink.this.redraw();
            }
        });
        this.addListener(7, new Listener(){

            public void handleEvent(Event e) {
                ToggleHyperlink.this.hover = false;
                ToggleHyperlink.this.redraw();
            }
        });
        this.addHyperlinkListener(new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ToggleHyperlink.this.setExpanded(!ToggleHyperlink.this.isExpanded());
            }
        });
        this.initAccessible();
    }

    public void setDecorationColor(Color decorationColor) {
        this.decorationColor = decorationColor;
    }

    public Color getDecorationColor() {
        return this.decorationColor;
    }

    public void setHoverDecorationColor(Color hoverColor) {
        this.hoverColor = hoverColor;
    }

    public Color geHoverDecorationColor() {
        return this.hoverColor;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = wHint != -1 ? wHint : this.innerWidth + 2 * this.marginWidth;
        int height = hHint != -1 ? hHint : this.innerHeight + 2 * this.marginHeight;
        return new Point(width, height);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        this.redraw();
    }

    private void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = ToggleHyperlink.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = ToggleHyperlink.this.toControl(new Point(e.x, e.y));
                if (ToggleHyperlink.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = ToggleHyperlink.this.getBounds();
                Point pt = ToggleHyperlink.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 35;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = ToggleHyperlink.this.isExpanded() ? 512 : 1024;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = ToggleHyperlink.this.isExpanded() ? "1" : "0";
            }
        });
    }
}

