/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.internal.ui.model.FeatureAdapter;
import org.eclipse.update.internal.ui.model.IFeatureAdapter;

public class SimpleFeatureAdapter
extends FeatureAdapter {
    protected IFeature feature;
    private boolean optional;

    public SimpleFeatureAdapter(IFeature feature) {
        this(feature, false);
    }

    public SimpleFeatureAdapter(IFeature feature, boolean optional) {
        this.feature = feature;
        this.optional = optional;
    }

    public IFeature getFeature(IProgressMonitor monitor) throws CoreException {
        return this.feature;
    }

    public String getFastLabel() {
        return this.feature.getLabel();
    }

    public URL getURL() {
        return this.feature.getURL();
    }

    public ISite getSite() {
        return this.feature.getSite();
    }

    public IFeatureAdapter[] getIncludedFeatures(IProgressMonitor monitor) {
        try {
            IIncludedFeatureReference[] included = this.getFeature(monitor).getIncludedFeatureReferences();
            IFeatureAdapter[] result = new SimpleFeatureAdapter[included.length];
            for (int i = 0; i < included.length; ++i) {
                result[i] = new SimpleFeatureAdapter(included[i].getFeature(null), included[i].isOptional());
                ((FeatureAdapter)result[i]).setIncluded(true);
            }
            return result;
        }
        catch (CoreException e) {
            return new IFeatureAdapter[0];
        }
    }

    public boolean isOptional() {
        return this.optional;
    }
}

