/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSourceLookupDirector
implements ISourceLookupDirector,
ILaunchConfigurationListener,
ILaunchListener {
    protected String fId;
    protected ArrayList fParticipants = new ArrayList();
    protected ISourceContainer[] fSourceContainers = null;
    protected ILaunchConfiguration fConfig;
    protected boolean fDuplicates = false;
    protected ISourcePathComputer fComputer = null;
    protected Map fResolvedElements = null;
    protected static final IStatus fPromptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    protected static final IStatus fResolveDuplicatesStatus = new Status(1, "org.eclipse.debug.ui", 205, "", null);
    protected static final String DIRECTOR_ROOT_NODE = "sourceLookupDirector";
    protected static final String CONTAINERS_NODE = "sourceContainers";
    protected static final String DUPLICATES_ATTR = "duplicates";
    protected static final String CONTAINER_NODE = "container";
    protected static final String CONTAINER_TYPE_ATTR = "typeId";
    protected static final String CONTAINER_MEMENTO_ATTR = "memento";

    public void setId(String id) {
        this.fId = id;
    }

    public void dispose() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchConfigurationListener(this);
        launchManager.removeLaunchListener(this);
        Iterator iterator = this.fParticipants.iterator();
        while (iterator.hasNext()) {
            ISourceLookupParticipant participant = (ISourceLookupParticipant)iterator.next();
            if (participant == this) continue;
            participant.dispose();
        }
        this.fParticipants.clear();
        if (this.fSourceContainers != null) {
            for (int i = 0; i < this.fSourceContainers.length; ++i) {
                this.fSourceContainers[i].dispose();
            }
        }
        this.fSourceContainers = null;
        this.fResolvedElements = null;
    }

    protected void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, message, exception);
        throw new CoreException((IStatus)status);
    }

    private List parseSourceContainers(NodeList list) throws CoreException {
        ArrayList<ISourceContainer> containers = new ArrayList<ISourceContainer>();
        for (int i = 0; i < list.getLength(); ++i) {
            String memento;
            ISourceContainerType type;
            if (list.item(i).getNodeType() != 1) continue;
            Element element = (Element)list.item(i);
            String typeId = element.getAttribute(CONTAINER_TYPE_ATTR);
            if (typeId == null || typeId.equals("")) {
                this.abort(SourceLookupMessages.getString("AbstractSourceLookupDirector.11"), null);
            }
            if ((type = DebugPlugin.getDefault().getLaunchManager().getSourceContainerType(typeId)) == null) {
                this.abort(MessageFormat.format(SourceLookupMessages.getString("AbstractSourceLookupDirector.12"), typeId), null);
            }
            if ((memento = element.getAttribute(CONTAINER_MEMENTO_ATTR)) == null || memento.equals("")) {
                this.abort(SourceLookupMessages.getString("AbstractSourceLookupDirector.13"), null);
            }
            ISourceContainer container = type.createSourceContainer(memento);
            containers.add(container);
        }
        return containers;
    }

    private void addSourceLookupParticipant(ISourceLookupParticipant participant) {
        if (!this.fParticipants.contains(participant)) {
            this.fParticipants.add(participant);
            participant.init(this);
        }
    }

    public ISourceContainer[] getSourceContainers() {
        if (this.fSourceContainers == null) {
            return new ISourceContainer[0];
        }
        ISourceContainer[] copy = new ISourceContainer[this.fSourceContainers.length];
        System.arraycopy(this.fSourceContainers, 0, copy, 0, this.fSourceContainers.length);
        return copy;
    }

    public boolean isFindDuplicates() {
        return this.fDuplicates;
    }

    public void setFindDuplicates(boolean duplicates) {
        this.fDuplicates = duplicates;
    }

    private void removeSourceLookupParticipant(ISourceLookupParticipant participant) {
        if (this.fParticipants.remove(participant)) {
            participant.dispose();
        }
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        if (this.fConfig == null || configuration.isWorkingCopy()) {
            return;
        }
        if (this.fConfig.equals(configuration)) {
            try {
                String locatorMemento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, (String)null);
                if (locatorMemento == null) {
                    this.initializeDefaults(configuration);
                } else {
                    this.initializeFromMemento(locatorMemento, configuration);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    public String getMemento() throws CoreException {
        Document doc = DebugPlugin.newDocument();
        Element rootNode = doc.createElement(DIRECTOR_ROOT_NODE);
        doc.appendChild(rootNode);
        Element pathNode = doc.createElement(CONTAINERS_NODE);
        if (this.fDuplicates) {
            pathNode.setAttribute(DUPLICATES_ATTR, "true");
        } else {
            pathNode.setAttribute(DUPLICATES_ATTR, "false");
        }
        rootNode.appendChild(pathNode);
        if (this.fSourceContainers != null) {
            for (int i = 0; i < this.fSourceContainers.length; ++i) {
                Element node = doc.createElement(CONTAINER_NODE);
                ISourceContainer container = this.fSourceContainers[i];
                ISourceContainerType type = container.getType();
                node.setAttribute(CONTAINER_TYPE_ATTR, type.getId());
                node.setAttribute(CONTAINER_MEMENTO_ATTR, type.getMemento(container));
                pathNode.appendChild(node);
            }
        }
        return DebugPlugin.serializeDocument(doc);
    }

    public void initializeFromMemento(String memento) throws CoreException {
        this.dispose();
        Element rootElement = DebugPlugin.parseDocument(memento);
        if (!rootElement.getNodeName().equalsIgnoreCase(DIRECTOR_ROOT_NODE)) {
            this.abort(SourceLookupMessages.getString("AbstractSourceLookupDirector.14"), null);
        }
        NodeList list = rootElement.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element entry;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type != 1 || !(entry = (Element)node).getNodeName().equalsIgnoreCase(CONTAINERS_NODE)) continue;
            this.setFindDuplicates("true".equals(entry.getAttribute(DUPLICATES_ATTR)));
            NodeList children = entry.getChildNodes();
            List containers = this.parseSourceContainers(children);
            this.setSourceContainers(containers.toArray(new ISourceContainer[containers.size()]));
        }
        this.initializeParticipants();
    }

    public void setSourceContainers(ISourceContainer[] containers) {
        int i;
        ISourceContainer[] old = this.getSourceContainers();
        for (i = 0; i < old.length; ++i) {
            old[i].dispose();
        }
        this.fSourceContainers = containers;
        for (i = 0; i < containers.length; ++i) {
            ISourceContainer container = containers[i];
            container.init(this);
        }
        this.fResolvedElements = null;
        ISourceLookupParticipant[] participants = this.getParticipants();
        for (int i2 = 0; i2 < participants.length; ++i2) {
            ISourceLookupParticipant participant = participants[i2];
            participant.sourceContainersChanged(this);
        }
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        return this.getSourceElement((Object)stackFrame);
    }

    protected List doSourceLookup(Object element) {
        SourceLookupQuery query = new SourceLookupQuery(element);
        Platform.run((ISafeRunnable)query);
        List sources = query.getSourceElements();
        query.dispose();
        return sources;
    }

    public Object resolveSourceElement(Object element, List sources) {
        Iterator duplicates = sources.iterator();
        while (duplicates.hasNext()) {
            Object dup = duplicates.next();
            Object resolved = this.getCachedElement(dup);
            if (resolved == null) continue;
            return resolved;
        }
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(fPromptStatus);
        if (prompter != null) {
            try {
                Object result = prompter.handleStatus(fResolveDuplicatesStatus, new Object[]{element, sources});
                if (result != null) {
                    this.cacheResolvedElement(sources, result);
                    return result;
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return sources.get(0);
    }

    private boolean checkDuplicate(Object sourceToAdd, List sources) {
        if (sources.size() == 0) {
            return false;
        }
        Iterator iterator = sources.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(sourceToAdd)) continue;
            return true;
        }
        return false;
    }

    public void initializeFromMemento(String memento, ILaunchConfiguration configuration) throws CoreException {
        this.setLaunchConfiguration(configuration);
        this.initializeFromMemento(memento);
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.dispose();
        this.setLaunchConfiguration(configuration);
        this.setSourceContainers(new ISourceContainer[]{new DefaultSourceContainer()});
        this.initializeParticipants();
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfig;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fConfig = configuration;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchConfigurationListener(this);
        launchManager.addLaunchListener(this);
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
        if (this.equals(launch.getSourceLocator())) {
            this.dispose();
        }
    }

    public ISourceLookupParticipant[] getParticipants() {
        return this.fParticipants.toArray(new ISourceLookupParticipant[this.fParticipants.size()]);
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        return true;
    }

    protected void cacheResolvedElement(List duplicates, Object sourceElement) {
        if (this.fResolvedElements == null) {
            this.fResolvedElements = new HashMap(10);
        }
        Iterator iterator = duplicates.iterator();
        while (iterator.hasNext()) {
            Object dup = iterator.next();
            this.fResolvedElements.put(dup, sourceElement);
        }
    }

    protected Object getCachedElement(Object duplicate) {
        if (this.fResolvedElements != null) {
            return this.fResolvedElements.get(duplicate);
        }
        return null;
    }

    protected void clearCachedElement(Object duplicate) {
        if (this.fResolvedElements != null) {
            this.fResolvedElements.remove(duplicate);
        }
    }

    public void clearSourceElements(Object element) {
        List list = this.doSourceLookup(element);
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.clearCachedElement(iterator.next());
            }
        }
    }

    public void addParticipants(ISourceLookupParticipant[] participants) {
        for (int i = 0; i < participants.length; ++i) {
            ISourceLookupParticipant participant = participants[i];
            this.addSourceLookupParticipant(participant);
            participant.sourceContainersChanged(this);
        }
    }

    public void removeParticipants(ISourceLookupParticipant[] participants) {
        for (int i = 0; i < participants.length; ++i) {
            this.removeSourceLookupParticipant(participants[i]);
        }
    }

    public String getId() {
        return this.fId;
    }

    public ISourcePathComputer getSourcePathComputer() {
        if (this.fComputer == null && this.getLaunchConfiguration() != null) {
            try {
                return DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer(this.getLaunchConfiguration());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.fComputer;
    }

    public void setSourcePathComputer(ISourcePathComputer computer) {
        this.fComputer = computer;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        SourceLookupQuery query = new SourceLookupQuery(object);
        Platform.run((ISafeRunnable)query);
        List sources = query.getSourceElements();
        query.dispose();
        return sources.toArray();
    }

    public Object getSourceElement(Object element) {
        List sources = this.doSourceLookup(element);
        if (sources.size() == 1) {
            return sources.get(0);
        }
        if (sources.size() > 1) {
            return this.resolveSourceElement(element, sources);
        }
        return null;
    }

    class SourceLookupQuery
    implements ISafeRunnable {
        private List fSourceElements = new ArrayList();
        private Object fElement = null;

        SourceLookupQuery(Object element) {
            this.fElement = element;
        }

        public void handleException(Throwable exception) {
            DebugPlugin.log(exception);
        }

        public void run() throws Exception {
            MultiStatus multiStatus = null;
            CoreException single = null;
            for (int i = 0; i < AbstractSourceLookupDirector.this.fParticipants.size(); ++i) {
                try {
                    Object[] sourceArray = ((ISourceLookupParticipant)AbstractSourceLookupDirector.this.fParticipants.get(i)).findSourceElements(this.fElement);
                    if (sourceArray == null || sourceArray.length <= 0) continue;
                    if (AbstractSourceLookupDirector.this.isFindDuplicates()) {
                        for (int j = 0; j < sourceArray.length; ++j) {
                            if (AbstractSourceLookupDirector.this.checkDuplicate(sourceArray[j], this.fSourceElements)) continue;
                            this.fSourceElements.add(sourceArray[j]);
                        }
                        continue;
                    }
                    this.fSourceElements.add(sourceArray[0]);
                    return;
                }
                catch (CoreException e) {
                    if (single == null) {
                        single = e;
                        continue;
                    }
                    if (multiStatus == null) {
                        multiStatus = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 120, new IStatus[]{single.getStatus()}, SourceLookupMessages.getString("AbstractSourceLookupDirector.19"), null);
                        multiStatus.add(e.getStatus());
                        continue;
                    }
                    multiStatus.add(e.getStatus());
                }
            }
            if (this.fSourceElements.isEmpty()) {
                if (multiStatus != null) {
                    throw new CoreException(multiStatus);
                }
                if (single != null) {
                    throw single;
                }
            }
        }

        public List getSourceElements() {
            return this.fSourceElements;
        }

        public void dispose() {
            this.fElement = null;
            this.fSourceElements = null;
        }
    }
}

