/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;

class ResourceToItemsMapper {
    private static final int NUMBER_LIST_REUSE = 10;
    private HashMap fResourceToItem = new HashMap();
    private Stack fReuseLists = new Stack();
    private ContentViewer fContentViewer;

    public ResourceToItemsMapper(ContentViewer viewer) {
        this.fContentViewer = viewer;
    }

    public void resourceChanged(IResource changedResource) {
        Object obj = this.fResourceToItem.get(changedResource);
        if (obj != null) {
            if (obj instanceof Item) {
                this.updateItem((Item)obj);
            } else {
                List list = (List)obj;
                for (int k = 0; k < list.size(); ++k) {
                    this.updateItem((Item)list.get(k));
                }
            }
        }
    }

    private void updateItem(Item item) {
        if (!item.isDisposed()) {
            ILabelProvider lprovider = (ILabelProvider)this.fContentViewer.getLabelProvider();
            Object data = item.getData();
            String oldText = item.getText();
            String text = lprovider.getText(data);
            if (text != null && !text.equals(oldText)) {
                item.setText(text);
            }
            Image oldImage = item.getImage();
            Image image = lprovider.getImage(data);
            if (image != null && !image.equals((Object)oldImage)) {
                item.setImage(image);
            }
        }
    }

    public void addToMap(Object element, Item item) {
        IResource resource = ((ISearchResultViewEntry)element).getResource();
        if (resource != null) {
            Object existingMapping = this.fResourceToItem.get(resource);
            if (existingMapping == null) {
                this.fResourceToItem.put(resource, item);
            } else if (existingMapping instanceof Item) {
                if (existingMapping != item) {
                    List list = this.getNewList();
                    list.add(existingMapping);
                    list.add(item);
                    this.fResourceToItem.put(resource, list);
                }
            } else {
                List list = (List)existingMapping;
                if (!list.contains(item)) {
                    list.add(item);
                }
            }
        }
    }

    public void removeFromMap(Object element, Item item) {
        IResource resource = ((ISearchResultViewEntry)element).getResource();
        if (resource != null) {
            Object existingMapping = this.fResourceToItem.get(resource);
            if (existingMapping == null) {
                return;
            }
            if (existingMapping instanceof Item) {
                this.fResourceToItem.remove(resource);
            } else {
                List list = (List)existingMapping;
                list.remove(item);
                if (list.isEmpty()) {
                    this.fResourceToItem.remove(list);
                    this.releaseList(list);
                }
            }
        }
    }

    private List getNewList() {
        if (!this.fReuseLists.isEmpty()) {
            return (List)this.fReuseLists.pop();
        }
        return new ArrayList(2);
    }

    private void releaseList(List list) {
        if (this.fReuseLists.size() < 10) {
            this.fReuseLists.push(list);
        }
    }

    public void clearMap() {
        this.fResourceToItem.clear();
    }

    public boolean isEmpty() {
        return this.fResourceToItem.isEmpty();
    }
}

