/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.util.FileTypeEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileEditorMappingContentProvider;
import org.eclipse.ui.dialogs.FileEditorMappingLabelProvider;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class TypeFilteringDialog
extends SelectionDialog {
    private Collection fInitialSelections;
    private CheckboxTableViewer fListViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private Text fUserDefinedText;
    private IFileEditorMapping[] fCurrentInput;

    public TypeFilteringDialog(Shell parentShell, Collection preselections) {
        super(parentShell);
        this.setTitle(SearchMessages.getString("TypesFiltering.title"));
        this.fInitialSelections = preselections;
        this.setMessage(SearchMessages.getString("TypesFiltering.message"));
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, SearchMessages.getString("TypesFiltering.selectAll"), false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeFilteringDialog.this.getListViewer().setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, SearchMessages.getString("TypesFiltering.deselectAll"), false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeFilteringDialog.this.getListViewer().setAllChecked(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private void addUserDefinedEntries(List result) {
        StringTokenizer tokenizer = new StringTokenizer(this.fUserDefinedText.getText(), FileTypeEditor.TYPE_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String currentExtension = tokenizer.nextToken().trim();
            if (currentExtension.equals("")) continue;
            result.add(currentExtension);
        }
    }

    private void checkInitialSelections() {
        IFileEditorMapping[] editorMappings = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        ArrayList<String> selectedMappings = new ArrayList<String>();
        for (int i = 0; i < editorMappings.length; ++i) {
            IFileEditorMapping mapping = editorMappings[i];
            if (!this.fInitialSelections.contains(mapping.getLabel())) continue;
            this.fListViewer.setChecked((Object)mapping, true);
            selectedMappings.add(mapping.getLabel());
        }
        Iterator initialIterator = this.fInitialSelections.iterator();
        StringBuffer entries = new StringBuffer();
        boolean first = true;
        while (initialIterator.hasNext()) {
            String nextExtension = (String)initialIterator.next();
            if (selectedMappings.contains(nextExtension)) continue;
            if (!first) {
                entries.append(FileTypeEditor.TYPE_DELIMITER);
                entries.append(" ");
            }
            first = false;
            entries.append(nextExtension);
        }
        this.fUserDefinedText.setText(entries.toString());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.search.type_filtering_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.fListViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fListViewer.getTable().setLayoutData((Object)data);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)FileEditorMappingLabelProvider.INSTANCE);
        this.fListViewer.setContentProvider((IContentProvider)FileEditorMappingContentProvider.INSTANCE);
        this.addSelectionButtons(composite);
        this.createUserEntryGroup(composite);
        this.initializeViewer();
        if (this.fInitialSelections != null && !this.fInitialSelections.isEmpty()) {
            this.checkInitialSelections();
        }
        TypeFilteringDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createUserEntryGroup(Composite parent) {
        Composite userDefinedGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        userDefinedGroup.setLayout((Layout)layout);
        userDefinedGroup.setLayoutData((Object)new GridData(272));
        new Label(userDefinedGroup, 0).setText(SearchMessages.getString("TypesFiltering.otherExtensions"));
        this.fUserDefinedText = new Text(userDefinedGroup, 2052);
        GridData data = new GridData(768);
        this.fUserDefinedText.setLayoutData((Object)data);
    }

    private IFileEditorMapping[] getInput() {
        if (this.fCurrentInput == null) {
            ArrayList<IFileEditorMapping> wildcardEditors = new ArrayList<IFileEditorMapping>();
            IFileEditorMapping[] allMappings = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
            for (int i = 0; i < allMappings.length; ++i) {
                if (!allMappings[i].getName().equals("*")) continue;
                wildcardEditors.add(allMappings[i]);
            }
            this.fCurrentInput = new IFileEditorMapping[wildcardEditors.size()];
            wildcardEditors.toArray(this.fCurrentInput);
        }
        return this.fCurrentInput;
    }

    private void initializeViewer() {
        this.fListViewer.setInput((Object)this.getInput());
    }

    protected void okPressed() {
        IFileEditorMapping[] children = this.getInput();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < children.length; ++i) {
            IFileEditorMapping element = children[i];
            if (!this.fListViewer.getChecked((Object)element)) continue;
            list.add(element.getLabel());
        }
        this.addUserDefinedEntries(list);
        this.setResult(list);
        super.okPressed();
    }

    protected CheckboxTableViewer getListViewer() {
        return this.fListViewer;
    }
}

