/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.launchConfigurations.IgnoreWhiteSpaceComparator;
import org.eclipse.ui.externaltools.internal.model.BuilderUtils;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.ui.BuilderLabelProvider;
import org.eclipse.ui.externaltools.internal.ui.ExternalToolsUIMessages;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.progress.IProgressService;

public final class BuilderPropertyPage
extends PropertyPage
implements ICheckStateListener {
    private static final String COMMAND_ENABLED = "CommandEnabled";
    private Button upButton;
    private Button downButton;
    private Button newButton;
    private Button importButton;
    private Button editButton;
    private Button removeButton;
    private boolean userHasMadeChanges = false;
    private List configsToBeDeleted = null;
    private CheckboxTableViewer viewer = null;
    private ILabelProvider labelProvider = new BuilderLabelProvider();
    private List newConfigList = new ArrayList();
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BuilderPropertyPage.this.handleButtonPressed((Button)e.widget);
        }
    };
    private ILaunchConfigurationListener configurationListener = new ILaunchConfigurationListener(){

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration oldConfig = manager.getMovedFrom(configuration);
            if (oldConfig == null) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(this, oldConfig, configuration){
                private final /* synthetic */ ILaunchConfiguration val$oldConfig;
                private final /* synthetic */ ILaunchConfiguration val$configuration;
                private final /* synthetic */ 2 this$1;
                {
                    this.this$1 = this$1;
                    this.val$oldConfig = val$oldConfig;
                    this.val$configuration = val$configuration;
                }

                public void run() {
                    TableItem[] items = BuilderPropertyPage.access$200(2.access$100(this.this$1)).getTable().getItems();
                    for (int i = 0; i < items.length; ++i) {
                        TableItem item = items[i];
                        Object data = item.getData();
                        if (data != this.val$oldConfig) continue;
                        item.setData((Object)this.val$configuration);
                        BuilderPropertyPage.access$200(2.access$100(this.this$1)).update((Object)this.val$configuration, null);
                        break;
                    }
                    if (BuilderPropertyPage.access$300(2.access$100(this.this$1)).remove(this.val$oldConfig)) {
                        BuilderPropertyPage.access$300(2.access$100(this.this$1)).add(this.val$configuration);
                    }
                }
            });
        }

        public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        }

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        }

        static /* synthetic */ BuilderPropertyPage access$100(2 x0) {
            return x0.BuilderPropertyPage.this;
        }
    };
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public BuilderPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    private void addBuildersToTable() {
        IProject project = this.getInputProject();
        if (project == null) {
            return;
        }
        ICommand[] commands = null;
        try {
            commands = project.getDescription().getBuildSpec();
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
        boolean projectNeedsMigration = false;
        for (int i = 0; i < commands.length; ++i) {
            String[] version = new String[]{""};
            ILaunchConfiguration config = BuilderUtils.configFromBuildCommandArgs(project, commands[i].getArguments(), version);
            if ("2.1".equals(version[0])) {
                projectNeedsMigration = true;
            }
            Object element = null;
            if (config != null) {
                if (!config.isWorkingCopy() && !config.exists()) {
                    Status status = new Status(4, "org.eclipse.ui.externaltools", 0, MessageFormat.format(ExternalToolsUIMessages.getString("BuilderPropertyPage.Exists"), config.getLocation().toOSString()), null);
                    ErrorDialog.openError((Shell)this.getShell(), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.errorTitle"), (String)MessageFormat.format(ExternalToolsUIMessages.getString("BuilderPropertyPage.External_Tool_Builder_{0}_Not_Added_2"), config.getName()), (IStatus)status);
                    this.userHasMadeChanges = true;
                } else {
                    element = config;
                }
            } else {
                String builderID = commands[i].getBuilderName();
                element = builderID.equals("org.eclipse.ui.externaltools.ExternalToolBuilder") && commands[i].getArguments().get("LaunchConfigHandle") != null ? new ErrorConfig(commands[i]) : commands[i];
            }
            if (element == null) continue;
            this.viewer.add(element);
            this.viewer.setChecked(element, this.isEnabled(element));
        }
        if (projectNeedsMigration) {
            IPreferenceStore store = ExternalToolsPlugin.getDefault().getPreferenceStore();
            boolean prompt = store.getBoolean("externaltools.builders.promptForProjectMigration");
            boolean proceed = true;
            if (prompt) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.0"), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.1"), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.2"), (boolean)false, null, null);
                proceed = dialog.getReturnCode() == 2;
                store.setValue("externaltools.builders.promptForProjectMigration", !dialog.getToggleState());
            }
            if (!proceed) {
                this.viewer.getTable().setEnabled(false);
                this.downButton.setEnabled(false);
                this.editButton.setEnabled(false);
                this.importButton.setEnabled(false);
                this.newButton.setEnabled(false);
                this.removeButton.setEnabled(false);
            }
        }
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        GridData data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        button.setText(label);
        button.setEnabled(false);
        button.addSelectionListener(this.buttonListener);
        return button;
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.ui.externaltools.builder_property_page_context");
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        topLevel.setLayout((Layout)layout);
        topLevel.setLayoutData((Object)new GridData(1808));
        Label description = new Label(topLevel, 64);
        description.setText(ExternalToolsUIMessages.getString("BuilderPropertyPage.description"));
        description.setLayoutData((Object)new GridData(768));
        description.setFont(font);
        Composite tableAndButtons = new Composite(topLevel, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)tableAndButtons, (int)68354);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        Table builderTable = this.viewer.getTable();
        builderTable.setLayoutData((Object)new GridData(1808));
        builderTable.setFont(font);
        builderTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuilderPropertyPage.this.handleTableSelectionChanged();
            }
        });
        builderTable.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                BuilderPropertyPage.this.handleEditButtonPressed();
            }
        });
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setFont(font);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.newButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.newButton"));
        this.importButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.&Import..._3"));
        this.editButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.editButton"));
        this.removeButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.removeButton"));
        new Label(buttonArea, 16384);
        this.upButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.upButton"));
        this.downButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.downButton"));
        this.newButton.setEnabled(true);
        this.importButton.setEnabled(true);
        this.addBuildersToTable();
        return topLevel;
    }

    private void setAutobuild(boolean newState) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wsDescription = workspace.getDescription();
        boolean oldState = wsDescription.isAutoBuilding();
        if (oldState != newState) {
            wsDescription.setAutoBuilding(newState);
            workspace.setDescription(wsDescription);
        }
    }

    private IProject getInputProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        Object resource = element.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = BuilderPropertyPage.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        if (resource instanceof IProject) {
            return (IProject)resource;
        }
        return null;
    }

    private void handleButtonPressed(Button button) {
        if (button == this.newButton) {
            this.handleNewButtonPressed();
        } else if (button == this.importButton) {
            this.handleImportButtonPressed();
        } else if (button == this.editButton) {
            this.handleEditButtonPressed();
        } else if (button == this.removeButton) {
            this.handleRemoveButtonPressed();
        } else if (button == this.upButton) {
            this.moveSelectionUp();
        } else if (button == this.downButton) {
            this.moveSelectionDown();
        }
        this.handleTableSelectionChanged();
        this.viewer.getTable().setFocus();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        if (element instanceof ILaunchConfiguration) {
            this.enableLaunchConfiguration((ILaunchConfiguration)element, event.getChecked());
        } else if (element instanceof ICommand) {
            this.enableCommand((ICommand)element, event.getChecked());
        }
    }

    private void enableLaunchConfiguration(ILaunchConfiguration configuration, boolean enable) {
        ILaunchConfigurationWorkingCopy workingCopy = null;
        try {
            if (configuration instanceof ILaunchConfigurationWorkingCopy) {
                workingCopy = (ILaunchConfigurationWorkingCopy)configuration;
            } else {
                TableItem[] items = this.viewer.getTable().getItems();
                for (int i = 0; i < items.length; ++i) {
                    TableItem item = items[i];
                    if (item.getData() != configuration) continue;
                    workingCopy = configuration.getWorkingCopy();
                    item.setData((Object)workingCopy);
                }
            }
            if (workingCopy != null) {
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", enable);
            }
        }
        catch (CoreException e) {
            return;
        }
        this.userHasMadeChanges = true;
    }

    private void enableCommand(ICommand command, boolean enable) {
        HashMap<String, Boolean> args = command.getArguments();
        if (args == null) {
            args = new HashMap<String, Boolean>(1);
        }
        args.put(COMMAND_ENABLED, enable);
        command.setArguments(args);
        this.userHasMadeChanges = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleImportButtonPressed() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        List toolTypes = this.getConfigurationTypes("org.eclipse.ui.externaltools");
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        Iterator iter = toolTypes.iterator();
        while (iter.hasNext()) {
            try {
                ILaunchConfiguration[] configs = manager.getLaunchConfigurations((ILaunchConfigurationType)iter.next());
                for (int i = 0; i < configs.length; ++i) {
                    configurations.add(configs[i]);
                }
            }
            catch (CoreException e) {
            }
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new BuilderLabelProvider());
        dialog.setTitle(ExternalToolsUIMessages.getString("BuilderPropertyPage.4"));
        dialog.setMessage(ExternalToolsUIMessages.getString("BuilderPropertyPage.5"));
        dialog.setElements(configurations.toArray());
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results.length == 0) {
            return;
        }
        ILaunchConfiguration config = (ILaunchConfiguration)results[0];
        ILaunchConfiguration newConfig = null;
        boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
        try {
            this.setAutobuild(false);
            newConfig = BuilderUtils.duplicateConfiguration(this.getInputProject(), config);
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
        finally {
            try {
                this.setAutobuild(wasAutobuilding);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        if (newConfig != null) {
            this.userHasMadeChanges = true;
            this.viewer.add((Object)newConfig);
            this.viewer.setChecked((Object)newConfig, this.isEnabled(newConfig));
            this.newConfigList.add(newConfig);
        }
    }

    private void handleRemoveButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null) {
            int numSelected = selection.size();
            if (this.configsToBeDeleted == null) {
                this.configsToBeDeleted = new ArrayList(numSelected);
            }
            this.userHasMadeChanges = true;
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (item instanceof ILaunchConfiguration) {
                    this.configsToBeDeleted.add(item);
                    this.viewer.remove(item);
                    continue;
                }
                if (!(item instanceof ErrorConfig)) continue;
                this.viewer.remove(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewButtonPressed() {
        ILaunchConfigurationType type = this.promptForConfigurationType();
        if (type == null) {
            return;
        }
        boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
        try {
            ILaunchConfigurationWorkingCopy workingCopy = null;
            String name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(ExternalToolsUIMessages.getString("BuilderPropertyPage.New_Builder_7"));
            workingCopy = type.newInstance((IContainer)BuilderUtils.getBuilderFolder(this.getInputProject(), true), name);
            StringBuffer buffer = new StringBuffer("full");
            buffer.append(',');
            buffer.append("incremental");
            buffer.append(',');
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", buffer.toString());
            workingCopy.setAttribute("editedByExternalToolsMainTab", true);
            ILaunchConfiguration config = null;
            this.setAutobuild(false);
            config = workingCopy.doSave();
            this.newConfigList.add(config);
            int code = this.editConfiguration(config);
            if (code == 1) {
                this.newConfigList.remove(config);
                config.delete();
            } else {
                this.userHasMadeChanges = true;
                config = (ILaunchConfiguration)this.newConfigList.get(this.newConfigList.size() - 1);
                this.viewer.add((Object)config);
                this.viewer.setChecked((Object)config, this.isEnabled(config));
            }
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
        finally {
            try {
                this.setAutobuild(wasAutobuilding);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private int editConfiguration(ILaunchConfiguration config) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.addLaunchConfigurationListener(this.configurationListener);
        int code = DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)this.getShell(), (ILaunchConfiguration)config, (String)"org.eclipse.ui.externaltools.launchGroup.builder");
        manager.removeLaunchConfigurationListener(this.configurationListener);
        return code;
    }

    private ILaunchConfigurationType promptForConfigurationType() {
        List externalToolTypes = this.getConfigurationTypes("org.eclipse.ui.externaltools.builder");
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new BuilderLabelProvider());
        dialog.setElements(externalToolTypes.toArray());
        dialog.setMultipleSelection(false);
        dialog.setTitle(ExternalToolsUIMessages.getString("BuilderPropertyPage.Choose_configuration_type_8"));
        dialog.setMessage(ExternalToolsUIMessages.getString("BuilderPropertyPage.Choose_an_external_tool_type_to_create_9"));
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return (ILaunchConfigurationType)result[0];
    }

    private List getConfigurationTypes(String category) {
        ILaunchConfigurationType[] types = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        ArrayList<ILaunchConfigurationType> externalToolTypes = new ArrayList<ILaunchConfigurationType>();
        for (int i = 0; i < types.length; ++i) {
            ILaunchConfigurationType configurationType = types[i];
            if (!category.equals(configurationType.getCategory())) continue;
            externalToolTypes.add(configurationType);
        }
        return externalToolTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEditButtonPressed() {
        Object data;
        TableItem selection = this.viewer.getTable().getSelection()[0];
        if (selection != null && (data = selection.getData()) instanceof ILaunchConfiguration) {
            ILaunchConfiguration config = (ILaunchConfiguration)data;
            if (BuilderUtils.isUnmigratedConfig(config)) {
                if (!this.shouldProceedWithMigration()) {
                    return;
                }
                try {
                    config = BuilderUtils.migrateBuilderConfiguration(this.getInputProject(), (ILaunchConfigurationWorkingCopy)config);
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                    return;
                }
                selection.setData((Object)config);
            }
            this.userHasMadeChanges = true;
            boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
            try {
                this.setAutobuild(false);
                this.editConfiguration(config);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
            finally {
                try {
                    this.setAutobuild(wasAutobuilding);
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
        }
    }

    private boolean shouldProceedWithMigration() {
        if (!ExternalToolsPlugin.getDefault().getPreferenceStore().getBoolean("externaltools.builders.promptForMigration")) {
            return true;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.Migrate_project_builder_10"), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.Not_Support"), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.Prompt"), (boolean)false, (IPreferenceStore)ExternalToolsPlugin.getDefault().getPreferenceStore(), (String)"externaltools.builders.promptForMigration");
        return dialog.getReturnCode() == 2;
    }

    private void handleException(Exception e) {
        Object status = e instanceof CoreException ? ((CoreException)((Object)e)).getStatus() : new Status(4, "org.eclipse.ui.externaltools", 0, ExternalToolsUIMessages.getString("BuilderPropertyPage.statusMessage"), (Throwable)e);
        ErrorDialog.openError((Shell)this.getShell(), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.errorTitle"), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.errorMessage"), (IStatus)status);
    }

    private void handleTableSelectionChanged() {
        boolean validSelection;
        this.newButton.setEnabled(true);
        Table builderTable = this.viewer.getTable();
        TableItem[] items = builderTable.getSelection();
        boolean enableEdit = validSelection = items != null && items.length > 0;
        boolean enableRemove = validSelection;
        boolean enableUp = validSelection;
        boolean enableDown = validSelection;
        if (validSelection) {
            if (items.length > 1) {
                enableEdit = false;
            }
            int[] indices = builderTable.getSelectionIndices();
            int max = builderTable.getItemCount();
            enableUp = indices[0] != 0;
            enableDown = indices[indices.length - 1] < max - 1;
            for (int i = 0; i < items.length; ++i) {
                TableItem item = items[i];
                Object data = item.getData();
                if (data instanceof ILaunchConfiguration) {
                    ILaunchConfiguration config = (ILaunchConfiguration)data;
                    String builderName = null;
                    try {
                        builderName = config.getAttribute("org.eclipse.ui.externaltools.ATTR_DISABLED_BUILDER", (String)null);
                    }
                    catch (CoreException e) {
                        // empty catch block
                    }
                    if (builderName == null) continue;
                    enableEdit = false;
                    enableRemove = false;
                    continue;
                }
                enableEdit = false;
                if (data instanceof ErrorConfig) continue;
                enableRemove = false;
                break;
            }
        }
        this.editButton.setEnabled(enableEdit);
        this.removeButton.setEnabled(enableRemove);
        this.upButton.setEnabled(enableUp);
        this.downButton.setEnabled(enableDown);
    }

    private boolean isEnabled(Object element) {
        if (element instanceof ICommand) {
            Boolean enabled = (Boolean)((ICommand)element).getArguments().get(COMMAND_ENABLED);
            if (enabled != null) {
                return enabled;
            }
        } else if (element instanceof ILaunchConfiguration) {
            try {
                return ExternalToolsUtil.isBuilderEnabled((ILaunchConfiguration)element);
            }
            catch (CoreException coreException) {
            }
        } else if (element instanceof ErrorConfig) {
            return false;
        }
        return true;
    }

    private void move(TableItem item, int index) {
        this.userHasMadeChanges = true;
        Object data = item.getData();
        item.dispose();
        this.viewer.insert(data, index);
        this.viewer.setChecked(data, this.isEnabled(data));
    }

    private void moveSelectionDown() {
        Table builderTable = this.viewer.getTable();
        int[] indices = builderTable.getSelectionIndices();
        if (indices.length < 1) {
            return;
        }
        int[] newSelection = new int[indices.length];
        int max = builderTable.getItemCount() - 1;
        for (int i = indices.length - 1; i >= 0; --i) {
            int index = indices[i];
            if (index >= max) continue;
            this.move(builderTable.getItem(index), index + 1);
            newSelection[i] = index + 1;
        }
        builderTable.setSelection(newSelection);
    }

    private void moveSelectionUp() {
        Table builderTable = this.viewer.getTable();
        int[] indices = builderTable.getSelectionIndices();
        int[] newSelection = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            if (index <= 0) continue;
            this.move(builderTable.getItem(index), index - 1);
            newSelection[i] = index - 1;
        }
        builderTable.setSelection(newSelection);
    }

    public boolean performOk() {
        if (!this.userHasMadeChanges) {
            return super.performOk();
        }
        this.userHasMadeChanges = false;
        Table builderTable = this.viewer.getTable();
        int numCommands = builderTable.getItemCount();
        final Object[] itemData = new Object[numCommands];
        for (int i = 0; i < numCommands; ++i) {
            itemData[i] = builderTable.getItem(i).getData();
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                BuilderPropertyPage.this.doPerformOk(monitor, itemData);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return super.performOk();
    }

    private void doPerformOk(IProgressMonitor monitor, Object[] itemData) {
        if (monitor.isCanceled()) {
            return;
        }
        IProject project = this.getInputProject();
        int numCommands = itemData.length;
        monitor.beginTask(ExternalToolsUIMessages.getString("BuilderPropertyPage.3"), numCommands + 1);
        ICommand[] commands = new ICommand[numCommands];
        for (int i = 0; i < numCommands; ++i) {
            Object data = itemData[i];
            if (data instanceof ICommand) {
                ICommand command = (ICommand)data;
                Map args = command.getArguments();
                Boolean enabled = (Boolean)args.get(COMMAND_ENABLED);
                if (enabled != null && enabled.equals(Boolean.FALSE)) {
                    ILaunchConfiguration config = this.disableCommand(command);
                    if (config != null) {
                        data = BuilderUtils.commandFromLaunchConfig(project, config);
                    }
                } else {
                    args.remove(COMMAND_ENABLED);
                    command.setArguments(args);
                }
            } else if (data instanceof ILaunchConfiguration) {
                ILaunchConfigurationWorkingCopy workingCopy;
                ILaunchConfiguration config = (ILaunchConfiguration)data;
                try {
                    String disabledBuilderName = config.getAttribute("org.eclipse.ui.externaltools.ATTR_DISABLED_BUILDER", (String)null);
                    if (disabledBuilderName != null && ExternalToolsUtil.isBuilderEnabled(config)) {
                        commands[i] = this.translateBackToCommand(config, project);
                        continue;
                    }
                }
                catch (CoreException e1) {
                    // empty catch block
                }
                if (!BuilderUtils.isUnmigratedConfig(config) && config instanceof ILaunchConfigurationWorkingCopy && (workingCopy = (ILaunchConfigurationWorkingCopy)config).isDirty()) {
                    try {
                        workingCopy.doSave();
                    }
                    catch (CoreException e) {
                        MessageDialog.openError((Shell)this.getShell(), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.39"), (String)MessageFormat.format(ExternalToolsUIMessages.getString("BuilderPropertyPage.40"), workingCopy.getName()));
                    }
                }
                data = BuilderUtils.commandFromLaunchConfig(project, config);
            } else if (data instanceof ErrorConfig) {
                data = ((ErrorConfig)data).getCommand();
            }
            if (data != null) {
                commands[i] = (ICommand)data;
            }
            monitor.worked(1);
        }
        if (this.checkCommandsForChange(commands)) {
            try {
                IProjectDescription desc = project.getDescription();
                desc.setBuildSpec(commands);
                project.setDescription(desc, 1, monitor);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        if (this.configsToBeDeleted != null) {
            this.deleteConfigurations();
        }
        monitor.done();
    }

    private ICommand translateBackToCommand(ILaunchConfiguration config, IProject project) {
        try {
            ICommand newCommand = project.getDescription().newCommand();
            String builderName = config.getAttribute("org.eclipse.ui.externaltools.ATTR_DISABLED_BUILDER", (String)null);
            Map args = config.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", new HashMap(0));
            newCommand.setBuilderName(builderName);
            newCommand.setArguments(args);
            if (this.configsToBeDeleted == null) {
                this.configsToBeDeleted = new ArrayList();
            }
            this.configsToBeDeleted.add(config);
            return newCommand;
        }
        catch (CoreException exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.13"), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.error"));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILaunchConfiguration disableCommand(ICommand command) {
        List externalToolTypes;
        Map arguments = command.getArguments();
        if (arguments != null) {
            arguments.remove(COMMAND_ENABLED);
        }
        if ((externalToolTypes = this.getConfigurationTypes("org.eclipse.ui.externaltools.builder")).size() == 0) {
            return null;
        }
        ILaunchConfigurationType type = (ILaunchConfigurationType)externalToolTypes.get(0);
        if (type == null) {
            return null;
        }
        boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
        try {
            ILaunchConfigurationWorkingCopy workingCopy = null;
            String builderName = command.getBuilderName();
            String name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(builderName);
            workingCopy = type.newInstance((IContainer)BuilderUtils.getBuilderFolder(this.getInputProject(), true), name);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_DISABLED_BUILDER", builderName);
            if (arguments != null) {
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
            }
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", false);
            ILaunchConfiguration config = null;
            this.setAutobuild(false);
            ILaunchConfiguration iLaunchConfiguration = config = workingCopy.doSave();
            return iLaunchConfiguration;
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
        finally {
            try {
                this.setAutobuild(wasAutobuilding);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteConfigurations() {
        boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
        try {
            this.setAutobuild(false);
            Iterator itr = this.configsToBeDeleted.iterator();
            while (itr.hasNext()) {
                ILaunchConfiguration element = (ILaunchConfiguration)itr.next();
                element.delete();
            }
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
        finally {
            try {
                this.setAutobuild(wasAutobuilding);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private boolean checkCommandsForChange(ICommand[] newCommands) {
        try {
            ICommand[] oldCommands = this.getInputProject().getDescription().getBuildSpec();
            if (oldCommands.length != newCommands.length) {
                return true;
            }
            IgnoreWhiteSpaceComparator comparator = new IgnoreWhiteSpaceComparator();
            for (int i = 0; i < oldCommands.length; ++i) {
                ICommand oldCommand = oldCommands[i];
                ICommand newCommand = newCommands[i];
                String oldName = oldCommand.getBuilderName();
                String newName = newCommand.getBuilderName();
                if (oldName == null && newName != null) {
                    return true;
                }
                if (oldName != null && !oldName.equals(newName)) {
                    return true;
                }
                Map oldArgs = oldCommand.getArguments();
                Map newArgs = newCommand.getArguments();
                if (oldArgs == null && newArgs != null) {
                    return true;
                }
                if (oldArgs == null && newArgs == null) continue;
                if (oldArgs.size() != newArgs.size()) {
                    return true;
                }
                Iterator keySet = oldArgs.keySet().iterator();
                while (keySet.hasNext()) {
                    Object key = keySet.next();
                    Object oldArg = oldArgs.get(key);
                    Object newArg = newArgs.get(key);
                    if (!(oldArg instanceof String && newArg instanceof String ? comparator.compare(oldArg, newArg) != 0 : !oldArg.equals(newArg))) continue;
                    return true;
                }
            }
        }
        catch (CoreException ce) {
            return true;
        }
        return false;
    }

    public boolean performCancel() {
        Iterator iter = this.newConfigList.iterator();
        while (iter.hasNext()) {
            try {
                ((ILaunchConfiguration)iter.next()).delete();
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        try {
            IFolder builderFolder = BuilderUtils.getBuilderFolder(this.getInputProject(), false);
            if (builderFolder != null && builderFolder.exists() && builderFolder.members().length == 0) {
                builderFolder.delete(true, false, null);
            }
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
        Table builderTable = this.viewer.getTable();
        int numCommands = builderTable.getItemCount();
        for (int i = 0; i < numCommands; ++i) {
            Object data = builderTable.getItem(i).getData();
            if (!(data instanceof ICommand)) continue;
            ICommand command = (ICommand)data;
            Map args = command.getArguments();
            args.remove(COMMAND_ENABLED);
            command.setArguments(args);
        }
        return super.performCancel();
    }

    static /* synthetic */ CheckboxTableViewer access$200(BuilderPropertyPage x0) {
        return x0.viewer;
    }

    static /* synthetic */ List access$300(BuilderPropertyPage x0) {
        return x0.newConfigList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ErrorConfig {
        private ICommand command;

        public ErrorConfig(ICommand command) {
            this.command = command;
        }

        public ICommand getCommand() {
            return this.command;
        }
    }
}

