/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.feature.FeatureData;
import org.eclipse.pde.internal.core.feature.FeatureImport;
import org.eclipse.pde.internal.core.feature.FeatureInfo;
import org.eclipse.pde.internal.core.feature.FeatureInstallHandler;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.feature.FeatureURL;
import org.eclipse.pde.internal.core.feature.VersionableObject;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureInstallHandler;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Feature
extends VersionableObject
implements IFeature {
    static final String INDENT = "   ";
    private String providerName;
    private IFeatureURL url;
    private IFeatureInfo[] infos = new IFeatureInfo[3];
    private Vector data = new Vector();
    private Vector children = new Vector();
    private Vector plugins = new Vector();
    private Vector imports = new Vector();
    private String os;
    private String ws;
    private String nl;
    private String arch;
    private String imageName;
    private IFeatureInstallHandler handler;
    private boolean primary;
    private boolean exclusive;
    private String colocationAffinity;
    private String application;
    private String plugin;
    private boolean valid;

    public void addPlugins(IFeaturePlugin[] newPlugins) throws CoreException {
        this.ensureModelEditable();
        for (int i = 0; i < newPlugins.length; ++i) {
            this.plugins.add(newPlugins[i]);
            ((FeaturePlugin)newPlugins[i]).setInTheModel(true);
        }
        this.fireStructureChanged(newPlugins, 1);
    }

    public void addData(IFeatureData[] newData) throws CoreException {
        this.ensureModelEditable();
        for (int i = 0; i < newData.length; ++i) {
            this.data.add(newData[i]);
            ((FeatureData)newData[i]).setInTheModel(true);
        }
        this.fireStructureChanged(newData, 1);
    }

    public void addIncludedFeatures(IFeatureChild[] features) throws CoreException {
        this.ensureModelEditable();
        for (int i = 0; i < features.length; ++i) {
            this.children.add(features[i]);
            ((FeatureChild)features[i]).setInTheModel(true);
        }
        this.fireStructureChanged(features, 1);
    }

    public void addImports(IFeatureImport[] iimports) throws CoreException {
        this.ensureModelEditable();
        for (int i = 0; i < iimports.length; ++i) {
            this.imports.add(iimports[i]);
            ((FeatureImport)iimports[i]).setInTheModel(true);
        }
        this.fireStructureChanged(iimports, 1);
    }

    public IFeaturePlugin[] getPlugins() {
        Object[] result = new IFeaturePlugin[this.plugins.size()];
        this.plugins.copyInto(result);
        return result;
    }

    public IFeatureData[] getData() {
        Object[] result = new IFeatureData[this.data.size()];
        this.data.copyInto(result);
        return result;
    }

    public IFeatureChild[] getIncludedFeatures() {
        Object[] result = new IFeatureChild[this.children.size()];
        this.children.copyInto(result);
        return result;
    }

    public IFeatureImport[] getImports() {
        Object[] result = new IFeatureImport[this.imports.size()];
        this.imports.copyInto(result);
        return result;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public IPluginModelBase getReferencedModel(IFeaturePlugin reference) {
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        IPluginModelBase[] models = null;
        models = reference.isFragment() ? mng.getFragmentModels() : mng.getPluginModels();
        for (int i = 0; i < models.length; ++i) {
            IPluginBase base = models[i].getPluginBase();
            if (!base.getId().equals(reference.getId())) continue;
            return models[i];
        }
        return null;
    }

    public IFeatureURL getURL() {
        return this.url;
    }

    public IFeatureInstallHandler getInstallHandler() {
        return this.handler;
    }

    public IFeatureInfo getFeatureInfo(int index) {
        return this.infos[index];
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    protected void parse(Node node, Hashtable lineTable) {
        super.parse(node, lineTable);
        this.providerName = this.getNodeAttribute(node, "provider-name");
        this.plugin = this.getNodeAttribute(node, "plugin");
        this.os = this.getNodeAttribute(node, "os");
        this.ws = this.getNodeAttribute(node, "ws");
        this.nl = this.getNodeAttribute(node, "nl");
        this.arch = this.getNodeAttribute(node, "arch");
        this.imageName = this.getNodeAttribute(node, "image");
        this.colocationAffinity = this.getNodeAttribute(node, "colocation-affinity");
        this.application = this.getNodeAttribute(node, "application");
        this.primary = this.getBooleanAttribute(node, "primary");
        this.exclusive = this.getBooleanAttribute(node, "exclusive");
        NodeList children = node.getChildNodes();
        this.valid = true;
        for (int i = 0; i < children.getLength(); ++i) {
            IFeatureInfo info;
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String tag = child.getNodeName().toLowerCase();
            if (tag.equals("description")) {
                info = this.getModel().getFactory().createInfo(0);
                ((FeatureInfo)info).setInTheModel(true);
                ((FeatureInfo)info).parse(child, lineTable);
                this.infos[0] = info;
                continue;
            }
            if (tag.equals("license")) {
                info = this.getModel().getFactory().createInfo(2);
                ((FeatureInfo)info).setInTheModel(true);
                ((FeatureInfo)info).parse(child, lineTable);
                this.infos[2] = info;
                continue;
            }
            if (tag.equals("copyright")) {
                info = this.getModel().getFactory().createInfo(1);
                ((FeatureInfo)info).setInTheModel(true);
                ((FeatureInfo)info).parse(child, lineTable);
                this.infos[1] = info;
                continue;
            }
            if (tag.equals("url")) {
                if (this.url != null) continue;
                this.url = this.getModel().getFactory().createURL();
                ((FeatureURL)this.url).setInTheModel(true);
                ((FeatureURL)this.url).parse(child, lineTable);
                continue;
            }
            if (tag.equals("requires")) {
                this.parseRequires(child, lineTable);
                continue;
            }
            if (tag.equals("install-handler")) {
                IFeatureInstallHandler handler = this.getModel().getFactory().createInstallHandler();
                ((FeatureInstallHandler)handler).parse(child, lineTable);
                ((FeatureInstallHandler)handler).setInTheModel(true);
                this.handler = handler;
                continue;
            }
            if (tag.equals("plugin")) {
                IFeaturePlugin plugin = this.getModel().getFactory().createPlugin();
                ((FeaturePlugin)plugin).parse(child, lineTable);
                ((FeaturePlugin)plugin).setInTheModel(true);
                this.plugins.add(plugin);
                continue;
            }
            if (tag.equals("data")) {
                IFeatureData newData = this.getModel().getFactory().createData();
                ((FeatureData)newData).parse(child, lineTable);
                ((FeatureData)newData).setInTheModel(true);
                this.data.add(newData);
                continue;
            }
            if (!tag.equals("includes")) continue;
            IFeatureChild newChild = this.getModel().getFactory().createChild();
            ((FeatureChild)newChild).parse(child, lineTable);
            ((FeatureChild)newChild).setInTheModel(true);
            this.children.add(newChild);
        }
        this.valid = this.hasRequiredAttributes();
    }

    private void parseRequires(Node node, Hashtable lineTable) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase("import")) continue;
            IFeatureImport iimport = this.getModel().getFactory().createImport();
            ((FeatureImport)iimport).parse(child, lineTable);
            ((FeatureImport)iimport).setInTheModel(true);
            this.imports.add(iimport);
        }
    }

    public void computeImports() throws CoreException {
        IFeatureImport iimport;
        int i;
        IFeatureImport[] removed = null;
        if (this.imports.size() > 0) {
            ArrayList<IFeatureImport> list = new ArrayList<IFeatureImport>();
            for (i = 0; i < this.imports.size(); ++i) {
                iimport = (IFeatureImport)this.imports.get(i);
                if (iimport.getType() == 1) continue;
                list.add(iimport);
            }
            if (list.size() > 0) {
                this.imports.removeAll(list);
                removed = list.toArray(new IFeatureImport[list.size()]);
            }
        }
        this.imports.clear();
        if (removed != null) {
            this.fireStructureChanged(removed, 2);
        }
        for (int i2 = 0; i2 < this.plugins.size(); ++i2) {
            IFeaturePlugin fp = (IFeaturePlugin)this.plugins.get(i2);
            IPlugin plugin = PDECore.getDefault().findPlugin(fp.getId(), fp.getVersion(), 0);
            if (plugin == null) continue;
            this.addPluginImports(plugin);
        }
        Vector inputImports = (Vector)this.imports.clone();
        for (i = 0; i < inputImports.size(); ++i) {
            iimport = (IFeatureImport)inputImports.get(i);
            IFeaturePlugin local = this.findFeaturePlugin(iimport.getId(), iimport.getVersion(), iimport.getMatch());
            if (local == null) continue;
            this.imports.remove(iimport);
        }
        if (this.imports.size() > 0) {
            IFeatureObject[] added = this.imports.toArray(new IFeatureImport[this.imports.size()]);
            this.fireStructureChanged(added, 1);
        }
    }

    private void addPluginImports(IPluginBase plugin) throws CoreException {
        IPluginImport[] pluginImports = plugin.getImports();
        for (int i = 0; i < pluginImports.length; ++i) {
            int match;
            String version;
            IPluginImport pluginImport = pluginImports[i];
            String id = pluginImport.getId();
            if (this.findImport(id, version = pluginImport.getVersion(), match = pluginImport.getMatch()) != null) continue;
            IFeatureImport iimport = this.getModel().getFactory().createImport();
            iimport.setId(id);
            iimport.setVersion(version);
            iimport.setMatch(match);
            ((FeatureImport)iimport).setInTheModel(true);
            this.imports.add(iimport);
            IPlugin p = PDECore.getDefault().findPlugin(pluginImport.getId(), pluginImport.getVersion(), pluginImport.getMatch());
            ((FeatureImport)iimport).setPlugin(p);
        }
    }

    private IFeatureImport findImport(String id, String version, int match) {
        for (int i = 0; i < this.imports.size(); ++i) {
            IFeatureImport iimport = (IFeatureImport)this.imports.get(i);
            if (!iimport.getId().equals(id)) continue;
            if (version == null) {
                return iimport;
            }
            if (!version.equals(iimport.getVersion()) || match != iimport.getMatch()) continue;
            return iimport;
        }
        return null;
    }

    private IFeaturePlugin findFeaturePlugin(String id, String version, int match) {
        for (int i = 0; i < this.plugins.size(); ++i) {
            String pversion;
            IFeaturePlugin fp = (IFeaturePlugin)this.plugins.get(i);
            String pid = fp.getId();
            if (!PDECore.compare(id, version, pid, pversion = fp.getVersion(), match)) continue;
            return fp;
        }
        return null;
    }

    public void removePlugins(IFeaturePlugin[] removed) throws CoreException {
        this.ensureModelEditable();
        for (int i = 0; i < removed.length; ++i) {
            this.plugins.remove(removed[i]);
            ((FeaturePlugin)removed[i]).setInTheModel(false);
        }
        this.fireStructureChanged(removed, 2);
    }

    public void removeData(IFeatureData[] removed) throws CoreException {
        this.ensureModelEditable();
        for (int i = 0; i < removed.length; ++i) {
            this.data.remove(removed[i]);
            ((FeatureData)removed[i]).setInTheModel(false);
        }
        this.fireStructureChanged(removed, 2);
    }

    public void removeIncludedFeatures(IFeatureChild[] features) throws CoreException {
        this.ensureModelEditable();
        for (int i = 0; i < features.length; ++i) {
            this.children.remove(features[i]);
            ((FeatureChild)features[i]).setInTheModel(false);
        }
        this.fireStructureChanged(features, 2);
    }

    public void removeImports(IFeatureImport[] iimports) throws CoreException {
        this.ensureModelEditable();
        for (int i = 0; i < iimports.length; ++i) {
            this.imports.remove(iimports[i]);
            ((FeatureImport)iimports[i]).setInTheModel(false);
        }
        this.fireStructureChanged(iimports, 2);
    }

    public String getOS() {
        return this.os;
    }

    public String getWS() {
        return this.ws;
    }

    public String getNL() {
        return this.nl;
    }

    public String getArch() {
        return this.arch;
    }

    public String getColocationAffinity() {
        return this.colocationAffinity;
    }

    public String getApplication() {
        return this.application;
    }

    public void setOS(String os) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.os;
        this.os = os;
        this.firePropertyChanged("os", oldValue, os);
    }

    public void setWS(String ws) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.ws;
        this.ws = ws;
        this.firePropertyChanged("ws", oldValue, ws);
    }

    public void setNL(String nl) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.nl;
        this.nl = nl;
        this.firePropertyChanged("nl", oldValue, nl);
    }

    public void setArch(String arch) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.arch;
        this.arch = arch;
        this.firePropertyChanged("arch", oldValue, arch);
    }

    public void setPrimary(boolean newValue) throws CoreException {
        if (this.primary == newValue) {
            return;
        }
        this.ensureModelEditable();
        Boolean oldValue = this.primary ? Boolean.TRUE : Boolean.FALSE;
        this.primary = newValue;
        this.firePropertyChanged("primary", oldValue, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setExclusive(boolean newValue) throws CoreException {
        if (this.exclusive == newValue) {
            return;
        }
        this.ensureModelEditable();
        Boolean oldValue = this.exclusive ? Boolean.TRUE : Boolean.FALSE;
        this.exclusive = newValue;
        this.firePropertyChanged("exclusive", oldValue, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setColocationAffinity(String newValue) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.colocationAffinity;
        this.colocationAffinity = newValue;
        this.firePropertyChanged("colocation-affinity", oldValue, newValue);
    }

    public void setApplication(String newValue) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.application;
        this.application = newValue;
        this.firePropertyChanged("application", oldValue, newValue);
    }

    public void setProviderName(String providerName) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.providerName;
        this.providerName = providerName;
        this.firePropertyChanged("provider", oldValue, providerName);
    }

    public void setPlugin(String plugin) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.plugin;
        this.plugin = plugin;
        this.firePropertyChanged("plugin", oldValue, plugin);
    }

    public void setURL(IFeatureURL url) throws CoreException {
        this.ensureModelEditable();
        IFeatureURL oldValue = this.url;
        if (this.url != null) {
            ((FeatureURL)this.url).setInTheModel(false);
        }
        this.url = url;
        this.firePropertyChanged("url", oldValue, url);
    }

    public void setInstallHandler(IFeatureInstallHandler handler) throws CoreException {
        this.ensureModelEditable();
        IFeatureInstallHandler oldValue = this.handler;
        if (this.handler != null) {
            ((FeatureInstallHandler)this.handler).setInTheModel(false);
        }
        this.handler = handler;
        this.firePropertyChanged("installHandler", oldValue, handler);
    }

    /*
     * WARNING - void declaration
     */
    public void setFeatureInfo(IFeatureInfo info, int index) throws CoreException {
        void var4_4;
        this.ensureModelEditable();
        IFeatureInfo oldValue = this.infos[index];
        if (oldValue != null) {
            ((FeatureInfo)oldValue).setInTheModel(true);
        }
        this.infos[index] = info;
        switch (index) {
            case 0: {
                String property = "description";
                break;
            }
            case 2: {
                String property = "license";
                break;
            }
            case 1: {
                String property = "copyright";
                break;
            }
            default: {
                return;
            }
        }
        this.firePropertyChanged((String)var4_4, oldValue, info);
    }

    public void setImageName(String imageName) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.imageName;
        this.imageName = imageName;
        this.firePropertyChanged("image", oldValue, imageName);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("os")) {
            this.setOS((String)newValue);
        } else if (name.equals("ws")) {
            this.setWS((String)newValue);
        } else if (name.equals("nl")) {
            this.setNL((String)newValue);
        } else if (name.equals("arch")) {
            this.setArch((String)newValue);
        } else if (name.equals("colocation-affinity")) {
            this.setColocationAffinity((String)newValue);
        } else if (name.equals("application")) {
            this.setApplication((String)newValue);
        } else if (name.equals("primary")) {
            this.setPrimary(newValue != null ? (Boolean)newValue : false);
        } else if (name.equals("exclusive")) {
            this.setExclusive(newValue != null ? (Boolean)newValue : false);
        } else if (name.equals("provider")) {
            this.setProviderName((String)newValue);
        } else if (name.equals("plugin")) {
            this.setPlugin((String)newValue);
        } else if (name.equals("url")) {
            this.setURL((IFeatureURL)newValue);
        } else if (name.equals("installHandler")) {
            this.setInstallHandler((IFeatureInstallHandler)newValue);
        } else if (name.equals("description")) {
            this.setFeatureInfo((IFeatureInfo)newValue, 0);
        } else if (name.equals("license")) {
            this.setFeatureInfo((IFeatureInfo)newValue, 2);
        } else if (name.equals("copyright")) {
            this.setFeatureInfo((IFeatureInfo)newValue, 1);
        } else if (name.equals("image")) {
            this.setImageName((String)newValue);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    public void reset() {
        super.reset();
        this.data.clear();
        this.plugins.clear();
        this.imports.clear();
        this.children.clear();
        this.url = null;
        this.providerName = null;
        this.plugin = null;
        this.os = null;
        this.ws = null;
        this.nl = null;
        this.arch = null;
        this.infos[0] = null;
        this.infos[1] = null;
        this.infos[2] = null;
        this.primary = false;
        this.exclusive = false;
        this.colocationAffinity = null;
        this.application = null;
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    private boolean hasRequiredAttributes() {
        int i;
        if (this.id == null) {
            return false;
        }
        if (this.version == null) {
            return false;
        }
        for (i = 0; i < this.children.size(); ++i) {
            IFeatureChild child = (IFeatureChild)this.children.elementAt(i);
            if (child.getId() != null && child.getVersion() != null) continue;
            return false;
        }
        for (i = 0; i < this.plugins.size(); ++i) {
            IFeaturePlugin plugin = (IFeaturePlugin)this.plugins.elementAt(i);
            if (plugin.getId() != null && plugin.getVersion() != null) continue;
            return false;
        }
        for (i = 0; i < this.data.size(); ++i) {
            IFeatureData entry = (IFeatureData)this.data.elementAt(i);
            if (entry.getId() != null) continue;
            return false;
        }
        for (i = 0; i < this.imports.size(); ++i) {
            IFeatureImport iimport = (IFeatureImport)this.imports.elementAt(i);
            if (iimport.getId() != null) continue;
            return false;
        }
        return true;
    }

    public void write(String indent, PrintWriter writer) {
        int i;
        writer.print(indent + "<feature");
        String indent2 = indent + INDENT;
        String indenta = indent + INDENT + INDENT;
        this.writeIfDefined(indenta, writer, "id", this.getId());
        this.writeIfDefined(indenta, writer, "label", Feature.getWritableString(this.getLabel()));
        this.writeIfDefined(indenta, writer, "version", this.getVersion());
        this.writeIfDefined(indenta, writer, "provider-name", Feature.getWritableString(this.providerName));
        this.writeIfDefined(indenta, writer, "plugin", this.getPlugin());
        this.writeIfDefined(indenta, writer, "os", this.os);
        this.writeIfDefined(indenta, writer, "ws", this.ws);
        this.writeIfDefined(indenta, writer, "nl", this.nl);
        this.writeIfDefined(indenta, writer, "arch", this.arch);
        if (this.imageName != null) {
            this.writeIfDefined(indenta, writer, "image", Feature.getWritableString(this.imageName));
        }
        if (this.isPrimary()) {
            writer.println();
            writer.print(indenta + "primary=\"true\"");
        }
        if (this.isExclusive()) {
            writer.println();
            writer.print(indenta + "exclusive=\"true\"");
        }
        this.writeIfDefined(indenta, writer, "colocation-affinity", this.colocationAffinity);
        this.writeIfDefined(indenta, writer, "application", this.application);
        writer.println(">");
        if (this.handler != null) {
            writer.println();
            this.handler.write(indent2, writer);
        }
        for (i = 0; i < 3; ++i) {
            IFeatureInfo info = this.infos[i];
            if (info == null || info.isEmpty()) continue;
            info.write(indent2, writer);
        }
        if (this.url != null) {
            writer.println();
            this.url.write(indent2, writer);
        }
        for (i = 0; i < this.children.size(); ++i) {
            IFeatureChild child = (IFeatureChild)this.children.elementAt(i);
            writer.println();
            child.write(indent2, writer);
        }
        if (this.imports.size() > 0) {
            writer.println();
            writer.println(indent2 + "<requires>");
            for (i = 0; i < this.imports.size(); ++i) {
                IFeatureImport iimport = (IFeatureImport)this.imports.get(i);
                iimport.write(indenta, writer);
            }
            writer.println(indent2 + "</requires>");
        }
        for (i = 0; i < this.plugins.size(); ++i) {
            IFeaturePlugin plugin = (IFeaturePlugin)this.plugins.elementAt(i);
            writer.println();
            plugin.write(indent2, writer);
        }
        for (i = 0; i < this.data.size(); ++i) {
            IFeatureData entry = (IFeatureData)this.data.elementAt(i);
            writer.println();
            entry.write(indent2, writer);
        }
        writer.println();
        writer.println(indent + "</feature>");
    }

    private void writeIfDefined(String indent, PrintWriter writer, String attName, String attValue) {
        if (attValue == null || attValue.trim().length() == 0) {
            return;
        }
        writer.println();
        writer.print(indent + attName + "=\"" + attValue + "\"");
    }

    public String getImageName() {
        return this.imageName;
    }
}

