/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.feature.FeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.w3c.dom.Node;

public class FeatureURLElement
extends FeatureObject
implements IFeatureURLElement {
    private int elementType;
    private int siteType = 0;
    private URL url;

    public FeatureURLElement(int elementType) {
        this.elementType = elementType;
    }

    public FeatureURLElement(int elementType, URL url) {
        this.elementType = elementType;
        this.url = url;
    }

    public int getElementType() {
        return this.elementType;
    }

    public URL getURL() {
        return this.url;
    }

    public int getSiteType() {
        return this.siteType;
    }

    protected void parse(Node node, Hashtable lineTable) {
        super.parse(node, lineTable);
        this.bindSourceLocation(node, lineTable);
        String urlName = this.getNodeAttribute(node, "url");
        try {
            this.url = new URL(urlName);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        String typeName = this.getNodeAttribute(node, "type");
        if (typeName != null && typeName.equals("web")) {
            this.siteType = 1;
        }
    }

    public void setURL(URL url) throws CoreException {
        this.ensureModelEditable();
        URL oldValue = this.url;
        this.url = url;
        this.firePropertyChanged(this, "url", oldValue, url);
    }

    public void setSiteType(int type) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = new Integer(this.siteType);
        this.siteType = type;
        this.firePropertyChanged(this, "url", oldValue, new Integer(type));
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("url")) {
            this.setURL((URL)newValue);
        } else if (name.equals("siteType")) {
            this.setSiteType((Integer)newValue);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    public String toString() {
        if (this.label != null) {
            return this.label;
        }
        if (this.url != null) {
            return this.url.toString();
        }
        return super.toString();
    }

    public void write(String indent, PrintWriter writer) {
        String tag = null;
        switch (this.elementType) {
            case 1: {
                tag = "update";
                break;
            }
            case 2: {
                tag = "discovery";
            }
        }
        if (tag == null) {
            return;
        }
        writer.print(indent + "<" + tag);
        if (this.label != null) {
            writer.print(" label=\"" + FeatureURLElement.getWritableString(this.label) + "\"");
        }
        if (this.url != null) {
            writer.print(" url=\"" + FeatureURLElement.getWritableString(this.url.toString()) + "\"");
        }
        if (this.siteType == 1) {
            writer.print(" type=\"web\"");
        }
        writer.println("/>");
    }
}

