/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.schema.AbstractSchemaDescriptor;

public abstract class DevelopmentSchemaDescriptor
extends AbstractSchemaDescriptor {
    public IPath getPluginRelativePath(String pluginId, IPath path) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        ModelEntry entry = manager.findEntry(pluginId);
        if (entry == null) {
            return null;
        }
        IPluginModelBase model = entry.getActiveModel();
        if (model == null) {
            return null;
        }
        String location = model.getInstallLocation();
        IPath schemaPath = new Path(location).append(path);
        if (schemaPath.toFile().exists()) {
            return schemaPath;
        }
        File sourceFile = this.getSourceLocationFile(model, path);
        if (sourceFile != null && sourceFile.exists()) {
            return new Path(sourceFile.getAbsolutePath());
        }
        return null;
    }

    private File getSourceLocationFile(IPluginModelBase model, IPath path) {
        SourceLocationManager sourceManager = PDECore.getDefault().getSourceLocationManager();
        return sourceManager.findSourceFile(model.getPluginBase(), path);
    }
}

