/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import org.eclipse.jdt.internal.debug.ui.JDIContentAssistPreference;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class JDISourceViewer
extends SourceViewer
implements IPropertyChangeListener {
    private Font fFont;
    private Color fBackgroundColor;
    private Color fForegroundColor;

    public JDISourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, styles);
        StyledText text = this.getTextWidget();
        text.addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent event) {
                try {
                    event.segments = JDISourceViewer.this.getBidiLineSegments(event.lineOffset);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.updateViewerFont();
        this.updateViewerColors();
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void updateViewerFont() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            FontData data = null;
            data = store.contains("org.eclipse.jface.textfont") && !store.isDefault("org.eclipse.jface.textfont") ? PreferenceConverter.getFontData((IPreferenceStore)store, (String)"org.eclipse.jface.textfont") : PreferenceConverter.getDefaultFontData((IPreferenceStore)store, (String)"org.eclipse.jface.textfont");
            if (data != null) {
                Font font = new Font((Device)this.getTextWidget().getDisplay(), data);
                this.applyFont(font);
                if (this.getFont() != null) {
                    this.getFont().dispose();
                }
                this.setFont(font);
                return;
            }
        }
        this.applyFont(JFaceResources.getTextFont());
    }

    private void setFont(Font font) {
        this.fFont = font;
    }

    private Font getFont() {
        return this.fFont;
    }

    private void applyFont(Font font) {
        IDocument doc = this.getDocument();
        if (doc != null && doc.getLength() > 0) {
            Point selection = this.getSelectedRange();
            int topIndex = this.getTopIndex();
            StyledText styledText = this.getTextWidget();
            styledText.setRedraw(false);
            styledText.setFont(font);
            this.setSelectedRange(selection.x, selection.y);
            this.setTopIndex(topIndex);
            styledText.setRedraw(true);
        } else {
            this.getTextWidget().setFont(font);
        }
    }

    public void updateViewerColors() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            StyledText styledText = this.getTextWidget();
            Color color = store.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.getForegroundColor() != null) {
                this.getForegroundColor().dispose();
            }
            this.setForegroundColor(color);
            color = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.getBackgroundColor() != null) {
                this.getBackgroundColor().dispose();
            }
            this.setBackgroundColor(color);
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    protected Color getBackgroundColor() {
        return this.fBackgroundColor;
    }

    protected void setBackgroundColor(Color backgroundColor) {
        this.fBackgroundColor = backgroundColor;
    }

    protected Color getForegroundColor() {
        return this.fForegroundColor;
    }

    protected void setForegroundColor(Color foregroundColor) {
        this.fForegroundColor = foregroundColor;
    }

    protected IPreferenceStore getPreferenceStore() {
        return PreferenceConstants.getPreferenceStore();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property;
        IContentAssistant assistant = this.getContentAssistant();
        if (assistant instanceof ContentAssistant) {
            JDIContentAssistPreference.changeConfiguration((ContentAssistant)assistant, event);
        }
        if ("org.eclipse.jface.textfont".equals(property = event.getProperty())) {
            this.updateViewerFont();
        }
        if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property)) {
            this.updateViewerColors();
        }
        if (this.affectsTextPresentation(event)) {
            this.invalidateTextPresentation();
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return textTools.affectsBehavior(event);
    }

    public IContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    protected int[] getBidiLineSegments(int lineOffset) throws BadLocationException {
        IDocument document = this.getDocument();
        if (document == null) {
            return null;
        }
        IRegion line = document.getLineInformationOfOffset(lineOffset);
        ITypedRegion[] linePartitioning = document.computePartitioning(lineOffset, line.getLength());
        ArrayList<ITypedRegion> segmentation = new ArrayList<ITypedRegion>();
        for (int i = 0; i < linePartitioning.length; ++i) {
            if (!"__java_string".equals(linePartitioning[i].getType())) continue;
            segmentation.add(linePartitioning[i]);
        }
        if (segmentation.size() == 0) {
            return null;
        }
        int size = segmentation.size();
        int[] segments = new int[size * 2 + 1];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            int offset;
            ITypedRegion segment = (ITypedRegion)segmentation.get(i);
            if (i == 0) {
                segments[j++] = 0;
            }
            if ((offset = segment.getOffset() - lineOffset) > segments[j - 1]) {
                segments[j++] = offset;
            }
            if (offset + segment.getLength() >= line.getLength()) break;
            segments[j++] = offset + segment.getLength();
        }
        if (j < segments.length) {
            int[] result = new int[j];
            System.arraycopy(segments, 0, result, 0, j);
            segments = result;
        }
        return segments;
    }

    public void dispose() {
        if (this.getFont() != null) {
            this.getFont().dispose();
            this.setFont(null);
        }
        if (this.getBackgroundColor() != null) {
            this.getBackgroundColor().dispose();
            this.setBackgroundColor(null);
        }
        if (this.getForegroundColor() != null) {
            this.getForegroundColor().dispose();
            this.setForegroundColor(null);
        }
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

