/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.help.WorkbenchHelp;

public class MainTypeSelectionDialog
extends TwoPaneElementSelector {
    private final IType[] fTypes;

    public MainTypeSelectionDialog(Shell shell, IType[] types) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(16), (ILabelProvider)new PackageRenderer());
        Assert.isNotNull((Object)types);
        this.fTypes = types;
        this.setMessage(LauncherMessages.getString("MainTypeSelectionDialog.Choose_a_type"));
        this.setUpperListLabel(LauncherMessages.getString("MainTypeSelectionDialog.Matching_types"));
        this.setLowerListLabel(LauncherMessages.getString("MainTypeSelectionDialog.Qualifier"));
    }

    public IType[] getTypes() {
        return this.fTypes;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)IJavaDebugHelpContextIds.MAIN_TYPE_SELECTION_DIALOG);
    }

    public int open() {
        if (this.fTypes == null) {
            return 1;
        }
        this.setElements(this.fTypes);
        return super.open();
    }

    public Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        MainTypeSelectionDialog.applyDialogFont((Control)control);
        return control;
    }

    private static class PackageRenderer
    extends JavaElementLabelProvider {
        public PackageRenderer() {
            super(2114);
        }

        public Image getImage(Object element) {
            return super.getImage((Object)((IType)element).getPackageFragment());
        }

        public String getText(Object element) {
            return super.getText((Object)((IType)element).getPackageFragment());
        }
    }
}

