/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.launching.JREContainer;
import org.eclipse.jdt.internal.launching.JREContainerInitializer;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RuntimeClasspathEntryLabelProvider
extends LabelProvider {
    private WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
    private ILaunchConfiguration fLaunchConfiguration;

    public Image getImage(Object element) {
        IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)element;
        IResource resource = entry.getResource();
        switch (entry.getType()) {
            case 1: {
                IJavaElement proj = JavaCore.create((IResource)resource);
                return this.lp.getImage((Object)proj);
            }
            case 2: {
                if (resource instanceof IContainer) {
                    return this.lp.getImage((Object)resource);
                }
                boolean external = resource == null;
                boolean source = entry.getSourceAttachmentPath() != null && !Path.EMPTY.equals((Object)entry.getSourceAttachmentPath());
                String key = null;
                key = external ? (source ? "org.eclipse.jdt.ui.jar_lsrc_obj.gif" : "org.eclipse.jdt.ui.jar_l_obj.gif") : (source ? "org.eclipse.jdt.ui.jar_src_obj.gif" : "org.eclipse.jdt.ui.jar_obj.gif");
                return JavaPluginImages.get((String)key);
            }
            case 3: {
                return DebugUITools.getImage((String)"IMG_OBJS_ENV_VAR");
            }
            case 4: {
                return JavaPluginImages.get((String)"org.eclipse.jdt.ui.library_obj.gif");
            }
            case 5: {
                Image image;
                IRuntimeClasspathEntry delegate = entry;
                if (entry instanceof ClasspathEntry) {
                    delegate = ((ClasspathEntry)entry).getDelegate();
                }
                if ((image = this.lp.getImage((Object)delegate)) != null) {
                    return image;
                }
                if (resource == null) {
                    return JavaPluginImages.get((String)"org.eclipse.jdt.ui.library_obj.gif");
                }
                return this.lp.getImage((Object)resource);
            }
        }
        return null;
    }

    public String getText(Object element) {
        IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)element;
        switch (entry.getType()) {
            case 1: {
                IResource res = entry.getResource();
                IJavaElement proj = JavaCore.create((IResource)res);
                return this.lp.getText((Object)proj);
            }
            case 2: {
                IPath path = entry.getPath();
                String[] segments = path.segments();
                StringBuffer displayPath = new StringBuffer();
                if (segments.length > 0) {
                    displayPath.append(segments[segments.length - 1]);
                    displayPath.append(" - ");
                    String device = path.getDevice();
                    if (device != null) {
                        displayPath.append(device);
                    }
                    displayPath.append(File.separator);
                    for (int i = 0; i < segments.length - 1; ++i) {
                        displayPath.append(segments[i]).append(File.separator);
                    }
                }
                return displayPath.toString();
            }
            case 3: {
                IPath path = entry.getPath();
                IPath srcPath = entry.getSourceAttachmentPath();
                StringBuffer buf = new StringBuffer(path.toString());
                if (srcPath != null) {
                    buf.append(" [");
                    buf.append(srcPath.toString());
                    IPath rootPath = entry.getSourceAttachmentRootPath();
                    if (rootPath != null) {
                        buf.append('/');
                        buf.append(rootPath.toString());
                    }
                    buf.append(']');
                }
                if (path.equals(new Path("JRE_LIB")) && this.fLaunchConfiguration != null) {
                    try {
                        IVMInstall vm = JavaRuntime.computeVMInstall((ILaunchConfiguration)this.fLaunchConfiguration);
                        buf.append(" - ");
                        buf.append(vm.getName());
                    }
                    catch (CoreException e) {
                        // empty catch block
                    }
                }
                return buf.toString();
            }
            case 4: {
                IPath path = entry.getPath();
                if (this.fLaunchConfiguration != null) {
                    try {
                        if (path.equals(new Path(JavaRuntime.JRE_CONTAINER))) {
                            IVMInstall vm = JavaRuntime.computeVMInstall((ILaunchConfiguration)this.fLaunchConfiguration);
                            return MessageFormat.format(LauncherMessages.getString("RuntimeClasspathEntryLabelProvider.JRE_System_Library_[{0}]_2"), vm.getName());
                        }
                        IJavaProject project = null;
                        try {
                            project = JavaRuntime.getJavaProject((ILaunchConfiguration)this.fLaunchConfiguration);
                        }
                        catch (CoreException e) {
                            // empty catch block
                        }
                        if (project == null) {
                            IVMInstall vm;
                            if (path.segmentCount() > 0 && path.segment(0).equals(JavaRuntime.JRE_CONTAINER) && (vm = JREContainerInitializer.resolveVM((IPath)path)) != null) {
                                JREContainer container = new JREContainer(vm, path);
                                return container.getDescription();
                            }
                        } else {
                            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                            if (container != null) {
                                return container.getDescription();
                            }
                        }
                    }
                    catch (CoreException e) {
                        // empty catch block
                    }
                }
                return entry.getPath().toString();
            }
            case 5: {
                String name;
                IRuntimeClasspathEntry delegate = entry;
                if (entry instanceof ClasspathEntry) {
                    delegate = ((ClasspathEntry)entry).getDelegate();
                }
                if ((name = this.lp.getText((Object)delegate)) == null || name.length() == 0) {
                    return ((IRuntimeClasspathEntry2)delegate).getName();
                }
                return name;
            }
        }
        return "";
    }

    public void dispose() {
        super.dispose();
        this.lp.dispose();
    }

    public void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fLaunchConfiguration = configuration;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }
}

