/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.QualifiedNamesConstants;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticAccessMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClassFile
implements AttributeNamesConstants,
CompilerModifiers,
TypeConstants,
TypeIds {
    public SourceTypeBinding referenceBinding;
    public ConstantPool constantPool;
    public ClassFile enclosingClassFile;
    public int produceDebugAttributes;
    public ReferenceBinding[] innerClassesBindings;
    public int numberOfInnerClasses;
    public byte[] header;
    public byte[] contents;
    public int headerOffset;
    public int contentsOffset;
    public int constantPoolOffset;
    public int methodCountOffset;
    public int methodCount;
    protected boolean creatingProblemType;
    public static final int INITIAL_CONTENTS_SIZE = 400;
    public static final int INITIAL_HEADER_SIZE = 1500;
    public boolean ownSharedArrays = false;
    public static final int INNER_CLASSES_SIZE = 5;
    public CodeStream codeStream;
    protected int problemLine;
    public long targetJDK;

    public ClassFile() {
    }

    public ClassFile(SourceTypeBinding aType, ClassFile enclosingClassFile, boolean creatingProblemType) {
        this.referenceBinding = aType;
        this.initByteArrays();
        this.header[this.headerOffset++] = -54;
        this.header[this.headerOffset++] = -2;
        this.header[this.headerOffset++] = -70;
        this.header[this.headerOffset++] = -66;
        this.targetJDK = this.referenceBinding.scope.environment().options.targetJDK;
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 8);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 0);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 24);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 16);
        this.constantPoolOffset = this.headerOffset;
        this.headerOffset += 2;
        this.constantPool = new ConstantPool(this);
        int accessFlags = aType.getAccessFlags();
        if (aType.isPrivate()) {
            accessFlags &= 0xFFFFFFFE;
        }
        if (aType.isProtected()) {
            accessFlags |= 1;
        }
        accessFlags &= 0xFFFFF6D1;
        if (aType.isClass()) {
            accessFlags |= 0x20;
        }
        this.enclosingClassFile = enclosingClassFile;
        this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
        this.contents[this.contentsOffset++] = (byte)accessFlags;
        int classNameIndex = this.constantPool.literalIndex(aType);
        this.contents[this.contentsOffset++] = (byte)(classNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)classNameIndex;
        int superclassNameIndex = aType.isInterface() ? this.constantPool.literalIndexForJavaLangObject() : (aType.superclass == null ? 0 : this.constantPool.literalIndex(aType.superclass));
        this.contents[this.contentsOffset++] = (byte)(superclassNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)superclassNameIndex;
        ReferenceBinding[] superInterfacesBinding = aType.superInterfaces();
        int interfacesCount = superInterfacesBinding.length;
        this.contents[this.contentsOffset++] = (byte)(interfacesCount >> 8);
        this.contents[this.contentsOffset++] = (byte)interfacesCount;
        for (int i = 0; i < interfacesCount; ++i) {
            int interfaceIndex = this.constantPool.literalIndex(superInterfacesBinding[i]);
            this.contents[this.contentsOffset++] = (byte)(interfaceIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)interfaceIndex;
        }
        this.produceDebugAttributes = this.referenceBinding.scope.environment().options.produceDebugAttributes;
        this.innerClassesBindings = new ReferenceBinding[5];
        this.creatingProblemType = creatingProblemType;
        this.codeStream = new CodeStream(this);
        ClassFile outermostClassFile = this.outerMostEnclosingClassFile();
        this.codeStream.maxFieldCount = this == outermostClassFile ? aType.scope.referenceType().maxFieldCount : outermostClassFile.codeStream.maxFieldCount;
    }

    public void addAbstractMethod(AbstractMethodDeclaration method, MethodBinding methodBinding) {
        methodBinding.modifiers = 1025;
        this.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void addAttributes() {
        this.contents[this.methodCountOffset++] = (byte)(this.methodCount >> 8);
        this.contents[this.methodCountOffset] = (byte)this.methodCount;
        int attributeNumber = 0;
        int attributeOffset = this.contentsOffset;
        this.contentsOffset += 2;
        if ((this.produceDebugAttributes & 1) != 0) {
            String fullFileName = new String(this.referenceBinding.scope.referenceCompilationUnit().getFileName());
            int lastIndex = (fullFileName = fullFileName.replace('\\', '/')).lastIndexOf(47);
            if (lastIndex != -1) {
                fullFileName = fullFileName.substring(lastIndex + 1, fullFileName.length());
            }
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int sourceAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SourceName);
            this.contents[this.contentsOffset++] = (byte)(sourceAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)sourceAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            int fileNameIndex = this.constantPool.literalIndex(fullFileName.toCharArray());
            this.contents[this.contentsOffset++] = (byte)(fileNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)fileNameIndex;
            ++attributeNumber;
        }
        if (this.referenceBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int deprecatedAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(deprecatedAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)deprecatedAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributeNumber;
        }
        if (this.numberOfInnerClasses != 0) {
            int exSize = 8 * this.numberOfInnerClasses + 8;
            if (exSize + this.contentsOffset >= this.contents.length) {
                this.resizeContents(exSize);
            }
            int attributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.InnerClassName);
            this.contents[this.contentsOffset++] = (byte)(attributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)attributeNameIndex;
            int value = (this.numberOfInnerClasses << 3) + 2;
            this.contents[this.contentsOffset++] = (byte)(value >> 24);
            this.contents[this.contentsOffset++] = (byte)(value >> 16);
            this.contents[this.contentsOffset++] = (byte)(value >> 8);
            this.contents[this.contentsOffset++] = (byte)value;
            this.contents[this.contentsOffset++] = (byte)(this.numberOfInnerClasses >> 8);
            this.contents[this.contentsOffset++] = (byte)this.numberOfInnerClasses;
            for (int i = 0; i < this.numberOfInnerClasses; ++i) {
                ReferenceBinding innerClass = this.innerClassesBindings[i];
                int accessFlags = innerClass.getAccessFlags();
                int innerClassIndex = this.constantPool.literalIndex(innerClass);
                this.contents[this.contentsOffset++] = (byte)(innerClassIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)innerClassIndex;
                if (innerClass.isMemberType()) {
                    int outerClassIndex = this.constantPool.literalIndex(innerClass.enclosingType());
                    this.contents[this.contentsOffset++] = (byte)(outerClassIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)outerClassIndex;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (!innerClass.isAnonymousType()) {
                    int nameIndex = this.constantPool.literalIndex(innerClass.sourceName());
                    this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)nameIndex;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (innerClass.isAnonymousType()) {
                    accessFlags |= 2;
                } else if (innerClass.isLocalType() && !innerClass.isMemberType()) {
                    accessFlags |= 2;
                }
                this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
                this.contents[this.contentsOffset++] = (byte)accessFlags;
            }
            ++attributeNumber;
        }
        if (attributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[attributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[attributeOffset] = (byte)attributeNumber;
        this.header = this.constantPool.poolContent;
        this.headerOffset = this.constantPool.currentOffset;
        int constantPoolCount = this.constantPool.currentIndex;
        this.header[this.constantPoolOffset++] = (byte)(constantPoolCount >> 8);
        this.header[this.constantPoolOffset] = (byte)constantPoolCount;
    }

    public void addDefaultAbstractMethods() {
        MethodBinding[] defaultAbstractMethods = this.referenceBinding.getDefaultAbstractMethods();
        int max = defaultAbstractMethods.length;
        for (int i = 0; i < max; ++i) {
            this.generateMethodInfoHeader(defaultAbstractMethods[i]);
            int methodAttributeOffset = this.contentsOffset;
            int attributeNumber = this.generateMethodInfoAttribute(defaultAbstractMethods[i]);
            this.completeMethodInfo(methodAttributeOffset, attributeNumber);
        }
    }

    public void addFieldInfo(FieldBinding fieldBinding) {
        int attributeNumber = 0;
        if (this.contentsOffset + 30 >= this.contents.length) {
            this.resizeContents(30);
        }
        int accessFlags = fieldBinding.getAccessFlags();
        this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
        this.contents[this.contentsOffset++] = (byte)accessFlags;
        int nameIndex = this.constantPool.literalIndex(fieldBinding.name);
        this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)nameIndex;
        int descriptorIndex = this.constantPool.literalIndex(fieldBinding.type.signature());
        this.contents[this.contentsOffset++] = (byte)(descriptorIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)descriptorIndex;
        int fieldAttributeOffset = this.contentsOffset;
        this.contentsOffset += 2;
        if (fieldBinding.constant != Constant.NotAConstant) {
            int constantValueNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.ConstantValueName);
            this.contents[this.contentsOffset++] = (byte)(constantValueNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)constantValueNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            ++attributeNumber;
            switch (fieldBinding.constant.typeID()) {
                case 5: {
                    int booleanValueIndex = this.constantPool.literalIndex(fieldBinding.constant.booleanValue() ? 1 : 0);
                    this.contents[this.contentsOffset++] = (byte)(booleanValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)booleanValueIndex;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    int integerValueIndex = this.constantPool.literalIndex(fieldBinding.constant.intValue());
                    this.contents[this.contentsOffset++] = (byte)(integerValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)integerValueIndex;
                    break;
                }
                case 9: {
                    int floatValueIndex = this.constantPool.literalIndex(fieldBinding.constant.floatValue());
                    this.contents[this.contentsOffset++] = (byte)(floatValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)floatValueIndex;
                    break;
                }
                case 8: {
                    int doubleValueIndex = this.constantPool.literalIndex(fieldBinding.constant.doubleValue());
                    this.contents[this.contentsOffset++] = (byte)(doubleValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)doubleValueIndex;
                    break;
                }
                case 7: {
                    int longValueIndex = this.constantPool.literalIndex(fieldBinding.constant.longValue());
                    this.contents[this.contentsOffset++] = (byte)(longValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)longValueIndex;
                    break;
                }
                case 11: {
                    int stringValueIndex = this.constantPool.literalIndex(((StringConstant)fieldBinding.constant).stringValue());
                    if (stringValueIndex == -1) {
                        if (!this.creatingProblemType) {
                            TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                            FieldDeclaration[] fieldDecls = typeDeclaration.fields;
                            int max = fieldDecls.length;
                            for (int i = 0; i < max; ++i) {
                                if (fieldDecls[i].binding != fieldBinding) continue;
                                typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(fieldDecls[i]);
                            }
                            break;
                        }
                        this.contentsOffset = fieldAttributeOffset + 2;
                        --attributeNumber;
                        break;
                    }
                    this.contents[this.contentsOffset++] = (byte)(stringValueIndex >> 8);
                    this.contents[this.contentsOffset++] = (byte)stringValueIndex;
                }
            }
        }
        if (fieldBinding.isSynthetic()) {
            int syntheticAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
            this.contents[this.contentsOffset++] = (byte)(syntheticAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)syntheticAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributeNumber;
        }
        if (fieldBinding.isDeprecated()) {
            int deprecatedAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(deprecatedAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)deprecatedAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributeNumber;
        }
        this.contents[fieldAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[fieldAttributeOffset] = (byte)attributeNumber;
    }

    public void addFieldInfos() {
        int i;
        SourceTypeBinding currentBinding = this.referenceBinding;
        FieldBinding[] syntheticFields = currentBinding.syntheticFields();
        int fieldCount = currentBinding.fieldCount() + (syntheticFields == null ? 0 : syntheticFields.length);
        if (fieldCount > 65535) {
            this.referenceBinding.scope.problemReporter().tooManyFields(this.referenceBinding.scope.referenceType());
        }
        this.contents[this.contentsOffset++] = (byte)(fieldCount >> 8);
        this.contents[this.contentsOffset++] = (byte)fieldCount;
        FieldBinding[] fieldBindings = currentBinding.fields();
        int max = fieldBindings.length;
        for (i = 0; i < max; ++i) {
            this.addFieldInfo(fieldBindings[i]);
        }
        if (syntheticFields != null) {
            max = syntheticFields.length;
            for (i = 0; i < max; ++i) {
                this.addFieldInfo(syntheticFields[i]);
            }
        }
    }

    public void addInnerClasses(ReferenceBinding refBinding) {
        for (int i = 0; i < this.numberOfInnerClasses; ++i) {
            if (this.innerClassesBindings[i] != refBinding) continue;
            return;
        }
        int length = this.innerClassesBindings.length;
        if (this.numberOfInnerClasses == length) {
            this.innerClassesBindings = new ReferenceBinding[length * 2];
            System.arraycopy(this.innerClassesBindings, 0, this.innerClassesBindings, 0, length);
        }
        this.innerClassesBindings[this.numberOfInnerClasses++] = refBinding;
    }

    public void addProblemClinit(IProblem[] problems) {
        this.generateMethodInfoHeaderForClinit();
        this.contentsOffset -= 2;
        int attributeOffset = this.contentsOffset;
        this.contentsOffset += 2;
        int attributeNumber = 0;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.resetForProblemClinit(this);
        String problemString = "";
        if (problems != null) {
            int max = problems.length;
            StringBuffer buffer = new StringBuffer(25);
            int count = 0;
            for (int i = 0; i < max; ++i) {
                IProblem problem = problems[i];
                if (problem == null || !problem.isError()) continue;
                buffer.append("\t" + problem.getMessage() + "\n");
                ++count;
                if (this.problemLine == 0) {
                    this.problemLine = problem.getSourceLineNumber();
                }
                problems[i] = null;
            }
            if (count > 1) {
                buffer.insert(0, Util.bind("compilation.unresolvedProblems"));
            } else {
                buffer.insert(0, Util.bind("compilation.unresolvedProblem"));
            }
            problemString = buffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        this.completeCodeAttributeForClinit(codeAttributeOffset, this.referenceBinding.scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        this.contents[attributeOffset++] = (byte)(++attributeNumber >> 8);
        this.contents[attributeOffset] = (byte)attributeNumber;
    }

    public void addProblemConstructor(AbstractMethodDeclaration method, MethodBinding methodBinding, IProblem[] problems) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        ++attributeNumber;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(method, this);
        String problemString = "";
        if (problems != null) {
            int max = problems.length;
            StringBuffer buffer = new StringBuffer(25);
            int count = 0;
            for (int i = 0; i < max; ++i) {
                IProblem problem = problems[i];
                if (problem == null || !problem.isError()) continue;
                buffer.append("\t" + problem.getMessage() + "\n");
                ++count;
                if (this.problemLine != 0) continue;
                this.problemLine = problem.getSourceLineNumber();
            }
            if (count > 1) {
                buffer.insert(0, Util.bind("compilation.unresolvedProblems"));
            } else {
                buffer.insert(0, Util.bind("compilation.unresolvedProblem"));
            }
            problemString = buffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        this.completeCodeAttributeForProblemMethod(method, methodBinding, codeAttributeOffset, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void addProblemConstructor(AbstractMethodDeclaration method, MethodBinding methodBinding, IProblem[] problems, int savedOffset) {
        this.contentsOffset = savedOffset;
        --this.methodCount;
        this.addProblemConstructor(method, methodBinding, problems);
    }

    public void addProblemMethod(AbstractMethodDeclaration method, MethodBinding methodBinding, IProblem[] problems) {
        if (methodBinding.isAbstract() && methodBinding.declaringClass.isInterface()) {
            method.abort(8, null);
        }
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        ++attributeNumber;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(method, this);
        String problemString = "";
        if (problems != null) {
            int max = problems.length;
            StringBuffer buffer = new StringBuffer(25);
            int count = 0;
            for (int i = 0; i < max; ++i) {
                IProblem problem = problems[i];
                if (problem == null || !problem.isError() || problem.getSourceStart() < method.declarationSourceStart || problem.getSourceEnd() > method.declarationSourceEnd) continue;
                buffer.append("\t" + problem.getMessage() + "\n");
                ++count;
                if (this.problemLine == 0) {
                    this.problemLine = problem.getSourceLineNumber();
                }
                problems[i] = null;
            }
            if (count > 1) {
                buffer.insert(0, Util.bind("compilation.unresolvedProblems"));
            } else {
                buffer.insert(0, Util.bind("compilation.unresolvedProblem"));
            }
            problemString = buffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        this.completeCodeAttributeForProblemMethod(method, methodBinding, codeAttributeOffset, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void addProblemMethod(AbstractMethodDeclaration method, MethodBinding methodBinding, IProblem[] problems, int savedOffset) {
        this.contentsOffset = savedOffset;
        --this.methodCount;
        this.addProblemMethod(method, methodBinding, problems);
    }

    public void addSpecialMethods() {
        SourceTypeBinding currentBinding = this.referenceBinding;
        MethodBinding[] defaultAbstractMethods = currentBinding.getDefaultAbstractMethods();
        int max = defaultAbstractMethods.length;
        for (int i = 0; i < max; ++i) {
            this.generateMethodInfoHeader(defaultAbstractMethods[i]);
            int methodAttributeOffset = this.contentsOffset;
            int attributeNumber = this.generateMethodInfoAttribute(defaultAbstractMethods[i]);
            this.completeMethodInfo(methodAttributeOffset, attributeNumber);
        }
        SyntheticAccessMethodBinding[] syntheticAccessMethods = currentBinding.syntheticAccessMethods();
        if (syntheticAccessMethods != null) {
            int max2 = syntheticAccessMethods.length;
            block7: for (int i = 0; i < max2; ++i) {
                SyntheticAccessMethodBinding accessMethodBinding = syntheticAccessMethods[i];
                switch (accessMethodBinding.accessType) {
                    case 1: {
                        this.addSyntheticFieldReadAccessMethod(syntheticAccessMethods[i]);
                        continue block7;
                    }
                    case 2: {
                        this.addSyntheticFieldWriteAccessMethod(syntheticAccessMethods[i]);
                        continue block7;
                    }
                    case 3: 
                    case 5: {
                        this.addSyntheticMethodAccessMethod(syntheticAccessMethods[i]);
                        continue block7;
                    }
                    case 4: {
                        this.addSyntheticConstructorAccessMethod(syntheticAccessMethods[i]);
                    }
                }
            }
        }
    }

    public void generateMissingAbstractMethods(MethodDeclaration[] methodDeclarations, CompilationResult compilationResult) {
        if (methodDeclarations != null) {
            int max = methodDeclarations.length;
            for (int i = 0; i < max; ++i) {
                MethodDeclaration methodDeclaration = methodDeclarations[i];
                MethodBinding methodBinding = methodDeclaration.binding;
                String readableName = new String(methodBinding.readableName());
                IProblem[] problems = compilationResult.problems;
                int problemsCount = compilationResult.problemCount;
                for (int j = 0; j < problemsCount; ++j) {
                    IProblem problem = problems[j];
                    if (problem == null || problem.getID() != 67109264 || problem.getMessage().indexOf(readableName) == -1) continue;
                    this.addMissingAbstractProblemMethod(methodDeclaration, methodBinding, problem, compilationResult);
                }
            }
        }
    }

    private void addMissingAbstractProblemMethod(MethodDeclaration methodDeclaration, MethodBinding methodBinding, IProblem problem, CompilationResult compilationResult) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int methodAttributeOffset = this.contentsOffset;
        int attributeNumber = this.generateMethodInfoAttribute(methodBinding);
        ++attributeNumber;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("\t" + problem.getMessage() + "\n");
        buffer.insert(0, Util.bind("compilation.unresolvedProblem"));
        String problemString = buffer.toString();
        this.problemLine = problem.getSourceLineNumber();
        this.codeStream.init(this);
        this.codeStream.preserveUnusedLocals = true;
        this.codeStream.initializeMaxLocals(methodBinding);
        this.codeStream.generateCodeAttributeForProblemMethod(problemString);
        this.completeCodeAttributeForMissingAbstractProblemMethod(methodBinding, codeAttributeOffset, compilationResult.lineSeparatorPositions);
        this.completeMethodInfo(methodAttributeOffset, attributeNumber);
    }

    public void completeCodeAttributeForMissingAbstractProblemMethod(MethodBinding binding, int codeAttributeOffset, int[] startLineIndexes) {
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        int code_length = this.codeStream.position;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        if (localContentsOffset + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[localContentsOffset++] = 0;
        this.contents[localContentsOffset++] = 0;
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 6;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 1;
            if (this.problemLine == 0) {
                this.problemLine = ClassFile.searchLineNumber(startLineIndexes, binding.sourceStart());
            }
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(this.problemLine >> 8);
            this.contents[localContentsOffset++] = (byte)this.problemLine;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void addSyntheticConstructorAccessMethod(SyntheticAccessMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 2;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForConstructorAccess(methodBinding);
        this.completeCodeAttributeForSyntheticAccessMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        int syntheticAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
        this.contents[this.contentsOffset++] = (byte)(syntheticAttributeNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)syntheticAttributeNameIndex;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
    }

    public void addSyntheticFieldReadAccessMethod(SyntheticAccessMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 2;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldReadAccess(methodBinding);
        this.completeCodeAttributeForSyntheticAccessMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        int syntheticAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
        this.contents[this.contentsOffset++] = (byte)(syntheticAttributeNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)syntheticAttributeNameIndex;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
    }

    public void addSyntheticFieldWriteAccessMethod(SyntheticAccessMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 2;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldWriteAccess(methodBinding);
        this.completeCodeAttributeForSyntheticAccessMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        int syntheticAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
        this.contents[this.contentsOffset++] = (byte)(syntheticAttributeNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)syntheticAttributeNameIndex;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
    }

    public void addSyntheticMethodAccessMethod(SyntheticAccessMethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding);
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 2;
        int codeAttributeOffset = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForMethodAccess(methodBinding);
        this.completeCodeAttributeForSyntheticAccessMethod(methodBinding, codeAttributeOffset, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.lineSeparatorPositions);
        int syntheticAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
        this.contents[this.contentsOffset++] = (byte)(syntheticAttributeNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)syntheticAttributeNameIndex;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 0;
    }

    public static String buildAllDirectoriesInto(String outputPath, String relativeFileName) throws IOException {
        File f;
        char fileSeparatorChar = File.separatorChar;
        String fileSeparator = File.separator;
        if ((outputPath = outputPath.replace('/', fileSeparatorChar)).endsWith(fileSeparator)) {
            outputPath = outputPath.substring(0, outputPath.length() - 1);
        }
        if ((f = new File(outputPath)).exists()) {
            if (!f.isDirectory()) {
                System.out.println(Util.bind("output.isFile", f.getAbsolutePath()));
                throw new IOException(Util.bind("output.isFileNotDirectory"));
            }
        } else if (!f.mkdirs()) {
            System.out.println(Util.bind("output.dirName", f.getAbsolutePath()));
            throw new IOException(Util.bind("output.notValidAll"));
        }
        StringBuffer outDir = new StringBuffer(outputPath);
        outDir.append(fileSeparator);
        StringTokenizer tokenizer = new StringTokenizer(relativeFileName, fileSeparator);
        String token = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            f = new File(outDir.append(token).append(fileSeparator).toString());
            if (!f.exists() && !f.mkdir()) {
                System.out.println(Util.bind("output.fileName", f.getName()));
                throw new IOException(Util.bind("output.notValid"));
            }
            token = tokenizer.nextToken();
        }
        return outDir.append(token).toString();
    }

    public void completeCodeAttribute(int codeAttributeOffset) {
        int i;
        int nameIndex;
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int code_length = this.codeStream.position;
        if (code_length > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration);
        }
        if (localContentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        int exceptionHandlersNumber = this.codeStream.exceptionHandlersNumber;
        ExceptionLabel[] exceptionHandlers = this.codeStream.exceptionHandlers;
        int exSize = exceptionHandlersNumber * 8 + 2;
        if (exSize + localContentsOffset >= this.contents.length) {
            this.resizeContents(exSize);
        }
        this.contents[localContentsOffset++] = (byte)(exceptionHandlersNumber >> 8);
        this.contents[localContentsOffset++] = (byte)exceptionHandlersNumber;
        for (int i2 = 0; i2 < exceptionHandlersNumber; ++i2) {
            ExceptionLabel exceptionHandler = exceptionHandlers[i2];
            int start = exceptionHandler.start;
            this.contents[localContentsOffset++] = (byte)(start >> 8);
            this.contents[localContentsOffset++] = (byte)start;
            int end = exceptionHandler.end;
            this.contents[localContentsOffset++] = (byte)(end >> 8);
            this.contents[localContentsOffset++] = (byte)end;
            int handlerPC = exceptionHandler.position;
            this.contents[localContentsOffset++] = (byte)(handlerPC >> 8);
            this.contents[localContentsOffset++] = (byte)handlerPC;
            if (exceptionHandler.exceptionType == null) {
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
                continue;
            }
            nameIndex = exceptionHandler.exceptionType == BaseTypes.NullBinding ? this.constantPool.literalIndexForJavaLangClassNotFoundException() : this.constantPool.literalIndex(exceptionHandler.exceptionType);
            this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)nameIndex;
        }
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            int[] pcToSourceMapTable = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (localContentsOffset + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
                int lineNumberTableOffset = localContentsOffset;
                localContentsOffset += 6;
                int numberOfEntries = 0;
                int length = this.codeStream.pcToSourceMapSize;
                i = 0;
                while (i < length) {
                    if (localContentsOffset + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    int pc = pcToSourceMapTable[i++];
                    this.contents[localContentsOffset++] = (byte)(pc >> 8);
                    this.contents[localContentsOffset++] = (byte)pc;
                    int lineNumber = pcToSourceMapTable[i++];
                    this.contents[localContentsOffset++] = (byte)(lineNumber >> 8);
                    this.contents[localContentsOffset++] = (byte)lineNumber;
                    ++numberOfEntries;
                }
                int lineNumberAttr_length = numberOfEntries * 4 + 2;
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 24);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 16);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 8);
                this.contents[lineNumberTableOffset++] = (byte)lineNumberAttr_length;
                this.contents[lineNumberTableOffset++] = (byte)(numberOfEntries >> 8);
                this.contents[lineNumberTableOffset++] = (byte)numberOfEntries;
                ++attributeNumber;
            }
        }
        if (this.codeStream.generateLocalVariableTableAttributes) {
            int descriptorIndex;
            int localVariableTableOffset = localContentsOffset;
            int numberOfEntries = 0;
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            localContentsOffset += 6;
            if (!this.codeStream.methodDeclaration.isStatic()) {
                ++numberOfEntries;
                if (localContentsOffset + 10 >= this.contents.length) {
                    this.resizeContents(10);
                }
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                this.contents[localContentsOffset++] = (byte)code_length;
                nameIndex = this.constantPool.literalIndex(QualifiedNamesConstants.This);
                this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)nameIndex;
                descriptorIndex = this.constantPool.literalIndex(this.codeStream.methodDeclaration.binding.declaringClass.signature());
                this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                this.contents[localContentsOffset++] = (byte)descriptorIndex;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
            }
            for (i = 0; i < this.codeStream.allLocalsCounter; ++i) {
                LocalVariableBinding localVariable = this.codeStream.locals[i];
                for (int j = 0; j < localVariable.initializationCount; ++j) {
                    int startPC = localVariable.initializationPCs[j << 1];
                    int endPC = localVariable.initializationPCs[(j << 1) + 1];
                    if (startPC == endPC) continue;
                    if (endPC == -1) {
                        localVariable.declaringScope.problemReporter().abortDueToInternalError(Util.bind("abort.invalidAttribute", new String(localVariable.name)), (ASTNode)((Object)localVariable.declaringScope.methodScope().referenceContext));
                    }
                    if (localContentsOffset + 10 >= this.contents.length) {
                        this.resizeContents(10);
                    }
                    ++numberOfEntries;
                    this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                    this.contents[localContentsOffset++] = (byte)startPC;
                    int length = endPC - startPC;
                    this.contents[localContentsOffset++] = (byte)(length >> 8);
                    this.contents[localContentsOffset++] = (byte)length;
                    nameIndex = this.constantPool.literalIndex(localVariable.name);
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                    descriptorIndex = this.constantPool.literalIndex(localVariable.type.signature());
                    this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)descriptorIndex;
                    int resolvedPosition = localVariable.resolvedPosition;
                    this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                    this.contents[localContentsOffset++] = (byte)resolvedPosition;
                }
            }
            int value = numberOfEntries * 10 + 2;
            localVariableTableOffset += 2;
            this.contents[localVariableTableOffset++] = (byte)(value >> 24);
            this.contents[localVariableTableOffset++] = (byte)(value >> 16);
            this.contents[localVariableTableOffset++] = (byte)(value >> 8);
            this.contents[localVariableTableOffset++] = (byte)value;
            this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
            this.contents[localVariableTableOffset] = (byte)numberOfEntries;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForClinit(int codeAttributeOffset) {
        int i;
        int nameIndex;
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int code_length = this.codeStream.position;
        if (code_length > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (localContentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        int exceptionHandlersNumber = this.codeStream.exceptionHandlersNumber;
        ExceptionLabel[] exceptionHandlers = this.codeStream.exceptionHandlers;
        int exSize = exceptionHandlersNumber * 8 + 2;
        if (exSize + localContentsOffset >= this.contents.length) {
            this.resizeContents(exSize);
        }
        this.contents[localContentsOffset++] = (byte)(exceptionHandlersNumber >> 8);
        this.contents[localContentsOffset++] = (byte)exceptionHandlersNumber;
        for (int i2 = 0; i2 < exceptionHandlersNumber; ++i2) {
            ExceptionLabel exceptionHandler = exceptionHandlers[i2];
            int start = exceptionHandler.start;
            this.contents[localContentsOffset++] = (byte)(start >> 8);
            this.contents[localContentsOffset++] = (byte)start;
            int end = exceptionHandler.end;
            this.contents[localContentsOffset++] = (byte)(end >> 8);
            this.contents[localContentsOffset++] = (byte)end;
            int handlerPC = exceptionHandler.position;
            this.contents[localContentsOffset++] = (byte)(handlerPC >> 8);
            this.contents[localContentsOffset++] = (byte)handlerPC;
            if (exceptionHandler.exceptionType == null) {
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
                continue;
            }
            nameIndex = exceptionHandler.exceptionType == BaseTypes.NullBinding ? this.constantPool.literalIndexForJavaLangClassNotFoundException() : this.constantPool.literalIndex(exceptionHandler.exceptionType);
            this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)nameIndex;
        }
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            int[] pcToSourceMapTable = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (localContentsOffset + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
                int lineNumberTableOffset = localContentsOffset;
                localContentsOffset += 6;
                int numberOfEntries = 0;
                int length = this.codeStream.pcToSourceMapSize;
                i = 0;
                while (i < length) {
                    if (localContentsOffset + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    int pc = pcToSourceMapTable[i++];
                    this.contents[localContentsOffset++] = (byte)(pc >> 8);
                    this.contents[localContentsOffset++] = (byte)pc;
                    int lineNumber = pcToSourceMapTable[i++];
                    this.contents[localContentsOffset++] = (byte)(lineNumber >> 8);
                    this.contents[localContentsOffset++] = (byte)lineNumber;
                    ++numberOfEntries;
                }
                int lineNumberAttr_length = numberOfEntries * 4 + 2;
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 24);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 16);
                this.contents[lineNumberTableOffset++] = (byte)(lineNumberAttr_length >> 8);
                this.contents[lineNumberTableOffset++] = (byte)lineNumberAttr_length;
                this.contents[lineNumberTableOffset++] = (byte)(numberOfEntries >> 8);
                this.contents[lineNumberTableOffset++] = (byte)numberOfEntries;
                ++attributeNumber;
            }
        }
        if (this.codeStream.generateLocalVariableTableAttributes) {
            int localVariableTableOffset = localContentsOffset;
            int numberOfEntries = 0;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
                if (localContentsOffset + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
                localContentsOffset += 6;
                for (i = 0; i < this.codeStream.allLocalsCounter; ++i) {
                    LocalVariableBinding localVariable = this.codeStream.locals[i];
                    for (int j = 0; j < localVariable.initializationCount; ++j) {
                        int startPC = localVariable.initializationPCs[j << 1];
                        int endPC = localVariable.initializationPCs[(j << 1) + 1];
                        if (startPC == endPC) continue;
                        if (endPC == -1) {
                            localVariable.declaringScope.problemReporter().abortDueToInternalError(Util.bind("abort.invalidAttribute", new String(localVariable.name)), (ASTNode)((Object)localVariable.declaringScope.methodScope().referenceContext));
                        }
                        if (localContentsOffset + 10 >= this.contents.length) {
                            this.resizeContents(10);
                        }
                        ++numberOfEntries;
                        this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                        this.contents[localContentsOffset++] = (byte)startPC;
                        int length = endPC - startPC;
                        this.contents[localContentsOffset++] = (byte)(length >> 8);
                        this.contents[localContentsOffset++] = (byte)length;
                        nameIndex = this.constantPool.literalIndex(localVariable.name);
                        this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)nameIndex;
                        int descriptorIndex = this.constantPool.literalIndex(localVariable.type.signature());
                        this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)descriptorIndex;
                        int resolvedPosition = localVariable.resolvedPosition;
                        this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                        this.contents[localContentsOffset++] = (byte)resolvedPosition;
                    }
                }
                int value = numberOfEntries * 10 + 2;
                localVariableTableOffset += 2;
                this.contents[localVariableTableOffset++] = (byte)(value >> 24);
                this.contents[localVariableTableOffset++] = (byte)(value >> 16);
                this.contents[localVariableTableOffset++] = (byte)(value >> 8);
                this.contents[localVariableTableOffset++] = (byte)value;
                this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
                this.contents[localVariableTableOffset] = (byte)numberOfEntries;
                ++attributeNumber;
            }
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForClinit(int codeAttributeOffset, int[] startLineIndexes) {
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int code_length = this.codeStream.position;
        if (code_length > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (localContentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        this.contents[localContentsOffset++] = 0;
        this.contents[localContentsOffset++] = 0;
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            if (localContentsOffset + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 6;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 1;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(this.problemLine >> 8);
            this.contents[localContentsOffset++] = (byte)this.problemLine;
            ++attributeNumber;
        }
        if (this.codeStream.generateLocalVariableTableAttributes) {
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 2;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForProblemMethod(AbstractMethodDeclaration method, MethodBinding binding, int codeAttributeOffset, int[] startLineIndexes) {
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        int code_length = this.codeStream.position;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        if (localContentsOffset + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[localContentsOffset++] = 0;
        this.contents[localContentsOffset++] = 0;
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            if (localContentsOffset + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 6;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 1;
            if (this.problemLine == 0) {
                this.problemLine = ClassFile.searchLineNumber(startLineIndexes, binding.sourceStart());
            }
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(this.problemLine >> 8);
            this.contents[localContentsOffset++] = (byte)this.problemLine;
            ++attributeNumber;
        }
        if (this.codeStream.generateLocalVariableTableAttributes) {
            int argSize;
            int descriptorIndex;
            int localVariableTableOffset = localContentsOffset;
            int numberOfEntries = 0;
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (localContentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            localContentsOffset += 6;
            if (!this.codeStream.methodDeclaration.isStatic()) {
                ++numberOfEntries;
                if (localContentsOffset + 10 >= this.contents.length) {
                    this.resizeContents(10);
                }
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                this.contents[localContentsOffset++] = (byte)code_length;
                int nameIndex = this.constantPool.literalIndex(QualifiedNamesConstants.This);
                this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                this.contents[localContentsOffset++] = (byte)nameIndex;
                descriptorIndex = this.constantPool.literalIndex(this.codeStream.methodDeclaration.binding.declaringClass.signature());
                this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                this.contents[localContentsOffset++] = (byte)descriptorIndex;
                this.contents[localContentsOffset++] = 0;
                this.contents[localContentsOffset++] = 0;
            }
            if (binding.isConstructor()) {
                ReferenceBinding declaringClass = binding.declaringClass;
                if (declaringClass.isNestedType()) {
                    NestedTypeBinding methodDeclaringClass = (NestedTypeBinding)declaringClass;
                    argSize = methodDeclaringClass.enclosingInstancesSlotSize;
                    SyntheticArgumentBinding[] syntheticArguments = methodDeclaringClass.syntheticEnclosingInstances();
                    if (syntheticArguments != null) {
                        int max = syntheticArguments.length;
                        for (int i = 0; i < max; ++i) {
                            SyntheticArgumentBinding localVariable = syntheticArguments[i];
                            if (localContentsOffset + 10 >= this.contents.length) {
                                this.resizeContents(10);
                            }
                            ++numberOfEntries;
                            this.contents[localContentsOffset++] = 0;
                            this.contents[localContentsOffset++] = 0;
                            this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                            this.contents[localContentsOffset++] = (byte)code_length;
                            int nameIndex = this.constantPool.literalIndex(localVariable.name);
                            this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)nameIndex;
                            descriptorIndex = this.constantPool.literalIndex(localVariable.type.signature());
                            this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                            this.contents[localContentsOffset++] = (byte)descriptorIndex;
                            int resolvedPosition = localVariable.resolvedPosition;
                            this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                            this.contents[localContentsOffset++] = (byte)resolvedPosition;
                        }
                    }
                } else {
                    argSize = 1;
                }
            } else {
                int n = argSize = binding.isStatic() ? 0 : 1;
            }
            if (method.binding != null) {
                TypeBinding[] parameters = method.binding.parameters;
                Argument[] arguments = method.arguments;
                if (parameters != null && arguments != null) {
                    int max = parameters.length;
                    for (int i = 0; i < max; ++i) {
                        TypeBinding argumentBinding = parameters[i];
                        if (localContentsOffset + 10 >= this.contents.length) {
                            this.resizeContents(10);
                        }
                        ++numberOfEntries;
                        this.contents[localContentsOffset++] = 0;
                        this.contents[localContentsOffset++] = 0;
                        this.contents[localContentsOffset++] = (byte)(code_length >> 8);
                        this.contents[localContentsOffset++] = (byte)code_length;
                        int nameIndex = this.constantPool.literalIndex(arguments[i].name);
                        this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)nameIndex;
                        descriptorIndex = this.constantPool.literalIndex(argumentBinding.signature());
                        this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                        this.contents[localContentsOffset++] = (byte)descriptorIndex;
                        int resolvedPosition = argSize++;
                        if (argumentBinding == BaseTypes.LongBinding || argumentBinding == BaseTypes.DoubleBinding) {
                            argSize += 2;
                        }
                        this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                        this.contents[localContentsOffset++] = (byte)resolvedPosition;
                    }
                }
            }
            int value = numberOfEntries * 10 + 2;
            localVariableTableOffset += 2;
            this.contents[localVariableTableOffset++] = (byte)(value >> 24);
            this.contents[localVariableTableOffset++] = (byte)(value >> 16);
            this.contents[localVariableTableOffset++] = (byte)(value >> 8);
            this.contents[localVariableTableOffset++] = (byte)value;
            this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
            this.contents[localVariableTableOffset] = (byte)numberOfEntries;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeCodeAttributeForSyntheticAccessMethod(SyntheticAccessMethodBinding binding, int codeAttributeOffset, int[] startLineIndexes) {
        this.contents = this.codeStream.bCodeStream;
        int localContentsOffset = this.codeStream.classFileOffset;
        int max_stack = this.codeStream.stackMax;
        this.contents[codeAttributeOffset + 6] = (byte)(max_stack >> 8);
        this.contents[codeAttributeOffset + 7] = (byte)max_stack;
        int max_locals = this.codeStream.maxLocals;
        this.contents[codeAttributeOffset + 8] = (byte)(max_locals >> 8);
        this.contents[codeAttributeOffset + 9] = (byte)max_locals;
        int code_length = this.codeStream.position;
        this.contents[codeAttributeOffset + 10] = (byte)(code_length >> 24);
        this.contents[codeAttributeOffset + 11] = (byte)(code_length >> 16);
        this.contents[codeAttributeOffset + 12] = (byte)(code_length >> 8);
        this.contents[codeAttributeOffset + 13] = (byte)code_length;
        if (localContentsOffset + 40 >= this.contents.length) {
            this.resizeContents(40);
        }
        this.contents[localContentsOffset++] = 0;
        this.contents[localContentsOffset++] = 0;
        int codeAttributeAttributeOffset = localContentsOffset;
        int attributeNumber = 0;
        localContentsOffset += 2;
        if (this.codeStream.generateLineNumberAttributes) {
            int index = 0;
            int lineNumberNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[localContentsOffset++] = (byte)(lineNumberNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)lineNumberNameIndex;
            int lineNumberTableOffset = localContentsOffset;
            localContentsOffset += 6;
            index = ClassFile.searchLineNumber(startLineIndexes, binding.sourceStart);
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = 0;
            this.contents[localContentsOffset++] = (byte)(index >> 8);
            this.contents[localContentsOffset++] = (byte)index;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 6;
            this.contents[lineNumberTableOffset++] = 0;
            this.contents[lineNumberTableOffset++] = 1;
            ++attributeNumber;
        }
        if (this.codeStream.generateLocalVariableTableAttributes) {
            int localVariableTableOffset = localContentsOffset;
            int numberOfEntries = 0;
            int localVariableNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (localContentsOffset + 8 > this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[localContentsOffset++] = (byte)(localVariableNameIndex >> 8);
            this.contents[localContentsOffset++] = (byte)localVariableNameIndex;
            localContentsOffset += 6;
            for (int i = 0; i < this.codeStream.allLocalsCounter; ++i) {
                LocalVariableBinding localVariable = this.codeStream.locals[i];
                for (int j = 0; j < localVariable.initializationCount; ++j) {
                    int startPC = localVariable.initializationPCs[j << 1];
                    int endPC = localVariable.initializationPCs[(j << 1) + 1];
                    if (startPC == endPC) continue;
                    if (endPC == -1) {
                        localVariable.declaringScope.problemReporter().abortDueToInternalError(Util.bind("abort.invalidAttribute", new String(localVariable.name)), (ASTNode)((Object)localVariable.declaringScope.methodScope().referenceContext));
                    }
                    if (localContentsOffset + 10 > this.contents.length) {
                        this.resizeContents(10);
                    }
                    ++numberOfEntries;
                    this.contents[localContentsOffset++] = (byte)(startPC >> 8);
                    this.contents[localContentsOffset++] = (byte)startPC;
                    int length = endPC - startPC;
                    this.contents[localContentsOffset++] = (byte)(length >> 8);
                    this.contents[localContentsOffset++] = (byte)length;
                    int nameIndex = this.constantPool.literalIndex(localVariable.name);
                    this.contents[localContentsOffset++] = (byte)(nameIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)nameIndex;
                    int descriptorIndex = this.constantPool.literalIndex(localVariable.type.signature());
                    this.contents[localContentsOffset++] = (byte)(descriptorIndex >> 8);
                    this.contents[localContentsOffset++] = (byte)descriptorIndex;
                    int resolvedPosition = localVariable.resolvedPosition;
                    this.contents[localContentsOffset++] = (byte)(resolvedPosition >> 8);
                    this.contents[localContentsOffset++] = (byte)resolvedPosition;
                }
            }
            int value = numberOfEntries * 10 + 2;
            localVariableTableOffset += 2;
            this.contents[localVariableTableOffset++] = (byte)(value >> 24);
            this.contents[localVariableTableOffset++] = (byte)(value >> 16);
            this.contents[localVariableTableOffset++] = (byte)(value >> 8);
            this.contents[localVariableTableOffset++] = (byte)value;
            this.contents[localVariableTableOffset++] = (byte)(numberOfEntries >> 8);
            this.contents[localVariableTableOffset] = (byte)numberOfEntries;
            ++attributeNumber;
        }
        if (codeAttributeAttributeOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[codeAttributeAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[codeAttributeAttributeOffset] = (byte)attributeNumber;
        int codeAttributeLength = localContentsOffset - (codeAttributeOffset + 6);
        this.contents[codeAttributeOffset + 2] = (byte)(codeAttributeLength >> 24);
        this.contents[codeAttributeOffset + 3] = (byte)(codeAttributeLength >> 16);
        this.contents[codeAttributeOffset + 4] = (byte)(codeAttributeLength >> 8);
        this.contents[codeAttributeOffset + 5] = (byte)codeAttributeLength;
        this.contentsOffset = localContentsOffset;
    }

    public void completeMethodInfo(int methodAttributeOffset, int attributeNumber) {
        this.contents[methodAttributeOffset++] = (byte)(attributeNumber >> 8);
        this.contents[methodAttributeOffset] = (byte)attributeNumber;
    }

    public static void createProblemType(TypeDeclaration typeDeclaration, CompilationResult unitResult) {
        int i;
        int max;
        FieldBinding[] fields;
        SourceTypeBinding typeBinding = typeDeclaration.binding;
        ClassFile classFile = new ClassFile(typeBinding, null, true);
        if (typeBinding.isMemberType()) {
            classFile.recordEnclosingTypeAttributes(typeBinding);
        }
        if ((fields = typeBinding.fields) != null && fields != TypeConstants.NoFields) {
            int max2 = fields.length;
            for (int i2 = 0; i2 < max2; ++i2) {
                if (fields[i2].constant != null) continue;
                FieldReference.getConstantFor(fields[i2], null, false, null);
            }
            classFile.addFieldInfos();
        } else {
            classFile.contents[classFile.contentsOffset++] = 0;
            classFile.contents[classFile.contentsOffset++] = 0;
        }
        classFile.setForMethodInfos();
        MethodBinding[] methods = typeBinding.methods;
        AbstractMethodDeclaration[] methodDeclarations = typeDeclaration.methods;
        int maxMethodDecl = methodDeclarations == null ? 0 : methodDeclarations.length;
        IProblem[] problems = unitResult.getErrors();
        if (problems == null) {
            problems = new IProblem[]{};
        }
        int problemsLength = problems.length;
        IProblem[] problemsCopy = new IProblem[problemsLength];
        System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
        if (methods != null) {
            int j;
            MethodBinding methodBinding;
            if (typeBinding.isInterface()) {
                classFile.addProblemClinit(problemsCopy);
                max = methods.length;
                block1: for (i = 0; i < max; ++i) {
                    methodBinding = methods[i];
                    if (methodBinding == null) continue;
                    for (j = 0; j < maxMethodDecl; ++j) {
                        if (methodDeclarations[j] == null || methodDeclarations[j].binding != methods[i]) continue;
                        if (methodBinding.isConstructor()) continue block1;
                        classFile.addAbstractMethod(methodDeclarations[j], methodBinding);
                        continue block1;
                    }
                }
            } else {
                max = methods.length;
                block3: for (i = 0; i < max; ++i) {
                    methodBinding = methods[i];
                    if (methodBinding == null) continue;
                    for (j = 0; j < maxMethodDecl; ++j) {
                        if (methodDeclarations[j] == null || methodDeclarations[j].binding != methods[i]) continue;
                        AbstractMethodDeclaration methodDecl = methodDeclarations[j];
                        if (methodDecl.isConstructor()) {
                            classFile.addProblemConstructor(methodDecl, methodBinding, problemsCopy);
                            continue block3;
                        }
                        classFile.addProblemMethod(methodDecl, methodBinding, problemsCopy);
                        continue block3;
                    }
                }
            }
            classFile.addDefaultAbstractMethods();
        }
        if (typeDeclaration.memberTypes != null) {
            max = typeDeclaration.memberTypes.length;
            for (i = 0; i < max; ++i) {
                TypeDeclaration memberType = typeDeclaration.memberTypes[i];
                if (memberType.binding == null) continue;
                classFile.recordNestedMemberAttribute(memberType.binding);
                ClassFile.createProblemType(memberType, unitResult);
            }
        }
        classFile.addAttributes();
        unitResult.record(typeBinding.constantPoolName(), classFile);
    }

    public char[] fileName() {
        return this.constantPool.UTF8Cache.returnKeyFor(1);
    }

    public void generateCodeAttributeHeader() {
        if (this.contentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int constantValueNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.CodeName);
        this.contents[this.contentsOffset++] = (byte)(constantValueNameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)constantValueNameIndex;
        this.contentsOffset += 12;
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding) {
        this.contentsOffset += 2;
        int attributeNumber = 0;
        ReferenceBinding[] thrownsExceptions = methodBinding.thrownExceptions;
        if (methodBinding.thrownExceptions != TypeConstants.NoExceptions) {
            int length = thrownsExceptions.length;
            int exSize = 8 + length * 2;
            if (exSize + this.contentsOffset >= this.contents.length) {
                this.resizeContents(exSize);
            }
            int exceptionNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.ExceptionsName);
            this.contents[this.contentsOffset++] = (byte)(exceptionNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)exceptionNameIndex;
            int attributeLength = length * 2 + 2;
            this.contents[this.contentsOffset++] = (byte)(attributeLength >> 24);
            this.contents[this.contentsOffset++] = (byte)(attributeLength >> 16);
            this.contents[this.contentsOffset++] = (byte)(attributeLength >> 8);
            this.contents[this.contentsOffset++] = (byte)attributeLength;
            this.contents[this.contentsOffset++] = (byte)(length >> 8);
            this.contents[this.contentsOffset++] = (byte)length;
            for (int i = 0; i < length; ++i) {
                int exceptionIndex = this.constantPool.literalIndex(thrownsExceptions[i]);
                this.contents[this.contentsOffset++] = (byte)(exceptionIndex >> 8);
                this.contents[this.contentsOffset++] = (byte)exceptionIndex;
            }
            ++attributeNumber;
        }
        if (methodBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int deprecatedAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(deprecatedAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)deprecatedAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributeNumber;
        }
        if (this.targetJDK < 0x310000L && methodBinding.isSynthetic()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int syntheticAttributeNameIndex = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
            this.contents[this.contentsOffset++] = (byte)(syntheticAttributeNameIndex >> 8);
            this.contents[this.contentsOffset++] = (byte)syntheticAttributeNameIndex;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++attributeNumber;
        }
        return attributeNumber;
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers);
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding, int accessFlags) {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        if (this.targetJDK < 0x310000L) {
            accessFlags &= 0xFFFFEFFF;
        }
        if (methodBinding.isRequiredToClearPrivateModifier()) {
            accessFlags &= 0xFFFFFFFD;
        }
        this.contents[this.contentsOffset++] = (byte)(accessFlags >> 8);
        this.contents[this.contentsOffset++] = (byte)accessFlags;
        int nameIndex = this.constantPool.literalIndex(methodBinding.selector);
        this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)nameIndex;
        int descriptorIndex = this.constantPool.literalIndex(methodBinding.signature());
        this.contents[this.contentsOffset++] = (byte)(descriptorIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)descriptorIndex;
    }

    public void generateMethodInfoHeaderForClinit() {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 8;
        int nameIndex = this.constantPool.literalIndex(QualifiedNamesConstants.Clinit);
        this.contents[this.contentsOffset++] = (byte)(nameIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)nameIndex;
        int descriptorIndex = this.constantPool.literalIndex(QualifiedNamesConstants.ClinitSignature);
        this.contents[this.contentsOffset++] = (byte)(descriptorIndex >> 8);
        this.contents[this.contentsOffset++] = (byte)descriptorIndex;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 1;
    }

    public byte[] getBytes() {
        byte[] fullContents = new byte[this.headerOffset + this.contentsOffset];
        System.arraycopy(this.header, 0, fullContents, 0, this.headerOffset);
        System.arraycopy(this.contents, 0, fullContents, this.headerOffset, this.contentsOffset);
        return fullContents;
    }

    public char[][] getCompoundName() {
        return CharOperation.splitOn('/', this.fileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initByteArrays() {
        LookupEnvironment env;
        LookupEnvironment lookupEnvironment = env = this.referenceBinding.scope.environment();
        synchronized (lookupEnvironment) {
            if (env.sharedArraysUsed) {
                this.ownSharedArrays = false;
                int members = this.referenceBinding.methods().length + this.referenceBinding.fields().length;
                this.header = new byte[1500];
                this.contents = new byte[members < 15 ? 400 : 1500];
            } else {
                env.sharedArraysUsed = true;
                this.ownSharedArrays = true;
                this.header = env.sharedClassFileHeader;
                this.contents = env.sharedClassFileContents;
            }
        }
    }

    public ClassFile outerMostEnclosingClassFile() {
        ClassFile current = this;
        while (current.enclosingClassFile != null) {
            current = current.enclosingClassFile;
        }
        return current;
    }

    public void recordEnclosingTypeAttributes(ReferenceBinding binding) {
        ReferenceBinding enclosingType;
        int depth = 0;
        for (enclosingType = this.referenceBinding.enclosingType(); enclosingType != null; enclosingType = enclosingType.enclosingType()) {
            ++depth;
        }
        enclosingType = this.referenceBinding;
        if (depth >= 2) {
            int i;
            ReferenceBinding[] enclosingTypes = new ReferenceBinding[depth];
            for (i = depth - 1; i >= 0; --i) {
                enclosingTypes[i] = enclosingType;
                enclosingType = enclosingType.enclosingType();
            }
            for (i = 0; i < depth; ++i) {
                this.addInnerClasses(enclosingTypes[i]);
            }
        } else {
            this.addInnerClasses(this.referenceBinding);
        }
    }

    public void recordNestedLocalAttribute(ReferenceBinding binding) {
        ReferenceBinding enclosingType;
        int depth = 0;
        for (enclosingType = this.referenceBinding.enclosingType(); enclosingType != null; enclosingType = enclosingType.enclosingType()) {
            ++depth;
        }
        enclosingType = this.referenceBinding;
        if (depth >= 2) {
            int i;
            ReferenceBinding[] enclosingTypes = new ReferenceBinding[depth];
            for (i = depth - 1; i >= 0; --i) {
                enclosingTypes[i] = enclosingType;
                enclosingType = enclosingType.enclosingType();
            }
            for (i = 0; i < depth; ++i) {
                this.addInnerClasses(enclosingTypes[i]);
            }
        } else {
            this.addInnerClasses(binding);
        }
    }

    public void recordNestedMemberAttribute(ReferenceBinding binding) {
        this.addInnerClasses(binding);
    }

    private final void resizeContents(int minimalSize) {
        int length = this.contents.length;
        int toAdd = length;
        if (toAdd < minimalSize) {
            toAdd = minimalSize;
        }
        this.contents = new byte[length + toAdd];
        System.arraycopy(this.contents, 0, this.contents, 0, length);
    }

    public static final int searchLineNumber(int[] startLineIndexes, int position) {
        int length = startLineIndexes.length;
        if (length == 0) {
            return 1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            if (position < startLineIndexes[m]) {
                d = m - 1;
                continue;
            }
            if (position > startLineIndexes[m]) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < startLineIndexes[m]) {
            return m + 1;
        }
        return m + 2;
    }

    public void setForMethodInfos() {
        this.methodCountOffset = this.contentsOffset;
        this.contentsOffset += 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToDisk(boolean generatePackagesStructure, String outputPath, String relativeFileName, byte[] contents) throws IOException {
        BufferedOutputStream output = null;
        if (generatePackagesStructure) {
            output = new BufferedOutputStream(new FileOutputStream(new File(ClassFile.buildAllDirectoriesInto(outputPath, relativeFileName))));
        } else {
            String fileName = null;
            char fileSeparatorChar = File.separatorChar;
            String fileSeparator = File.separator;
            outputPath = outputPath.replace('/', fileSeparatorChar);
            int indexOfPackageSeparator = relativeFileName.lastIndexOf(fileSeparatorChar);
            if (indexOfPackageSeparator == -1) {
                fileName = outputPath.endsWith(fileSeparator) ? outputPath + relativeFileName : outputPath + fileSeparator + relativeFileName;
            } else {
                int length = relativeFileName.length();
                fileName = outputPath.endsWith(fileSeparator) ? outputPath + relativeFileName.substring(indexOfPackageSeparator + 1, length) : outputPath + fileSeparator + relativeFileName.substring(indexOfPackageSeparator + 1, length);
            }
            output = new BufferedOutputStream(new FileOutputStream(new File(fileName)));
        }
        try {
            output.write(contents);
        }
        finally {
            output.flush();
            output.close();
        }
    }
}

