/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class ConstructorDeclaration
extends AbstractMethodDeclaration {
    public ExplicitConstructorCall constructorCall;
    public static final char[] ConstantPoolName = "<init>".toCharArray();
    public boolean isDefaultConstructor = false;

    public ConstructorDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializerFlowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (this.binding != null && this.binding.isPrivate() && !this.binding.isPrivateUsed() && !classScope.referenceCompilationUnit().compilationResult.hasSyntaxError()) {
            this.scope.problemReporter().unusedPrivateConstructor(this);
        }
        if (this.isRecursive(null)) {
            this.scope.problemReporter().recursiveConstructorInvocation(this.constructorCall);
        }
        try {
            FieldBinding field;
            int i;
            int size;
            ArrayList computedExceptions;
            ExceptionHandlingFlowContext constructorContext = new ExceptionHandlingFlowContext(initializerFlowContext.parent, this, this.binding.thrownExceptions, this.scope, FlowInfo.DEAD_END);
            initializerFlowContext.checkInitializerExceptions(this.scope, constructorContext, flowInfo);
            if (this.binding.declaringClass.isAnonymousType() && (computedExceptions = constructorContext.extendedExceptions) != null && (size = computedExceptions.size()) > 0) {
                ReferenceBinding[] actuallyThrownExceptions = new ReferenceBinding[size];
                computedExceptions.toArray(actuallyThrownExceptions);
                this.binding.thrownExceptions = actuallyThrownExceptions;
            }
            if (this.constructorCall != null) {
                if (this.constructorCall.accessMode == 3) {
                    FieldBinding[] fields = this.binding.declaringClass.fields();
                    int count = fields.length;
                    for (i = 0; i < count; ++i) {
                        field = fields[i];
                        if (field.isStatic()) continue;
                        flowInfo.markAsDefinitelyAssigned(field);
                    }
                }
                flowInfo = this.constructorCall.analyseCode(this.scope, constructorContext, flowInfo);
            }
            if (this.statements != null) {
                boolean didAlreadyComplain = false;
                int count = this.statements.length;
                for (i = 0; i < count; ++i) {
                    Statement stat = this.statements[i];
                    if (!stat.complainIfUnreachable(flowInfo, this.scope, didAlreadyComplain)) {
                        flowInfo = stat.analyseCode(this.scope, constructorContext, flowInfo);
                        continue;
                    }
                    didAlreadyComplain = true;
                }
            }
            this.needFreeReturn = flowInfo.isReachable();
            if (this.constructorCall != null && this.constructorCall.accessMode != 3) {
                flowInfo = flowInfo.mergedWith(constructorContext.initsOnReturn);
                FieldBinding[] fields = this.binding.declaringClass.fields();
                int count = fields.length;
                for (i = 0; i < count; ++i) {
                    field = fields[i];
                    if (field.isStatic() || !field.isFinal() || flowInfo.isDefinitelyAssigned(fields[i])) continue;
                    this.scope.problemReporter().uninitializedBlankFinalField(field, this.isDefaultConstructor ? this.scope.referenceType() : this);
                }
            }
            constructorContext.complainIfUnusedExceptionHandlers(this);
        }
        catch (AbortMethod e) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int problemResetPC = 0;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            IProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int problemsLength = problems.length;
            IProblem[] problemsCopy = new IProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemConstructor(this, this.binding, problemsCopy);
            return;
        }
        try {
            problemResetPC = classFile.contentsOffset;
            this.internalGenerateCode(classScope, classFile);
        }
        catch (AbortMethod e) {
            if (e.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                try {
                    classFile.contentsOffset = problemResetPC;
                    --classFile.methodCount;
                    classFile.codeStream.wideMode = true;
                    this.internalGenerateCode(classScope, classFile);
                }
                catch (AbortMethod e2) {
                    IProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
                    int problemsLength = problems.length;
                    IProblem[] problemsCopy = new IProblem[problemsLength];
                    System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
                    classFile.addProblemConstructor(this, this.binding, problemsCopy, problemResetPC);
                }
            }
            IProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int problemsLength = problems.length;
            IProblem[] problemsCopy = new IProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemConstructor(this, this.binding, problemsCopy, problemResetPC);
        }
    }

    public void generateSyntheticFieldInitializationsIfNecessary(MethodScope methodScope, CodeStream codeStream, ReferenceBinding declaringClass) {
        SyntheticArgumentBinding syntheticArg;
        int i;
        int max;
        if (!declaringClass.isNestedType()) {
            return;
        }
        NestedTypeBinding nestedType = (NestedTypeBinding)declaringClass;
        SyntheticArgumentBinding[] syntheticArgs = nestedType.syntheticEnclosingInstances();
        int n = max = syntheticArgs == null ? 0 : syntheticArgs.length;
        for (i = 0; i < max; ++i) {
            syntheticArg = syntheticArgs[i];
            if (syntheticArg.matchingField == null) continue;
            codeStream.aload_0();
            codeStream.load(syntheticArg);
            codeStream.putfield(syntheticArg.matchingField);
        }
        syntheticArgs = nestedType.syntheticOuterLocalVariables();
        int n2 = max = syntheticArgs == null ? 0 : syntheticArgs.length;
        for (i = 0; i < max; ++i) {
            syntheticArg = syntheticArgs[i];
            if (syntheticArg.matchingField == null) continue;
            codeStream.aload_0();
            codeStream.load(syntheticArg);
            codeStream.putfield(syntheticArg.matchingField);
        }
    }

    private void internalGenerateCode(ClassScope classScope, ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int methodAttributeOffset = classFile.contentsOffset;
        int attributeNumber = classFile.generateMethodInfoAttribute(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int max;
            boolean preInitSyntheticFields;
            TypeDeclaration declaringType = classScope.referenceContext;
            int codeAttributeOffset = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            ReferenceBinding declaringClass = this.binding.declaringClass;
            int argSlotSize = 1;
            if (declaringClass.isNestedType()) {
                NestedTypeBinding nestedType = (NestedTypeBinding)declaringClass;
                this.scope.extraSyntheticArguments = nestedType.syntheticOuterLocalVariables();
                this.scope.computeLocalVariablePositions(nestedType.enclosingInstancesSlotSize + 1, codeStream);
                argSlotSize += nestedType.enclosingInstancesSlotSize;
                argSlotSize += nestedType.outerLocalVariablesSlotSize;
            } else {
                this.scope.computeLocalVariablePositions(1, codeStream);
            }
            if (this.arguments != null) {
                int max2 = this.arguments.length;
                for (int i = 0; i < max2; ++i) {
                    LocalVariableBinding argBinding = this.arguments[i].binding;
                    codeStream.addVisibleLocalVariable(argBinding);
                    argBinding.recordInitializationStartPC(0);
                    TypeBinding argType = argBinding.type;
                    if (argType == BaseTypes.LongBinding || argType == BaseTypes.DoubleBinding) {
                        argSlotSize += 2;
                        continue;
                    }
                    ++argSlotSize;
                }
            }
            MethodScope initializerScope = declaringType.initializerScope;
            initializerScope.computeLocalVariablePositions(argSlotSize, codeStream);
            boolean needFieldInitializations = this.constructorCall == null || this.constructorCall.accessMode != 3;
            boolean bl = preInitSyntheticFields = this.scope.environment().options.targetJDK >= 0x300000L;
            if (needFieldInitializations && preInitSyntheticFields) {
                this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, declaringClass);
            }
            if (this.constructorCall != null) {
                this.constructorCall.generateCode(this.scope, codeStream);
            }
            if (needFieldInitializations) {
                if (!preInitSyntheticFields) {
                    this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, declaringClass);
                }
                if (declaringType.fields != null) {
                    max = declaringType.fields.length;
                    for (int i = 0; i < max; ++i) {
                        FieldDeclaration fieldDecl = declaringType.fields[i];
                        if (fieldDecl.isStatic()) continue;
                        fieldDecl.generateCode(initializerScope, codeStream);
                    }
                }
            }
            if (this.statements != null) {
                max = this.statements.length;
                for (int i = 0; i < max; ++i) {
                    this.statements[i].generateCode(this.scope, codeStream);
                }
            }
            if (this.needFreeReturn) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.bodyEnd);
            classFile.completeCodeAttribute(codeAttributeOffset);
            ++attributeNumber;
        }
        classFile.completeMethodInfo(methodAttributeOffset, attributeNumber);
        if (this.ignoreFurtherInvestigation) {
            throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
        }
    }

    public boolean isConstructor() {
        return true;
    }

    public boolean isDefaultConstructor() {
        return this.isDefaultConstructor;
    }

    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isRecursive(ArrayList visited) {
        if (this.binding == null || this.constructorCall == null || this.constructorCall.binding == null || this.constructorCall.isSuperAccess() || !this.constructorCall.binding.isValidBinding()) {
            return false;
        }
        ConstructorDeclaration targetConstructor = (ConstructorDeclaration)this.scope.referenceType().declarationOf(this.constructorCall.binding);
        if (this == targetConstructor) {
            return true;
        }
        if (visited == null) {
            visited = new ArrayList<ConstructorDeclaration>(1);
        } else {
            int index = visited.indexOf(this);
            if (index >= 0) {
                return index == 0;
            }
        }
        visited.add(this);
        return targetConstructor.isRecursive(visited);
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (this.isDefaultConstructor) {
            this.constructorCall = SuperReference.implicitSuperConstructorCall();
            this.constructorCall.sourceStart = this.sourceStart;
            this.constructorCall.sourceEnd = this.sourceEnd;
            return;
        }
        parser.parse(this, unit);
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        output.append(" {");
        if (this.constructorCall != null) {
            output.append('\n');
            this.constructorCall.printStatement(indent, output);
        }
        if (this.statements != null) {
            for (int i = 0; i < this.statements.length; ++i) {
                output.append('\n');
                this.statements[i].printStatement(indent, output);
            }
        }
        output.append('\n');
        ConstructorDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output).append('}');
        return output;
    }

    public void resolveJavadoc() {
        if (this.binding == null || this.javadoc != null) {
            super.resolveJavadoc();
        } else if (!this.isDefaultConstructor) {
            this.scope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
        }
    }

    public void resolveStatements() {
        if (!CharOperation.equals(this.scope.enclosingSourceType().sourceName, this.selector)) {
            this.scope.problemReporter().missingReturnType(this);
        }
        if (this.constructorCall != null) {
            if (this.binding != null && this.binding.declaringClass.id == 1 && this.constructorCall.accessMode != 3) {
                if (this.constructorCall.accessMode == 2) {
                    this.scope.problemReporter().cannotUseSuperInJavaLangObject(this.constructorCall);
                }
                this.constructorCall = null;
            } else {
                this.constructorCall.resolve(this.scope);
            }
        }
        if ((this.modifiers & 0x1000000) != 0) {
            this.scope.problemReporter().methodNeedBody(this);
        }
        super.resolveStatements();
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            int i;
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                for (i = 0; i < argumentLength; ++i) {
                    this.arguments[i].traverse(visitor, this.scope);
                }
            }
            if (this.thrownExceptions != null) {
                int thrownExceptionsLength = this.thrownExceptions.length;
                for (i = 0; i < thrownExceptionsLength; ++i) {
                    this.thrownExceptions[i].traverse(visitor, this.scope);
                }
            }
            if (this.constructorCall != null) {
                this.constructorCall.traverse(visitor, this.scope);
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                for (i = 0; i < statementsLength; ++i) {
                    this.statements[i].traverse(visitor, this.scope);
                }
            }
        }
        visitor.endVisit(this, classScope);
    }
}

