/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.CommentRecorderParser;
import org.eclipse.jdt.internal.core.util.Util;

public class CompilationUnitProblemFinder
extends Compiler {
    protected CompilationUnitProblemFinder(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, settings, requestor, problemFactory, true);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 31, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit);
        }
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return DefaultErrorHandlingPolicies.proceedWithAllProblems();
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    public static CompilationUnitDeclaration process(CompilationUnitDeclaration unit, ICompilationUnit unitElement, char[] contents, Parser parser, WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProblemFactory problemFactory, boolean cleanupCU, IProgressMonitor monitor) throws JavaModelException {
        CompilationUnitDeclaration compilationUnitDeclaration;
        CompilationUnitProblemFinder problemFinder;
        block9: {
            char[] fileName = unitElement.getElementName().toCharArray();
            JavaProject project = (JavaProject)unitElement.getJavaProject();
            problemFinder = new CompilationUnitProblemFinder(project.newSearchableNameEnvironment(workingCopyOwner), CompilationUnitProblemFinder.getHandlingPolicy(), project.getOptions(true), CompilationUnitProblemFinder.getRequestor(), problemFactory);
            if (parser != null) {
                problemFinder.parser = parser;
            }
            try {
                IPackageFragment packageFragment = (IPackageFragment)unitElement.getAncestor(4);
                char[][] expectedPackageName = null;
                if (packageFragment != null) {
                    expectedPackageName = CharOperation.splitOn('.', packageFragment.getElementName().toCharArray());
                }
                if (unit == null) {
                    unit = problemFinder.resolve(new BasicCompilationUnit(contents, expectedPackageName, new String(fileName), unitElement), true, true, true);
                } else {
                    problemFinder.resolve(unit, null, true, true, true);
                }
                CompilationUnitProblemFinder.reportProblems(unit, problemRequestor, monitor);
                compilationUnitDeclaration = unit;
                Object var16_16 = null;
                if (!cleanupCU || unit == null) break block9;
            }
            catch (RuntimeException e) {
                try {
                    Util.log(e, "Exception occurred during problem detection: ");
                    throw new JavaModelException(e, 1005);
                }
                catch (Throwable throwable) {
                    Object var16_17 = null;
                    if (cleanupCU && unit != null) {
                        unit.cleanUp();
                    }
                    problemFinder.lookupEnvironment.reset();
                    throw throwable;
                }
            }
            unit.cleanUp();
        }
        problemFinder.lookupEnvironment.reset();
        return compilationUnitDeclaration;
    }

    public static CompilationUnitDeclaration process(ICompilationUnit unitElement, char[] contents, WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, boolean cleanupCU, IProgressMonitor monitor) throws JavaModelException {
        return CompilationUnitProblemFinder.process(null, unitElement, contents, null, workingCopyOwner, problemRequestor, new DefaultProblemFactory(), cleanupCU, monitor);
    }

    private static void reportProblems(CompilationUnitDeclaration unit, IProblemRequestor problemRequestor, IProgressMonitor monitor) {
        int problemLength;
        CompilationResult unitResult = unit.compilationResult;
        IProblem[] problems = unitResult.getAllProblems();
        int n = problemLength = problems == null ? 0 : problems.length;
        for (int i = 0; i < problemLength; ++i) {
            if (JavaModelManager.VERBOSE) {
                System.out.println("PROBLEM FOUND while reconciling : " + problems[i].getMessage());
            }
            if (monitor != null && monitor.isCanceled()) break;
            problemRequestor.acceptProblem(problems[i]);
        }
    }

    public void initializeParser() {
        this.parser = new CommentRecorderParser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
    }
}

