/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.ant.internal.ui.editor.AntAutoIndentStrategy;
import org.eclipse.ant.internal.ui.editor.AntEditorMessages;
import org.eclipse.ant.internal.ui.editor.AntEditorSourceViewerConfiguration;
import org.eclipse.ant.internal.ui.editor.model.AntElementNode;
import org.eclipse.ant.internal.ui.editor.model.AntProjectNode;
import org.eclipse.ant.internal.ui.editor.outline.AntEditorContentOutlinePage;
import org.eclipse.ant.internal.ui.editor.outline.AntModel;
import org.eclipse.ant.internal.ui.editor.outline.DocumentModelChangeEvent;
import org.eclipse.ant.internal.ui.editor.outline.IDocumentModelListener;
import org.eclipse.ant.internal.ui.editor.outline.XMLCore;
import org.eclipse.ant.internal.ui.editor.text.AnnotationAccess;
import org.eclipse.ant.internal.ui.editor.text.AntEditorDocumentProvider;
import org.eclipse.ant.internal.ui.editor.text.IReconcilingParticipant;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class AntEditor
extends TextEditor
implements IReconcilingParticipant {
    protected ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AntEditor.this.doSelectionChanged(event);
        }
    };
    private IDocumentModelListener fDocumentModelListener = new IDocumentModelListener(){

        public void documentModelChanged(DocumentModelChangeEvent event) {
            if (event.isPreferenceChange()) {
                AntEditor.this.updateEditorImage();
            }
        }
    };
    protected AntEditorContentOutlinePage fOutlinePage;
    private TabConverter fTabConverter;
    private boolean fInitialReconcile = true;
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;
    static /* synthetic */ Class class$org$eclipse$ui$texteditor$IEditorStatusLine;

    public AntEditor() {
        this.setSourceViewerConfiguration(new AntEditorSourceViewerConfiguration(this));
        this.setDocumentProvider((IDocumentProvider)new AntEditorDocumentProvider(XMLCore.getDefault()));
        XMLCore.getDefault().addDocumentModelListener(this.fDocumentModelListener);
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.ant.internal.ui.editor.AntEditorMessages");
        ContentAssistAction action = new ContentAssistAction(bundle, "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        action = new TextOperationAction(bundle, "ContentFormat.", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.format");
        this.setAction("ContentFormat", (IAction)action);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore(this.createCombinedPreferenceStore());
        this.setCompatibilityMode(false);
        this.setHelpContextId("org.eclipse.ant.ui.ant_editor_context");
    }

    public Object getAdapter(Class key) {
        if (key.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = AntEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(key);
    }

    private AntEditorContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new AntEditorContentOutlinePage(XMLCore.getDefault(), this);
            this.fOutlinePage.addPostSelectionChangedListener(this.fSelectionChangedListener);
            this.setOutlinePageInput(this.getEditorInput());
        }
        return this.fOutlinePage;
    }

    private void doSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        AntElementNode selectedXmlElement;
        IStructuredSelection selection = (IStructuredSelection)selectionChangedEvent.getSelection();
        if (!this.isActivePart() && AntUIPlugin.getActivePage() != null) {
            AntUIPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        if ((selectedXmlElement = (AntElementNode)selection.getFirstElement()) != null) {
            this.setSelection(selectedXmlElement, !this.isActivePart());
        }
    }

    private boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setSelection(AntElementNode reference, boolean moveCursor) {
        if (reference != null) {
            while (reference.getImportNode() != null) {
                reference = reference.getImportNode();
            }
            if (reference.isExternal()) {
                return;
            }
            StyledText textWidget = null;
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer != null) {
                textWidget = sourceViewer.getTextWidget();
            }
            if (textWidget == null) {
                return;
            }
            try {
                int offset = reference.getOffset();
                int length = reference.getSelectionLength();
                int highLightLength = reference.getLength();
                if (offset < 0) {
                    return;
                }
                textWidget.setRedraw(false);
                if (highLightLength > 0) {
                    this.setHighlightRange(offset, highLightLength, moveCursor);
                }
                if (!moveCursor) {
                    return;
                }
                if (offset <= -1 || length <= 0) return;
                sourceViewer.revealRange(offset, length);
                sourceViewer.setSelectedRange(offset, length);
                return;
            }
            catch (IllegalArgumentException x) {
                AntUIPlugin.log(x);
                return;
            }
            finally {
                if (textWidget != null) {
                    textWidget.setRedraw(true);
                }
            }
        } else {
            if (!moveCursor) return;
            this.resetHighlightRange();
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return ((AntEditorSourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("tabWidth".equals(property)) {
            Object value = event.getNewValue();
            StatusLineSourceViewer viewer = (StatusLineSourceViewer)this.getSourceViewer();
            if (value instanceof Integer) {
                viewer.getTextWidget().setTabs(((Integer)value).intValue());
            } else if (value instanceof String) {
                viewer.getTextWidget().setTabs(Integer.parseInt((String)value));
            }
            return;
        }
        if ("spaces_for_tabs".equals(property)) {
            if (this.isTabConversionEnabled()) {
                this.startTabConversion();
            } else {
                this.stopTabConversion();
            }
            return;
        }
        AntEditorSourceViewerConfiguration sourceViewerConfiguration = (AntEditorSourceViewerConfiguration)this.getSourceViewerConfiguration();
        if (this.affectsTextPresentation(event)) {
            sourceViewerConfiguration.adaptToPreferenceChange(event);
        }
        sourceViewerConfiguration.changeConfiguration(event);
        super.handlePreferenceStoreChanged(event);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.setOutlinePageInput(input);
    }

    private void setOutlinePageInput(IEditorInput input) {
        IDocumentProvider provider;
        if (this.fOutlinePage != null && (provider = this.getDocumentProvider()) instanceof AntEditorDocumentProvider) {
            AntEditorDocumentProvider documentProvider = (AntEditorDocumentProvider)provider;
            AntModel model = documentProvider.getAntModel(input);
            this.fOutlinePage.setPageInput(model);
        }
    }

    public AntModel getAntModel() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof AntEditorDocumentProvider) {
            AntEditorDocumentProvider documentProvider = (AntEditorDocumentProvider)provider;
            return documentProvider.getAntModel(this.getEditorInput());
        }
        return null;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new AnnotationAccess();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        StatusLineSourceViewer viewer = new StatusLineSourceViewer(parent, ruler, this.getOverviewRuler(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(class$org$eclipse$ui$texteditor$IEditorStatusLine == null ? (class$org$eclipse$ui$texteditor$IEditorStatusLine = AntEditor.class$("org.eclipse.ui.texteditor.IEditorStatusLine")) : class$org$eclipse$ui$texteditor$IEditorStatusLine);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    public void openReferenceElement() {
        ISelection selection = this.getSelectionProvider().getSelection();
        String errorMessage = null;
        if (selection instanceof ITextSelection) {
            IFile file;
            ITextSelection textSelection = (ITextSelection)selection;
            String text = textSelection.getText();
            AntElementNode node = this.getAntModel().getReferenceNode(text);
            if (node != null) {
                this.setSelection(node, true);
                return;
            }
            String path = this.getAntModel().getEntityPath(text);
            if (path != null && (file = AntUtil.getFileForLocation(path, null)).exists()) {
                try {
                    this.openInEditor(file, this.isActivePart());
                    return;
                }
                catch (PartInitException e) {
                    errorMessage = e.getLocalizedMessage();
                }
            }
        }
        if (errorMessage == null) {
            errorMessage = AntEditorMessages.getString("AntEditor.3");
        }
        this.setStatusLineErrorMessage(errorMessage);
        this.getSite().getShell().getDisplay().beep();
    }

    private void openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = this.getEditorSite().getPage()) != null) {
            IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
        }
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IAction formatAction = this.getAction("ContentFormat");
        if (formatAction == null) {
            return;
        }
        if (formatAction.isEnabled()) {
            menu.add(formatAction);
        }
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.fTabConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            this.fTabConverter.setNumberOfSpacesPerTab(this.getTabSize());
            StatusLineSourceViewer viewer = (StatusLineSourceViewer)this.getSourceViewer();
            viewer.setTextConverter(this.fTabConverter);
            viewer.updateIndentationPrefixes();
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            StatusLineSourceViewer viewer = (StatusLineSourceViewer)this.getSourceViewer();
            viewer.setTextConverter(null);
            viewer.updateIndentationPrefixes();
            this.fTabConverter = null;
        }
    }

    private int getTabSize() {
        IPreferenceStore preferences = this.getPreferenceStore();
        return preferences.getInt("tabWidth");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
        this.fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
    }

    private boolean isTabConversionEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean("spaces_for_tabs");
    }

    public void dispose() {
        super.dispose();
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        XMLCore.getDefault().removeDocumentModelListener(this.fDocumentModelListener);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.getAntModel().updateMarkers();
        this.updateEditorImage();
    }

    private void updateEditorImage() {
        Image titleImage = this.getTitleImage();
        if (titleImage == null) {
            return;
        }
        AntProjectNode node = this.getAntModel().getProjectNode();
        if (node != null) {
            this.postImageChange(node);
        }
    }

    private void updateForInitialReconcile() {
        if (this.getAntModel() == null) {
            return;
        }
        this.fInitialReconcile = false;
        this.updateEditorImage();
        this.getAntModel().updateForInitialReconcile();
    }

    private void postImageChange(final AntElementNode node) {
        Shell shell = this.getSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Image newImage;
                    if (AntEditor.this.getSite().getShell() == null || AntEditor.this.getSite().getShell().isDisposed()) {
                        return;
                    }
                    Image titleImage = AntEditor.this.getTitleImage();
                    if (titleImage != (newImage = node.getImage())) {
                        AntEditor.this.setTitleImage(newImage);
                    }
                }
            });
        }
    }

    public void synchronizeOutlinePage(boolean checkIfOutlinePageActive) {
        if (this.getSelectionProvider() == null) {
            return;
        }
        AntElementNode node = this.getNode();
        this.synchronizeOutlinePage(node, checkIfOutlinePageActive);
    }

    protected void synchronize(boolean checkIfOutlinePageActive) {
        if (this.getSelectionProvider() == null) {
            return;
        }
        AntElementNode node = this.getNode();
        if (AntUIPlugin.getDefault().getPreferenceStore().getBoolean("outline.linkWithEditor")) {
            this.synchronizeOutlinePage(node, checkIfOutlinePageActive);
        }
        this.setSelection(node, false);
    }

    private AntElementNode getNode() {
        AntModel model = this.getAntModel();
        if (model == null) {
            return null;
        }
        AntElementNode node = null;
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            int offset = textSelection.getOffset();
            node = model.getNode(offset, false);
        }
        return node;
    }

    protected void synchronizeOutlinePage(AntElementNode node, boolean checkIfOutlinePageActive) {
        if (!(this.fOutlinePage == null || checkIfOutlinePageActive && this.isAntOutlinePageAction())) {
            this.fOutlinePage.removePostSelectionChangedListener(this.fSelectionChangedListener);
            this.fOutlinePage.select(node);
            this.fOutlinePage.addPostSelectionChangedListener(this.fSelectionChangedListener);
        }
    }

    public void reconciled() {
        Shell shell;
        IAutoIndentStrategy strategy;
        if (this.getSourceViewerConfiguration() == null) {
            return;
        }
        if (this.fInitialReconcile) {
            this.updateForInitialReconcile();
        }
        if ((strategy = this.getSourceViewerConfiguration().getAutoIndentStrategy(null, null)) instanceof AntAutoIndentStrategy) {
            ((AntAutoIndentStrategy)strategy).reconciled();
        }
        if ((shell = this.getSite().getShell()) != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (AntEditor.this.getSite().getShell() == null || AntEditor.this.getSite().getShell().isDisposed()) {
                        return;
                    }
                    AntEditor.this.synchronize(true);
                }
            });
        }
    }

    private boolean isAntOutlinePageAction() {
        IWorkbenchPart part = this.getActivePart();
        return part instanceof ContentOutline && ((ContentOutline)part).getCurrentPage() == this.fOutlinePage;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return service.getActivePart();
    }

    protected void doSetSelection(ISelection selection) {
        super.doSetSelection(selection);
        this.synchronizeOutlinePage(true);
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        IPreferenceStore antStore = AntUIPlugin.getDefault().getPreferenceStore();
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        return new ChainedPreferenceStore(new IPreferenceStore[]{antStore, generalTextStore});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StatusLineSourceViewer
    extends SourceViewer {
        private boolean fIgnoreTextConverters = false;

        public StatusLineSourceViewer(Composite composite, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, int styles) {
            super(composite, verticalRuler, overviewRuler, AntEditor.this.isOverviewRulerVisible(), styles);
        }

        public void doOperation(int operation) {
            if (this.getTextWidget() == null || !this.redraws()) {
                return;
            }
            switch (operation) {
                case 13: {
                    String msg = this.fContentAssistant.showPossibleCompletions();
                    AntEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 1: {
                    this.fIgnoreTextConverters = true;
                    break;
                }
                case 2: {
                    this.fIgnoreTextConverters = true;
                }
            }
            super.doOperation(operation);
        }

        public void setTextConverter(TabConverter tabConverter) {
            AntEditor.this.fTabConverter = tabConverter;
        }

        public void updateIndentationPrefixes() {
            SourceViewerConfiguration configuration = AntEditor.this.getSourceViewerConfiguration();
            String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
            for (int i = 0; i < types.length; ++i) {
                String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this, types[i]);
                if (prefixes == null || prefixes.length <= 0) continue;
                this.setIndentPrefixes(prefixes, types[i]);
            }
        }

        protected void customizeDocumentCommand(DocumentCommand command) {
            super.customizeDocumentCommand(command);
            if (!this.fIgnoreTextConverters && AntEditor.this.fTabConverter != null) {
                AntEditor.this.fTabConverter.customizeDocumentCommand(this.getDocument(), command);
            }
            this.fIgnoreTextConverters = false;
        }
    }

    static class TabConverter {
        private int fTabRatio;
        private ILineTracker fLineTracker;

        TabConverter() {
        }

        public void setNumberOfSpacesPerTab(int ratio) {
            this.fTabRatio = ratio;
        }

        public void setLineTracker(ILineTracker lineTracker) {
            this.fLineTracker = lineTracker;
        }

        private int insertTabString(StringBuffer buffer, int offsetInLine) {
            if (this.fTabRatio == 0) {
                return 0;
            }
            int remainder = offsetInLine % this.fTabRatio;
            remainder = this.fTabRatio - remainder;
            for (int i = 0; i < remainder; ++i) {
                buffer.append(' ');
            }
            return remainder;
        }

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            String text = command.text;
            if (text == null) {
                return;
            }
            int index = text.indexOf(9);
            if (index > -1) {
                StringBuffer buffer = new StringBuffer();
                this.fLineTracker.set(command.text);
                int lines = this.fLineTracker.getNumberOfLines();
                try {
                    for (int i = 0; i < lines; ++i) {
                        int offset = this.fLineTracker.getLineOffset(i);
                        int endOffset = offset + this.fLineTracker.getLineLength(i);
                        String line = text.substring(offset, endOffset);
                        int position = 0;
                        if (i == 0) {
                            IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                            position = command.offset - firstLine.getOffset();
                        }
                        int length = line.length();
                        for (int j = 0; j < length; ++j) {
                            char c = line.charAt(j);
                            if (c == '\t') {
                                position += this.insertTabString(buffer, position);
                                continue;
                            }
                            buffer.append(c);
                            ++position;
                        }
                    }
                    command.text = buffer.toString();
                }
                catch (BadLocationException x) {
                    // empty catch block
                }
            }
        }
    }

    private class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AntModel model = AntEditor.this.getAntModel();
            if (model == null) {
                return;
            }
            ISelection selection = event.getSelection();
            AntElementNode node = null;
            if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                int offset = textSelection.getOffset();
                node = model.getNode(offset, false);
            }
            if (AntUIPlugin.getDefault().getPreferenceStore().getBoolean("outline.linkWithEditor")) {
                AntEditor.this.synchronizeOutlinePage(node, true);
            }
            AntEditor.this.setSelection(node, false);
        }
    }
}

