/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import java.util.Iterator;
import org.eclipse.ant.internal.ui.editor.text.IXMLAnnotation;
import org.eclipse.jface.text.source.IAnnotationModel;

public class XMLAnnotationIterator
implements Iterator {
    private Iterator fIterator;
    private IXMLAnnotation fNext;
    private boolean fSkipIrrelevants;

    public XMLAnnotationIterator(IAnnotationModel model, boolean skipIrrelevants) {
        this.fIterator = model.getAnnotationIterator();
        this.fSkipIrrelevants = skipIrrelevants;
        this.skip();
    }

    private void skip() {
        while (this.fIterator.hasNext()) {
            Object next = this.fIterator.next();
            if (!(next instanceof IXMLAnnotation)) continue;
            IXMLAnnotation a = (IXMLAnnotation)next;
            if (this.fSkipIrrelevants) {
                if (!a.isRelevant()) continue;
                this.fNext = a;
                return;
            }
            this.fNext = a;
            return;
        }
        this.fNext = null;
    }

    public boolean hasNext() {
        return this.fNext != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        try {
            IXMLAnnotation iXMLAnnotation = this.fNext;
            return iXMLAnnotation;
        }
        finally {
            this.skip();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

