/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.FeaturePlugin;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.InstallHandlerProxy;
import org.eclipse.update.internal.core.PatchedFeature;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfigurationPolicyModel;

public class ConfigurationPolicy
extends ConfigurationPolicyModel {
    public ConfigurationPolicy() {
    }

    public ConfigurationPolicy(ConfigurationPolicy configPolicy) {
        this.setPolicy(configPolicy.getPolicy());
        this.setConfiguredFeatureReferences(configPolicy.getConfiguredFeatures());
        this.setUnconfiguredFeatureReferences(configPolicy.getUnconfiguredFeatures());
        this.setConfiguredSiteModel(configPolicy.getConfiguredSiteModel());
    }

    private boolean isUnconfigured(IFeatureReference featureReference) {
        if (featureReference == null) {
            return false;
        }
        IFeatureReference[] refs = this.getUnconfiguredFeatures();
        for (int i = 0; i < refs.length; ++i) {
            if (!featureReference.equals(refs[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isConfigured(IFeatureReference featureReference) {
        if (featureReference == null) {
            return false;
        }
        IFeatureReference[] refs = this.getConfiguredFeatures();
        for (int i = 0; i < refs.length; ++i) {
            if (!featureReference.equals(refs[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void configure(IFeatureReference featureReference, boolean callInstallHandler, boolean createActivity) throws CoreException {
        block30: {
            IFeature feature;
            block27: {
                if (this.isConfigured(featureReference)) {
                    return;
                }
                if (featureReference == null) {
                    UpdateCore.warn("The feature reference to configure is null");
                    return;
                }
                feature = null;
                try {
                    feature = featureReference.getFeature(null);
                }
                catch (CoreException e) {
                    if (UpdateManagerUtils.isOptional(featureReference)) break block27;
                    URL url = featureReference.getURL();
                    String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
                    UpdateCore.warn("Error retrieving feature:" + urlString, e);
                    return;
                }
            }
            if (feature == null) {
                URL url = featureReference.getURL();
                String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
                UpdateCore.warn("The feature to unconfigure is null: feature reference is:" + urlString);
            }
            InstallHandlerProxy handler = null;
            if (callInstallHandler && feature.getInstallHandlerEntry() != null) {
                handler = new InstallHandlerProxy(2, feature, feature.getInstallHandlerEntry(), null);
            }
            boolean success = false;
            Throwable originalException = null;
            if (handler != null) {
                handler.configureInitiated();
            }
            ConfigurationActivity activity = null;
            if (createActivity) {
                activity = new ConfigurationActivity(6);
                activity.setLabel(feature.getVersionedIdentifier().toString());
                activity.setDate(new Date());
            }
            this.addConfiguredFeatureReference((FeatureReferenceModel)((Object)featureReference));
            if (activity != null) {
                InstallConfiguration installConfig = (InstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration();
                activity.setStatus(0);
                installConfig.addActivity(activity);
            }
            if (handler != null) {
                handler.completeConfigure();
            }
            success = true;
            Object var11_15 = null;
            Throwable newException = null;
            try {
                if (handler != null) {
                    handler.configureCompleted(success);
                }
            }
            catch (Throwable t2) {
                newException = t2;
            }
            if (originalException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
            }
            if (newException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
            }
            break block30;
            {
                catch (Throwable t) {
                    originalException = t;
                    Object var11_16 = null;
                    newException = null;
                    try {
                        if (handler != null) {
                            handler.configureCompleted(success);
                        }
                    }
                    catch (Throwable t2) {
                        newException = t2;
                    }
                    if (originalException != null) {
                        throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
                    }
                    if (newException != null) {
                        throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                newException = null;
                try {
                    if (handler != null) {
                        handler.configureCompleted(success);
                    }
                }
                catch (Throwable t2) {
                    newException = t2;
                }
                if (originalException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
                }
                if (newException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean unconfigure(IFeatureReference featureReference, boolean callInstallHandler, boolean createActivity) throws CoreException {
        boolean success;
        block32: {
            IFeature feature;
            block29: {
                if (this.isUnconfigured(featureReference)) {
                    UpdateCore.warn("Feature already unconfigured");
                    return true;
                }
                if (featureReference == null) {
                    UpdateCore.warn("The feature reference to unconfigure is null");
                    return false;
                }
                feature = null;
                try {
                    feature = featureReference.getFeature(null);
                }
                catch (CoreException e) {
                    if (UpdateManagerUtils.isOptional(featureReference)) break block29;
                    URL url = featureReference.getURL();
                    String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
                    UpdateCore.warn("Error retrieving feature:" + urlString, e);
                    return false;
                }
            }
            if (feature == null) {
                URL url = featureReference.getURL();
                String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
                UpdateCore.warn("The feature to unconfigure is null: feature reference is:" + urlString);
                return false;
            }
            InstallHandlerProxy handler = null;
            if (callInstallHandler && feature.getInstallHandlerEntry() != null) {
                handler = new InstallHandlerProxy(3, feature, feature.getInstallHandlerEntry(), null);
            }
            success = false;
            Throwable originalException = null;
            ConfigurationActivity activity = null;
            if (createActivity) {
                activity = new ConfigurationActivity(5);
                activity.setLabel(feature.getVersionedIdentifier().toString());
                activity.setDate(new Date());
            }
            InstallConfiguration installConfig = null;
            if (activity != null) {
                installConfig = (InstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration();
            }
            if (handler != null) {
                handler.unconfigureInitiated();
            }
            this.addUnconfiguredFeatureReference((FeatureReferenceModel)((Object)featureReference));
            if (handler != null) {
                handler.completeUnconfigure();
            }
            if (activity != null) {
                activity.setStatus(0);
                installConfig.addActivity(activity);
            }
            success = true;
            Object var11_16 = null;
            Throwable newException = null;
            try {
                if (handler != null) {
                    handler.unconfigureCompleted(success);
                }
            }
            catch (Throwable t2) {
                newException = t2;
            }
            if (originalException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
            }
            if (newException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
            }
            break block32;
            {
                catch (Throwable t) {
                    originalException = t;
                    Object var11_17 = null;
                    newException = null;
                    try {
                        if (handler != null) {
                            handler.unconfigureCompleted(success);
                        }
                    }
                    catch (Throwable t2) {
                        newException = t2;
                    }
                    if (originalException != null) {
                        throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
                    }
                    if (newException != null) {
                        throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                newException = null;
                try {
                    if (handler != null) {
                        handler.unconfigureCompleted(success);
                    }
                }
                catch (Throwable t2) {
                    newException = t2;
                }
                if (originalException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
                }
                if (newException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
                }
                throw throwable;
            }
        }
        if (!success) {
            URL url = featureReference.getURL();
            String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
            UpdateCore.warn("Unable to unconfigure:" + urlString);
        }
        return success;
    }

    public String[] getPluginPath(ISite site) throws CoreException {
        String[] pluginPaths;
        IFeatureReference[] unconfiguredFeatures = this.getUnconfiguredFeatures();
        IFeatureReference[] configuredFeatures = this.getConfiguredFeatures();
        if (!this.isEnabled()) {
            pluginPaths = this.getPolicy() == 0 ? new String[]{} : this.getAllKnownPluginStrings(site, configuredFeatures, unconfiguredFeatures);
        } else {
            PatchedFeature[] patchedFeatures = this.buildPatchedFeatures(configuredFeatures);
            pluginPaths = this.getPolicy() == 0 ? this.getConfiguredPluginStrings(site, patchedFeatures) : this.subtract(this.getAllKnownPluginStrings(site, configuredFeatures, unconfiguredFeatures), this.getConfiguredPluginStrings(site, patchedFeatures));
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("GetPluginPath for: " + (site == null ? "<No site>" : site.getURL().toString()));
            for (int i = 0; i < pluginPaths.length; ++i) {
                UpdateCore.debug("To write:" + pluginPaths[i]);
            }
        }
        return pluginPaths;
    }

    private PatchedFeature[] buildPatchedFeatures(IFeatureReference[] features) {
        int f;
        HashMap<VersionedIdentifier, PatchedFeature> map = new HashMap<VersionedIdentifier, PatchedFeature>();
        for (f = 0; f < features.length; ++f) {
            IFeatureReference featureRef = features[f];
            try {
                if (featureRef.isPatch()) continue;
                VersionedIdentifier vi = featureRef.getVersionedIdentifier();
                map.put(vi, new PatchedFeature(features[f]));
                continue;
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
        }
        for (f = 0; f < features.length; ++f) {
            IFeatureReference patchCandidate = features[f];
            try {
                IFeature feature = patchCandidate.getFeature(null);
                IImport[] imports = feature.getImports();
                for (int i = 0; i < imports.length; ++i) {
                    VersionedIdentifier patchedIdentifier;
                    PatchedFeature pf;
                    IImport oneImport = imports[i];
                    if (!oneImport.isPatch() || (pf = (PatchedFeature)map.get(patchedIdentifier = oneImport.getVersionedIdentifier())) == null) continue;
                    pf.addPatch(patchCandidate);
                }
                continue;
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
        }
        Collection patchedFeatures = map.values();
        return patchedFeatures.toArray(new PatchedFeature[patchedFeatures.size()]);
    }

    public IFeatureReference[] getConfiguredFeatures() {
        FeatureReferenceModel[] result = this.getConfiguredFeaturesModel();
        if (result.length == 0) {
            return new IFeatureReference[0];
        }
        return (IFeatureReference[])result;
    }

    public IFeatureReference[] getUnconfiguredFeatures() {
        FeatureReferenceModel[] result = this.getUnconfiguredFeaturesModel();
        if (result.length == 0) {
            return new IFeatureReference[0];
        }
        return (IFeatureReference[])result;
    }

    public IConfiguredSite getConfiguredSite() {
        return (IConfiguredSite)((Object)this.getConfiguredSiteModel());
    }

    public void removeFeatureReference(IFeatureReference featureRef) {
        if (featureRef instanceof FeatureReferenceModel) {
            this.removeFeatureReference((FeatureReferenceModel)((Object)featureRef));
        }
    }

    private String[] getConfiguredPluginStrings(ISite site, PatchedFeature[] features) throws CoreException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
            UpdateCore.warn("CONFIGURED PLUGINS");
        }
        HashSet<FeaturePlugin> featurePlugins = new HashSet<FeaturePlugin>();
        for (int i = 0; i < features.length; ++i) {
            FeaturePlugin[] plugins = features[i].getPlugins();
            featurePlugins.addAll(Arrays.asList(plugins));
        }
        Set pluginStrings = this.getPluginStrings(site, featurePlugins.toArray(new FeaturePlugin[featurePlugins.size()]));
        return pluginStrings.toArray(new String[pluginStrings.size()]);
    }

    private String[] getAllKnownPluginStrings(ISite site, IFeatureReference[] configured, IFeatureReference[] unconfigured) throws CoreException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
            UpdateCore.warn("ALL PLUGINS");
        }
        IFeatureReference[] all = new IFeatureReference[configured.length + unconfigured.length];
        System.arraycopy(configured, 0, all, 0, configured.length);
        System.arraycopy(unconfigured, 0, all, configured.length, unconfigured.length);
        HashSet<FeaturePlugin> patchedPlugins = new HashSet<FeaturePlugin>();
        for (int i = 0; i < all.length; ++i) {
            try {
                IFeature feature = all[i].getFeature(null);
                if (feature == null) {
                    UpdateCore.warn("Null Feature", new Exception());
                    continue;
                }
                IPluginEntry[] entries = feature.getPluginEntries();
                for (int entr = 0; entr < entries.length; ++entr) {
                    patchedPlugins.add(new FeaturePlugin(entries[entr], feature));
                }
                continue;
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
        }
        Set pluginStrings = this.getPluginStrings(site, patchedPlugins.toArray(new FeaturePlugin[patchedPlugins.size()]));
        return pluginStrings.toArray(new String[pluginStrings.size()]);
    }

    private Set getPluginStrings(ISite site, FeaturePlugin[] plugins) throws CoreException {
        HashSet<String> pluginStrings = new HashSet<String>();
        for (int i = 0; i < plugins.length; ++i) {
            IPluginEntry entry = plugins[i].getEntry();
            IFeature feature = plugins[i].getFeature();
            ContentReference[] featureContentReference = null;
            try {
                featureContentReference = feature.getFeatureContentProvider().getPluginEntryArchiveReferences(entry, null);
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
            if (featureContentReference == null) continue;
            for (int j = 0; j < featureContentReference.length; ++j) {
                URL url = site.getSiteContentProvider().getArchiveReference(featureContentReference[j].getIdentifier());
                if (url == null) continue;
                String path = UpdateManagerUtils.getURLAsString(site.getURL(), url);
                path = path + (path.endsWith(File.separator) || path.endsWith("/") ? "" : "/");
                pluginStrings.add(path);
                if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_CONFIGURATION) continue;
                UpdateCore.warn("Add plugin: " + path + " to the list");
            }
        }
        return pluginStrings;
    }

    private String[] subtract(String[] allStrings, String[] stringsToRemove) {
        HashSet<String> resultList = new HashSet<String>(Arrays.asList(allStrings));
        resultList.removeAll(Arrays.asList(stringsToRemove));
        return resultList.toArray(new String[resultList.size()]);
    }
}

