/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.mirror;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.FeaturePackagedContentProvider;
import org.eclipse.update.internal.core.SiteFileContentProvider;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.mirror.MirrorSite;
import org.eclipse.update.internal.model.BundleManifest;
import org.eclipse.update.internal.model.DefaultPluginParser;
import org.eclipse.update.standalone.StandaloneUpdateApplication;
import org.xml.sax.SAXException;

public class MirrorSiteFactory
extends BaseSiteFactory {
    public SiteModel createSiteMapModel() {
        return new MirrorSite(this);
    }

    public ISite createSite(URL url) throws CoreException, InvalidSiteTypeException {
        return this.createSite(new File(url.getFile()));
    }

    public ISite createSite(File siteLocation) throws CoreException, InvalidSiteTypeException {
        URL url;
        FileInputStream siteStream = null;
        if (!siteLocation.exists() && !siteLocation.mkdirs()) {
            throw Utilities.newCoreException("Directory " + siteLocation.getAbsolutePath() + " could not be created.", null);
        }
        if (!siteLocation.isDirectory() || !siteLocation.canWrite()) {
            throw Utilities.newCoreException(siteLocation.getAbsolutePath() + " is not a directory or is not writtable.", null);
        }
        MirrorSite site = null;
        if (new File(siteLocation, "site.xml").exists()) {
            try {
                siteStream = new FileInputStream(new File(siteLocation, "site.xml"));
            }
            catch (FileNotFoundException fnfe) {
                // empty catch block
            }
            site = (MirrorSite)this.parseSite(siteStream);
            try {
                if (siteStream != null) {
                    ((InputStream)siteStream).close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (site == null) {
            site = (MirrorSite)this.createSiteMapModel();
        }
        this.parseDownloadedPluginsAndFragments(site, new File(siteLocation, "plugins/"));
        this.parseDownloadedFeatures(site, new File(siteLocation, "features/"));
        try {
            url = siteLocation.toURL();
        }
        catch (MalformedURLException mue) {
            throw Utilities.newCoreException("A URL for site " + siteLocation.getAbsolutePath() + " could not be created.", mue);
        }
        SiteFileContentProvider contentProvider = null;
        contentProvider = new SiteFileContentProvider(url);
        site.setSiteContentProvider(contentProvider);
        contentProvider.setSite(site);
        try {
            site.resolve(url, url);
        }
        catch (MalformedURLException mue) {
            throw Utilities.newCoreException("Unable to resolve URL " + (url == null ? "" : url.toExternalForm()), mue);
        }
        return site;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseDownloadedPluginsAndFragments(MirrorSite site, File pluginDir) throws CoreException {
        if (!pluginDir.exists()) {
            return;
        }
        dir = pluginDir.list(FeaturePackagedContentProvider.filter);
        i = 0;
        while (i < dir.length) {
            block18: {
                block20: {
                    block19: {
                        in = null;
                        try {
                            try {
                                file = new File(pluginDir, dir[i]);
                                jarReference = new JarContentReference(null, file);
                                ref = jarReference.peek("META-INF/MANIFEST.MF", null, null);
                                if (ref != null && (manifest = new BundleManifest(in = ref.getInputStream())).exists()) {
                                    site.addDownloadedPluginEntry(manifest.getPluginEntry());
                                    var11_12 = null;
                                    if (in == null) break block18;
                                    break block19;
                                }
                                ref = jarReference.peek("plugin.xml", null, null);
                                if (ref == null) {
                                    ref = jarReference.peek("fragment.xml", null, null);
                                }
                                if (ref == null) break block20;
                                in = ref.getInputStream();
                                entry = new DefaultPluginParser().parse(in);
                                site.addDownloadedPluginEntry(entry);
                                break block20;
                            }
                            catch (IOException e) {
                                StandaloneUpdateApplication.exceptionLogged();
                                UpdateCore.log(e);
                                var11_12 = null;
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException ce) {}
                                }
                                break block18;
                            }
                            catch (SAXException e) {
                                StandaloneUpdateApplication.exceptionLogged();
                                UpdateCore.log(e);
                                var11_12 = null;
                                if (in != null) {
                                    try {}
                                    catch (IOException ce) {}
                                    in.close();
                                }
                                break block18;
                            }
                        }
                        catch (Throwable var10_14) {
                            var11_12 = null;
                            if (in == null) throw var10_14;
                            ** try [egrp 2[TRYBLOCK] [9 : 224->232)] { 
lbl53:
                            // 1 sources

                            in.close();
                            throw var10_14;
lbl55:
                            // 1 sources

                            catch (IOException ce) {
                                // empty catch block
                            }
                            throw var10_14;
                        }
                    }
                    try {}
                    catch (IOException ce) {}
                    in.close();
                    break block18;
                }
                var11_12 = null;
                if (in != null) {
                    try {}
                    catch (IOException ce) {}
                    in.close();
                }
            }
            ++i;
        }
    }

    private void parseDownloadedFeatures(MirrorSite site, File featureDir) throws CoreException {
        if (featureDir.exists()) {
            String newFilePath = null;
            try {
                String[] dir = featureDir.list(FeaturePackagedContentProvider.filter);
                for (int index = 0; index < dir.length; ++index) {
                    File currentFeatureFile = new File(featureDir, dir[index]);
                    JarContentReference ref = new JarContentReference("", currentFeatureFile);
                    ContentReference result = null;
                    try {
                        result = ref.peek("feature.xml", null, null);
                    }
                    catch (IOException e) {
                        UpdateCore.warn("Exception retrieving feature.xml in file:" + currentFeatureFile, e);
                    }
                    if (result == null) {
                        UpdateCore.warn("Unable to find feature.xml in file:" + currentFeatureFile);
                        continue;
                    }
                    URL featureURL = currentFeatureFile.toURL();
                    SiteFeatureReferenceModel featureRef = this.createFeatureReferenceModel();
                    featureRef.setSiteModel(site);
                    featureRef.setURLString(featureURL.toExternalForm());
                    featureRef.setType("org.eclipse.update.core.packaged");
                    featureRef.setFeatureIdentifier(featureRef.getVersionedIdentifier().getIdentifier());
                    featureRef.setFeatureVersion(featureRef.getVersionedIdentifier().getVersion().toString());
                    site.addDownloadedFeatureReferenceModel(featureRef);
                }
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException("Unable to create URL for file " + newFilePath + ".", e);
            }
        }
    }
}

