/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.registry;

import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class RegistryReader {
    protected static final String TAG_DESCRIPTION = "description";
    protected static Hashtable extensionPoints = new Hashtable();

    protected RegistryReader() {
    }

    protected String getDescription(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        IPluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + descriptor.getUniqueIdentifier() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        WorkbenchPlugin.log((String)buf.toString());
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    protected void logMissingElement(IConfigurationElement element, String elementName) {
        this.logError(element, "Required sub element '" + elementName + "' not defined");
    }

    protected void logUnknownElement(IConfigurationElement element) {
        this.logError(element, "Unknown extension tag found: " + element.getName());
    }

    protected IExtension[] orderExtensions(IExtension[] extensions) {
        Utils.Sorter sorter = new Utils.Sorter(){

            public boolean compare(Object extension1, Object extension2) {
                String s1 = ((IExtension)extension1).getDeclaringPluginDescriptor().getUniqueIdentifier();
                String s2 = ((IExtension)extension2).getDeclaringPluginDescriptor().getUniqueIdentifier();
                return s2.compareToIgnoreCase(s1) > 0;
            }
        };
        Object[] sorted = sorter.sort(extensions);
        IExtension[] sortedExtension = new IExtension[sorted.length];
        System.arraycopy(sorted, 0, sortedExtension, 0, sorted.length);
        return sortedExtension;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (this.readElement(elements[i])) continue;
            this.logUnknownElement(elements[i]);
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    public void readRegistry(IPluginRegistry registry, String pluginId, String extensionPoint) {
        String pointId = pluginId + "-" + extensionPoint;
        IExtension[] extensions = (IExtension[])extensionPoints.get(pointId);
        if (extensions == null) {
            IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
            if (point == null) {
                return;
            }
            extensions = point.getExtensions();
            extensionPoints.put(pointId, extensions);
        }
        for (int i = 0; i < extensions.length; ++i) {
            this.readExtension(extensions[i]);
        }
    }
}

