/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.core.internal.indexing.AbstractObjectPolicy;
import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectPage;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.ObjectStorePagePolicy;
import org.eclipse.core.internal.indexing.PageStore;
import org.eclipse.core.internal.indexing.PageStoreException;
import org.eclipse.core.internal.indexing.Reservation;
import org.eclipse.core.internal.indexing.ReservationTable;
import org.eclipse.core.internal.indexing.SpaceMapPage;
import org.eclipse.core.internal.indexing.StoredObject;

public class ObjectStore
implements Observer {
    public static final int MAXIMUM_OBJECT_SIZE = 7612;
    protected static final int CurrentObjectStoreVersion = 1;
    protected static final int ObjectStoreMetadataAreaID = 1;
    protected PageStore pageStore;
    protected String name;
    protected Map acquiredObjects;
    protected Map modifiedObjects;
    protected LinkedList cachedObjects;
    protected Set phantoms;
    protected ReservationTable reservations;
    protected ObjectStorePagePolicy pagePolicy = new ObjectStorePagePolicy();
    protected AbstractObjectPolicy objectPolicy;

    public static void create(String path) throws ObjectStoreException {
        try {
            PageStore.create(path);
        }
        catch (PageStoreException e) {
            throw new ObjectStoreException(10, (Throwable)e);
        }
    }

    public static void delete(String path) {
        PageStore.delete(path);
    }

    public static boolean exists(String path) {
        return PageStore.exists(path);
    }

    public ObjectStore(AbstractObjectPolicy objectPolicy) {
        this.objectPolicy = objectPolicy;
    }

    public void open(String name) throws ObjectStoreException {
        try {
            this.pageStore = new PageStore(this.pagePolicy);
            this.pageStore.open(name);
        }
        catch (PageStoreException e) {
            throw new ObjectStoreException(12, (Throwable)e);
        }
        this.checkMetadata();
        this.acquiredObjects = new HashMap();
        this.modifiedObjects = new HashMap();
        this.cachedObjects = new LinkedList();
        this.phantoms = new HashSet();
        this.reservations = new ReservationTable();
    }

    public void close() throws ObjectStoreException {
        try {
            this.commit();
        }
        catch (ObjectStoreException e) {
            this.pageStore.close(false);
            throw e;
        }
        try {
            this.pageStore.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.acquiredObjects = null;
        this.modifiedObjects = null;
        this.cachedObjects = null;
        this.phantoms = null;
        this.reservations = null;
    }

    public Buffer getMetadataArea(int i) throws ObjectStoreException {
        try {
            return new Buffer(this.pageStore.readMetadataArea(i));
        }
        catch (PageStoreException e) {
            throw new ObjectStoreException(40, (Throwable)e);
        }
    }

    public void putMetadataArea(int i, Buffer buffer) throws ObjectStoreException {
        try {
            this.pageStore.writeMetadataArea(i, buffer.getByteArray());
        }
        catch (PageStoreException e) {
            throw new ObjectStoreException(40, (Throwable)e);
        }
    }

    protected void checkMetadata() throws ObjectStoreException {
        Buffer metadata = this.getMetadataArea(1);
        Field versionField = metadata.getField(0, 4);
        int objectStoreVersion = versionField.getInt();
        if (objectStoreVersion == 0) {
            versionField.put(1);
            this.putMetadataArea(1, metadata);
            return;
        }
        if (objectStoreVersion == 1) {
            return;
        }
        this.convert(objectStoreVersion);
    }

    protected void convert(int fromVersion) throws ObjectStoreException {
        throw new ObjectStoreException(11);
    }

    public void commit() throws ObjectStoreException {
        StoredObject object;
        Iterator<Object> z = this.acquiredObjects.values().iterator();
        while (z.hasNext()) {
            object = (StoredObject)z.next();
            object.notifyObservers();
        }
        z = this.phantoms.iterator();
        while (z.hasNext()) {
            ObjectAddress address = (ObjectAddress)z.next();
            int pageNumber = address.getPageNumber();
            ObjectPage page = this.acquireObjectPage(pageNumber);
            page.removeObject(address.getObjectNumber());
            this.updateSpaceMapPage(page.getPageNumber(), page.getFreeSpace());
            page.release();
        }
        this.phantoms.clear();
        z = this.modifiedObjects.values().iterator();
        while (z.hasNext()) {
            object = (StoredObject)z.next();
            z.remove();
            this.addToCache(object);
            ObjectAddress address = object.getAddress();
            int pageNumber = address.getPageNumber();
            ObjectPage page = this.acquireObjectPage(pageNumber);
            if (this.reservations.contains(address)) {
                page.insertObject(object);
                this.updateSpaceMapPage(pageNumber, page.getFreeSpace());
            } else {
                page.updateObject(object);
            }
            page.release();
        }
        this.reservations.clear();
        try {
            this.pageStore.commit();
        }
        catch (PageStoreException e) {
            throw new ObjectStoreException(21, (Throwable)e);
        }
    }

    public void rollback() throws ObjectStoreException {
        this.modifiedObjects.clear();
        this.reservations.clear();
        this.phantoms.clear();
    }

    public String getName() {
        return this.pageStore.getName();
    }

    public AbstractObjectPolicy getPolicy() {
        return this.objectPolicy;
    }

    public StoredObject acquireObject(ObjectAddress address) throws ObjectStoreException {
        if (this.phantoms.contains(address)) {
            throw new ObjectStoreException(25);
        }
        StoredObject object = (StoredObject)this.acquiredObjects.get(address);
        if (object == null) {
            object = (StoredObject)this.modifiedObjects.get(address);
            if (object == null && (object = this.removeFromCache(address)) == null) {
                int pageNumber = address.getPageNumber();
                ObjectPage page = this.acquireObjectPage(pageNumber);
                try {
                    Field f = page.getObjectField(address.getObjectNumber());
                    if (f == null) {
                        throw new ObjectStoreException(25);
                    }
                    object = this.objectPolicy.createObject(f, this, address);
                }
                catch (ObjectStoreException e) {
                    page.release();
                    throw e;
                }
                page.release();
            }
            this.acquiredObjects.put(address, object);
            object.addObserver(this);
        }
        object.addReference();
        return object;
    }

    public void releaseObject(StoredObject object) throws ObjectStoreException {
        object.removeReference();
        if (object.hasReferences()) {
            return;
        }
        object.notifyObservers();
        object.deleteObserver(this);
        this.acquiredObjects.remove(object.getAddress());
        this.addToCache(object);
    }

    public void update(Observable object, Object arg) {
        StoredObject storedObject = (StoredObject)object;
        this.modifiedObjects.put(storedObject.getAddress(), storedObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToCache(StoredObject object) {
        LinkedList linkedList = this.cachedObjects;
        synchronized (linkedList) {
            if (this.acquiredObjects.containsKey(object.getAddress())) {
                return;
            }
            if (this.modifiedObjects.containsKey(object.getAddress())) {
                return;
            }
            this.cachedObjects.addFirst(object);
            if (this.cachedObjects.size() <= 50) {
                return;
            }
            this.cachedObjects.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoredObject removeFromCache(ObjectAddress address) {
        LinkedList linkedList = this.cachedObjects;
        synchronized (linkedList) {
            StoredObject object = null;
            Iterator z = this.cachedObjects.iterator();
            while (z.hasNext()) {
                StoredObject o = (StoredObject)z.next();
                if (!o.getAddress().equals(address)) continue;
                z.remove();
                object = o;
                break;
            }
            return object;
        }
    }

    public ObjectAddress insertObject(StoredObject object) throws ObjectStoreException {
        int bytesNeeded = object.length() + 4;
        ObjectPage page = this.acquireObjectPageForSize(bytesNeeded);
        int pageNumber = page.getPageNumber();
        int objectNumber = page.reserveObject(object, this.reservations);
        page.release();
        ObjectAddress address = new ObjectAddress(pageNumber, objectNumber);
        object.setAddress(address);
        object.setStore(this);
        this.modifiedObjects.put(address, object);
        return address;
    }

    public void removeObject(ObjectAddress address) throws ObjectStoreException {
        boolean inStore;
        if (this.phantoms.contains(address)) {
            throw new ObjectStoreException(25);
        }
        if (this.acquiredObjects.containsKey(address)) {
            throw new ObjectStoreException(30);
        }
        StoredObject object = (StoredObject)this.modifiedObjects.get(address);
        boolean bl = inStore = !this.reservations.contains(address);
        if (object != null) {
            this.reservations.remove(address);
            this.modifiedObjects.remove(address);
        }
        this.removeFromCache(address);
        if (inStore) {
            this.phantoms.add(address);
        }
    }

    protected void updateSpaceMapPage(int objectPageNumber, int freeSpace) throws ObjectStoreException {
        SpaceMapPage p = this.acquireSpaceMapPage(objectPageNumber);
        p.setFreeSpace(objectPageNumber, freeSpace);
        p.release();
    }

    protected ObjectPage acquireObjectPage(int pageNumber) throws ObjectStoreException {
        ObjectPage page;
        try {
            page = (ObjectPage)this.pageStore.acquire(pageNumber);
        }
        catch (PageStoreException e) {
            throw new ObjectStoreException(20, (Throwable)e);
        }
        return page;
    }

    protected ObjectPage acquireObjectPageForSize(int bytesNeeded) throws ObjectStoreException {
        int oPageNumber = 0;
        int numberOfSpans = (this.pageStore.numberOfPages() - 1) / 8192 + 1;
        for (int i = 0; i <= numberOfSpans; ++i) {
            try {
                int sPageNumber = i * 8192;
                SpaceMapPage sPage = (SpaceMapPage)this.pageStore.acquire(sPageNumber);
                for (int j = 1; j < 8192; ++j) {
                    int bytesAvailable;
                    int n = sPageNumber + j;
                    Reservation r = this.reservations.get(n);
                    int n2 = bytesAvailable = r == null ? sPage.getFreeSpace(n) : r.getFreeSpace();
                    if (bytesNeeded > bytesAvailable) continue;
                    oPageNumber = n;
                    break;
                }
                sPage.release();
            }
            catch (PageStoreException e) {
                throw new ObjectStoreException(20, (Throwable)e);
            }
            if (oPageNumber != 0) break;
        }
        if (oPageNumber == 0) {
            throw new ObjectStoreException(20);
        }
        try {
            ObjectPage oPage = (ObjectPage)this.pageStore.acquire(oPageNumber);
            return oPage;
        }
        catch (PageStoreException e) {
            throw new ObjectStoreException(20, (Throwable)e);
        }
    }

    protected SpaceMapPage acquireSpaceMapPage(int objectPageNumber) throws ObjectStoreException {
        int pageNumber = objectPageNumber & 0xFFFFE000;
        SpaceMapPage p = null;
        try {
            p = (SpaceMapPage)this.pageStore.acquire(pageNumber);
        }
        catch (PageStoreException e) {
            throw new ObjectStoreException(20, (Throwable)e);
        }
        return p;
    }
}

