/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.Platform;

public class TestingSupport {
    public static Properties getMasterTable() {
        return ((Workspace)ResourcesPlugin.getWorkspace()).getSaveManager().getMasterTable();
    }

    public static Map getSessionProperties(IResource resource) {
        ResourceInfo info = ((Resource)resource).getResourceInfo(true, false);
        if (info == null) {
            return null;
        }
        return info.sessionProperties == null ? null : (Map)info.sessionProperties.clone();
    }

    public static void installMoveDeleteHook(IWorkspace workspace, IMoveDeleteHook hook) {
        Workspace ws = (Workspace)workspace;
        if (hook != null) {
            ws.moveDeleteHook = hook;
        } else {
            ws.moveDeleteHook = null;
            ws.initializeMoveDeleteHook();
        }
    }

    public static void waitForAutoBuild() {
        try {
            Platform.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException("Interrupted while waiting for build");
        }
    }

    public static void waitForSnapshot() {
        try {
            ((Workspace)ResourcesPlugin.getWorkspace()).getSaveManager().snapshotJob.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException("Interrupted while waiting for snapshot");
        }
    }

    private TestingSupport() {
    }
}

