/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.TreeViewerFrameSource;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public class NavigatorFrameSource
extends TreeViewerFrameSource {
    private ResourceNavigator navigator;

    public NavigatorFrameSource(ResourceNavigator navigator) {
        super((AbstractTreeViewer)navigator.getTreeViewer());
        this.navigator = navigator;
    }

    protected TreeFrame createFrame(Object input) {
        TreeFrame frame = super.createFrame(input);
        frame.setName(this.navigator.getFrameName(input));
        frame.setToolTipText(this.navigator.getFrameToolTipText(input));
        return frame;
    }

    protected void frameChanged(TreeFrame frame) {
        IResource resource = (IResource)frame.getInput();
        IProject project = resource.getProject();
        if (project != null && !project.isOpen()) {
            MessageDialog.openInformation((Shell)this.navigator.getViewSite().getShell(), (String)ResourceNavigatorMessages.getString("NavigatorFrameSource.closedProject.title"), (String)ResourceNavigatorMessages.format("NavigatorFrameSource.closedProject.message", new Object[]{project.getName()}));
            this.navigator.getFrameList().back();
        } else {
            super.frameChanged(frame);
            this.navigator.updateTitle();
        }
    }
}

