/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.EditorPluginAction;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;

public class EditorActionBuilder
extends PluginActionBuilder {
    private static final String TAG_CONTRIBUTION_TYPE = "editorContribution";

    protected ActionDescriptor createActionDescriptor(IConfigurationElement element) {
        return new ActionDescriptor(element, 4);
    }

    protected PluginActionBuilder.BasicContribution createContribution() {
        return new EditorContribution();
    }

    public IEditorActionBarContributor readActionExtensions(IEditorDescriptor desc, IActionBars bars) {
        ExternalContributor ext = null;
        this.readContributions(desc.getId(), TAG_CONTRIBUTION_TYPE, "editorActions");
        if (this.cache != null) {
            ext = new ExternalContributor(this.cache);
            this.cache = null;
        }
        return ext;
    }

    public static class ExternalContributor
    implements IEditorActionBarContributor {
        private ArrayList cache;

        public ExternalContributor(ArrayList cache) {
            this.cache = cache;
        }

        public void dispose() {
            for (int i = 0; i < this.cache.size(); ++i) {
                ((EditorContribution)this.cache.get(i)).dispose();
            }
        }

        public ActionDescriptor[] getExtendedActions() {
            ArrayList results = new ArrayList();
            for (int i = 0; i < this.cache.size(); ++i) {
                EditorContribution ec = (EditorContribution)this.cache.get(i);
                if (ec.actions == null) continue;
                results.addAll(ec.actions);
            }
            return results.toArray(new ActionDescriptor[results.size()]);
        }

        public void init(IActionBars bars, IWorkbenchPage page) {
            for (int i = 0; i < this.cache.size(); ++i) {
                ((EditorContribution)this.cache.get(i)).contribute(bars.getMenuManager(), false, bars.getToolBarManager(), true);
            }
        }

        public void setActiveEditor(IEditorPart editor) {
            for (int i = 0; i < this.cache.size(); ++i) {
                ((EditorContribution)this.cache.get(i)).editorChanged(editor);
            }
        }
    }

    private static class EditorContribution
    extends PluginActionBuilder.BasicContribution {
        private EditorContribution() {
        }

        public void dispose() {
            if (this.actions != null) {
                for (int i = 0; i < this.actions.size(); ++i) {
                    PluginAction proxy = ((ActionDescriptor)this.actions.get(i)).getAction();
                    if (!(proxy.getDelegate() instanceof IActionDelegate2)) continue;
                    ((IActionDelegate2)proxy.getDelegate()).dispose();
                }
            }
        }

        public void editorChanged(IEditorPart editor) {
            if (this.actions != null) {
                for (int i = 0; i < this.actions.size(); ++i) {
                    ActionDescriptor ad = (ActionDescriptor)this.actions.get(i);
                    EditorPluginAction action = (EditorPluginAction)ad.getAction();
                    action.editorChanged(editor);
                }
            }
        }
    }
}

