/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.window.WindowManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.commands.CommandManagerEvent;
import org.eclipse.ui.commands.ICommandManagerListener;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.contexts.ContextManagerEvent;
import org.eclipse.ui.contexts.IContextManagerListener;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.internal.ActivityPersistanceHelper;
import org.eclipse.ui.internal.EarlyStartupRunnable;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.ExceptionHandler;
import org.eclipse.ui.internal.ExtensionEventHandler;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.UILockListener;
import org.eclipse.ui.internal.UISynchronizer;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchConfigurer;
import org.eclipse.ui.internal.WorkbenchIntroManager;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.activities.ws.WorkbenchActivitySupport;
import org.eclipse.ui.internal.commands.ws.CommandCallback;
import org.eclipse.ui.internal.commands.ws.WorkbenchCommandSupport;
import org.eclipse.ui.internal.contexts.ws.WorkbenchContextSupport;
import org.eclipse.ui.internal.intro.IIntroRegistry;
import org.eclipse.ui.internal.intro.IntroDescriptor;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.testing.WorkbenchTestable;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.WorkbenchThemeManager;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.themes.IThemeManager;

public final class Workbench
implements IWorkbench {
    private static final String[] VERSION_STRING = new String[]{"0.046", "2.0"};
    private static final String DEFAULT_WORKBENCH_STATE_FILENAME = "workbench.xml";
    private static Workbench instance;
    private static WorkbenchTestable testableObject;
    private Display display;
    private WindowManager windowManager;
    private WorkbenchWindow activatedWindow;
    private EditorHistory editorHistory;
    private boolean runEventLoop = true;
    private boolean isStarting = true;
    private boolean isClosing = false;
    private int returnCode;
    private ListenerList windowListeners = new ListenerList();
    private WorkbenchAdvisor advisor;
    private WorkbenchConfigurer workbenchConfigurer;
    private ExtensionEventHandler extensionEventHandler;
    private int largeUpdates = 0;
    private WorkbenchActivitySupport workbenchActivitySupport;
    private WorkbenchCommandSupport workbenchCommandSupport;
    private WorkbenchContextSupport workbenchContextSupport;
    private final ICommandManagerListener commandManagerListener = new ICommandManagerListener(){

        public final void commandManagerChanged(CommandManagerEvent commandManagerEvent) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(false);
        }
    };
    private final IContextManagerListener contextManagerListener = new IContextManagerListener(){

        public final void contextManagerChanged(ContextManagerEvent contextManagerEvent) {
            SortedSet enabledContextIds = Workbench.this.workbenchContextSupport.getContextManager().getEnabledContextIds();
            Map enabledContextTree = Workbench.this.workbenchContextSupport.createFilteredContextTreeFor(enabledContextIds);
            Workbench.this.workbenchCommandSupport.setActiveContextIds(enabledContextTree);
        }
    };
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowClosed(IWorkbenchWindow window) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowOpened(IWorkbenchWindow window) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }
    };
    private ActivityPersistanceHelper activityHelper;
    private WorkbenchIntroManager introManager = new WorkbenchIntroManager(this);
    private IntroDescriptor introDescriptor;

    private Workbench(Display display, WorkbenchAdvisor advisor) {
        if (instance != null && instance.isRunning()) {
            throw new IllegalStateException(WorkbenchMessages.getString("Workbench.CreatingWorkbenchTwice"));
        }
        Assert.isNotNull(display);
        Assert.isNotNull(advisor);
        this.advisor = advisor;
        this.display = display;
        instance = this;
        this.extensionEventHandler = new ExtensionEventHandler(this);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
    }

    public static final Workbench getInstance() {
        return instance;
    }

    public static final int createAndRunWorkbench(Display display, WorkbenchAdvisor advisor) {
        Workbench workbench = new Workbench(display, advisor);
        int returnCode = workbench.runUI();
        return returnCode;
    }

    public static Display createDisplay() {
        String applicationName = WorkbenchPlugin.getDefault().getAppName();
        if (applicationName != null) {
            Display.setAppName((String)applicationName);
        }
        Display newDisplay = null;
        if (Policy.DEBUG_SWT_GRAPHICS) {
            DeviceData data = new DeviceData();
            data.tracking = true;
            newDisplay = new Display(data);
        } else {
            newDisplay = new Display();
        }
        newDisplay.setWarnings(false);
        Thread.currentThread().setPriority(Math.min(10, 6));
        return newDisplay;
    }

    public static WorkbenchTestable getWorkbenchTestable() {
        if (testableObject == null) {
            testableObject = new WorkbenchTestable();
        }
        return testableObject;
    }

    public void addWindowListener(IWindowListener l) {
        this.windowListeners.add((Object)l);
    }

    public void removeWindowListener(IWindowListener l) {
        this.windowListeners.remove((Object)l);
    }

    protected void fireWindowOpened(final IWorkbenchWindow window) {
        Object[] list = this.windowListeners.getListeners();
        for (int i = 0; i < list.length; ++i) {
            final IWindowListener l = (IWindowListener)list[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowOpened(window);
                }
            });
        }
    }

    protected void fireWindowClosed(final IWorkbenchWindow window) {
        if (this.activatedWindow == window) {
            this.activatedWindow = null;
        }
        Object[] list = this.windowListeners.getListeners();
        for (int i = 0; i < list.length; ++i) {
            final IWindowListener l = (IWindowListener)list[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowClosed(window);
                }
            });
        }
    }

    protected void fireWindowActivated(final IWorkbenchWindow window) {
        Object[] list = this.windowListeners.getListeners();
        for (int i = 0; i < list.length; ++i) {
            final IWindowListener l = (IWindowListener)list[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowActivated(window);
                }
            });
        }
    }

    protected void fireWindowDeactivated(final IWorkbenchWindow window) {
        Object[] list = this.windowListeners.getListeners();
        for (int i = 0; i < list.length; ++i) {
            final IWindowListener l = (IWindowListener)list[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowDeactivated(window);
                }
            });
        }
    }

    private boolean busyClose(final boolean force) {
        this.isClosing = this.advisor.preShutdown();
        if (!force && !this.isClosing) {
            return false;
        }
        this.isClosing = this.saveAllEditors(!force);
        if (!force && !this.isClosing) {
            return false;
        }
        IPreferenceStore store = this.getPreferenceStore();
        boolean closeEditors = store.getBoolean("CLOSE_EDITORS_ON_EXIT");
        if (closeEditors) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    IWorkbenchWindow[] windows = Workbench.this.getWorkbenchWindows();
                    for (int i = 0; i < windows.length; ++i) {
                        IWorkbenchPage[] pages = windows[i].getPages();
                        for (int j = 0; j < pages.length; ++j) {
                            Workbench.this.isClosing = Workbench.this.isClosing && pages[j].closeAllEditors(false);
                        }
                    }
                }
            });
            if (!force && !this.isClosing) {
                return false;
            }
        }
        if (this.getWorkbenchConfigurer().getSaveAndRestore()) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    XMLMemento mem = Workbench.this.recordWorkbenchState();
                    Workbench.this.saveMementoToFile(mem);
                }

                public void handleException(Throwable e) {
                    String message = e.getMessage() == null ? WorkbenchMessages.getString("ErrorClosingNoArg") : WorkbenchMessages.format("ErrorClosingOneArg", new Object[]{e.getMessage()});
                    if (!MessageDialog.openQuestion(null, (String)WorkbenchMessages.getString("Error"), (String)message)) {
                        Workbench.this.isClosing = false;
                    }
                }
            });
        }
        if (!force && !this.isClosing) {
            return false;
        }
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.getString("ErrorClosing")){

            public void run() {
                if (Workbench.this.isClosing || force) {
                    Workbench.this.isClosing = Workbench.this.windowManager.close();
                }
            }
        });
        if (!force && !this.isClosing) {
            return false;
        }
        this.shutdown();
        this.runEventLoop = false;
        return true;
    }

    public boolean saveAllEditors(boolean confirm) {
        final boolean finalConfirm = confirm;
        final boolean[] result = new boolean[]{true};
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.getString("ErrorClosing")){

            public void run() {
                ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>();
                ArrayList<IEditorInput> dirtyEditorsInput = new ArrayList<IEditorInput>();
                IWorkbenchWindow[] windows = Workbench.this.getWorkbenchWindows();
                for (int i = 0; i < windows.length; ++i) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    for (int j = 0; j < pages.length; ++j) {
                        WorkbenchPage page = (WorkbenchPage)pages[j];
                        IEditorPart[] editors = page.getDirtyEditors();
                        for (int k = 0; k < editors.length; ++k) {
                            IEditorPart editor = editors[k];
                            if (!editor.isDirty() || dirtyEditorsInput.contains(editor.getEditorInput())) continue;
                            dirtyEditors.add(editor);
                            dirtyEditorsInput.add(editor.getEditorInput());
                        }
                    }
                }
                if (dirtyEditors.size() > 0) {
                    IWorkbenchWindow w = Workbench.this.getActiveWorkbenchWindow();
                    if (w == null) {
                        w = windows[0];
                    }
                    result[0] = EditorManager.saveAll(dirtyEditors, finalConfirm, w);
                }
            }
        });
        return result[0];
    }

    private IWorkbenchWindow busyOpenWorkbenchWindow(String perspID, IAdaptable input) throws WorkbenchException {
        WorkbenchWindow newWindow = this.newWorkbenchWindow();
        newWindow.create();
        this.windowManager.add((Window)newWindow);
        try {
            newWindow.busyOpenPage(perspID, input);
        }
        catch (WorkbenchException e) {
            this.windowManager.remove((Window)newWindow);
            throw e;
        }
        newWindow.open();
        return newWindow;
    }

    public boolean close() {
        return this.close(0, false);
    }

    boolean close(int returnCode, final boolean force) {
        this.returnCode = returnCode;
        final boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ret[0] = Workbench.this.busyClose(force);
            }
        });
        return ret[0];
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        if (Display.getCurrent() == null) {
            return null;
        }
        for (Shell shell = this.display.getActiveShell(); shell != null; shell = shell.getParent()) {
            Object data = shell.getData();
            if (!(data instanceof IWorkbenchWindow)) continue;
            return (IWorkbenchWindow)data;
        }
        WorkbenchWindow win = this.getActivatedWindow();
        if (win != null) {
            return win;
        }
        Shell[] shells = this.display.getShells();
        for (int i = 0; i < shells.length; ++i) {
            Object data = shells[i].getData();
            if (!(data instanceof IWorkbenchWindow)) continue;
            return (IWorkbenchWindow)data;
        }
        return null;
    }

    protected EditorHistory getEditorHistory() {
        if (this.editorHistory == null) {
            this.editorHistory = new EditorHistory();
        }
        return this.editorHistory;
    }

    public IEditorRegistry getEditorRegistry() {
        return WorkbenchPlugin.getDefault().getEditorRegistry();
    }

    private int getNewWindowNumber() {
        Window[] windows = this.windowManager.getWindows();
        int count = windows.length;
        boolean[] checkArray = new boolean[count];
        for (int nX = 0; nX < count; ++nX) {
            WorkbenchWindow ww;
            int index;
            if (!(windows[nX] instanceof WorkbenchWindow) || (index = (ww = (WorkbenchWindow)windows[nX]).getNumber() - 1) < 0 || index >= count) continue;
            checkArray[index] = true;
        }
        for (int index = 0; index < count; ++index) {
            if (checkArray[index]) continue;
            return index + 1;
        }
        return count + 1;
    }

    public IPerspectiveRegistry getPerspectiveRegistry() {
        return WorkbenchPlugin.getDefault().getPerspectiveRegistry();
    }

    public PreferenceManager getPreferenceManager() {
        return WorkbenchPlugin.getDefault().getPreferenceManager();
    }

    public IPreferenceStore getPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public ISharedImages getSharedImages() {
        return WorkbenchPlugin.getDefault().getSharedImages();
    }

    WindowManager getWindowManager() {
        return this.windowManager;
    }

    private File getWorkbenchStateFile() {
        IPath path = WorkbenchPlugin.getDefault().getStateLocation();
        path = path.append(DEFAULT_WORKBENCH_STATE_FILENAME);
        return path.toFile();
    }

    public int getWorkbenchWindowCount() {
        return this.windowManager.getWindowCount();
    }

    public IWorkbenchWindow[] getWorkbenchWindows() {
        Window[] windows = this.windowManager.getWindows();
        IWorkbenchWindow[] dwindows = new IWorkbenchWindow[windows.length];
        System.arraycopy(windows, 0, dwindows, 0, windows.length);
        return dwindows;
    }

    public IWorkingSetManager getWorkingSetManager() {
        return WorkbenchPlugin.getDefault().getWorkingSetManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean init(Display display) {
        IProduct product;
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            WorkbenchPlugin.DEBUG = true;
            ModalContext.setDebugMode((boolean)true);
        }
        this.windowManager = new WindowManager();
        IIntroRegistry introRegistry = WorkbenchPlugin.getDefault().getIntroRegistry();
        if (introRegistry.getIntroCount() > 0 && (product = Platform.getProduct()) != null) {
            this.introDescriptor = (IntroDescriptor)introRegistry.getIntroForProduct(product.getId());
        }
        this.workbenchActivitySupport = new WorkbenchActivitySupport();
        this.activityHelper = ActivityPersistanceHelper.getInstance();
        this.workbenchContextSupport = new WorkbenchContextSupport(this);
        this.workbenchCommandSupport = new WorkbenchCommandSupport(this);
        this.workbenchContextSupport.initialize();
        this.workbenchCommandSupport.getCommandManager().addCommandManagerListener(this.commandManagerListener);
        this.workbenchContextSupport.getContextManager().addContextManagerListener(this.contextManagerListener);
        this.initializeCommandResolver();
        this.addWindowListener(this.windowListener);
        this.initializeImages();
        this.initializeFonts();
        this.initializeColors();
        this.initializeApplicationColors();
        this.advisor.internalBasicInitialize(this.getWorkbenchConfigurer());
        boolean useColorIcons = this.getPreferenceStore().getBoolean("COLOR_ICONS");
        ActionContributionItem.setUseColorIconsInToolbars((boolean)useColorIcons);
        this.initializeSingleClickOption();
        boolean avoidDeadlock = true;
        String[] commandLineArgs = Platform.getCommandLineArgs();
        for (int i = 0; i < commandLineArgs.length; ++i) {
            if (!commandLineArgs[i].equalsIgnoreCase("-allowDeadlock")) continue;
            avoidDeadlock = false;
        }
        if (avoidDeadlock) {
            UILockListener uiLockListener = new UILockListener(display);
            Platform.getJobManager().setLockListener((LockListener)uiLockListener);
            display.setSynchronizer((Synchronizer)new UISynchronizer(display, uiLockListener));
        }
        try {
            UIStats.start(UIStats.RESTORE_WORKBENCH, "Workbench");
            this.advisor.preStartup();
            if (!this.advisor.openWindows()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            UIStats.end(UIStats.RESTORE_WORKBENCH, "Workbench");
        }
        this.forceOpenPerspective();
        this.isStarting = false;
        return true;
    }

    private void initializeCommandResolver() {
        ExternalActionManager.getInstance().setCallback((ExternalActionManager.ICallback)new CommandCallback(this));
    }

    private void initializeApplicationColors() {
        ColorDefinition[] colorDefinitions = WorkbenchPlugin.getDefault().getThemeRegistry().getColors();
        ThemeElementHelper.populateRegistry(this.getThemeManager().getTheme("org.eclipse.ui.defaultTheme"), colorDefinitions, this.getPreferenceStore());
    }

    private void initializeSingleClickOption() {
        int singleClickMethod;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean openOnSingleClick = store.getBoolean("OPEN_ON_SINGLE_CLICK");
        boolean selectOnHover = store.getBoolean("SELECT_ON_HOVER");
        boolean openAfterDelay = store.getBoolean("OPEN_AFTER_DELAY");
        int n = singleClickMethod = openOnSingleClick ? 1 : 0;
        if (openOnSingleClick) {
            if (selectOnHover) {
                singleClickMethod |= 2;
            }
            if (openAfterDelay) {
                singleClickMethod |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)singleClickMethod);
    }

    private void initializeFonts() {
        FontDefinition[] fontDefinitions = WorkbenchPlugin.getDefault().getThemeRegistry().getFonts();
        ThemeElementHelper.populateRegistry(this.getThemeManager().getTheme("org.eclipse.ui.defaultTheme"), fontDefinitions, this.getPreferenceStore());
    }

    private void initializeImages() {
        ImageDescriptor[] windowImages = WorkbenchPlugin.getDefault().getWindowImages();
        if (windowImages == null) {
            return;
        }
        Image[] images = new Image[windowImages.length];
        for (int i = 0; i < windowImages.length; ++i) {
            images[i] = windowImages[i].createImage();
        }
        Window.setDefaultImages((Image[])images);
    }

    private void uninitializeImages() {
        Window.setDefaultImage(null);
    }

    private void initializeColors() {
        WorkbenchColors.startup();
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    boolean isStarting() {
        return this.isStarting;
    }

    private WorkbenchWindow newWorkbenchWindow() {
        return new WorkbenchWindow(this.getNewWindowNumber());
    }

    private void forceOpenPerspective() {
        if (this.getWorkbenchWindowCount() == 0) {
            return;
        }
        String perspId = null;
        String[] commandLineArgs = Platform.getCommandLineArgs();
        for (int i = 0; i < commandLineArgs.length - 1; ++i) {
            if (!commandLineArgs[i].equalsIgnoreCase("-perspective")) continue;
            perspId = commandLineArgs[i + 1];
            break;
        }
        if (perspId == null) {
            return;
        }
        IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspId);
        if (desc == null) {
            return;
        }
        IWorkbenchWindow win = this.getActiveWorkbenchWindow();
        if (win == null) {
            win = this.getWorkbenchWindows()[0];
        }
        try {
            this.showPerspective(perspId, win);
        }
        catch (WorkbenchException e) {
            String msg = "Workbench exception showing specified command line perspective on startup.";
            WorkbenchPlugin.log(msg, (IStatus)new Status(4, "org.eclipse.ui", 0, msg, (Throwable)((Object)e)));
        }
    }

    void openFirstTimeWindow() {
        WorkbenchWindow newWindow = this.newWorkbenchWindow();
        newWindow.create();
        this.windowManager.add((Window)newWindow);
        try {
            newWindow.openPage(this.getPerspectiveRegistry().getDefaultPerspective(), this.getDefaultPageInput());
        }
        catch (WorkbenchException e) {
            ErrorDialog.openError((Shell)newWindow.getShell(), (String)WorkbenchMessages.getString("Problems_Opening_Page"), (String)e.getMessage(), (IStatus)e.getStatus());
        }
        newWindow.open();
    }

    IStatus restoreState() {
        if (!this.getWorkbenchConfigurer().getSaveAndRestore()) {
            String msg = WorkbenchMessages.getString("Workbench.restoreDisabled");
            return new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, msg, null);
        }
        final File stateFile = this.getWorkbenchStateFile();
        if (!stateFile.exists()) {
            String msg = WorkbenchMessages.getString("Workbench.noStateToRestore");
            return new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, msg, null);
        }
        final IStatus[] result = new IStatus[]{new Status(0, WorkbenchPlugin.PI_WORKBENCH, 0, "", null)};
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.getString("ErrorReadingState")){

            public void run() throws Exception {
                FileInputStream input = new FileInputStream(stateFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, "utf-8"));
                XMLMemento memento = XMLMemento.createReadRoot(reader);
                String version = memento.getString("version");
                boolean valid = false;
                for (int i = 0; i < VERSION_STRING.length; ++i) {
                    if (!VERSION_STRING[i].equals(version)) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    reader.close();
                    String msg = WorkbenchMessages.getString("Invalid_workbench_state_ve");
                    MessageDialog.openError((Shell)null, (String)WorkbenchMessages.getString("Restoring_Problems"), (String)msg);
                    stateFile.delete();
                    result[0] = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, msg, null);
                    return;
                }
                if (VERSION_STRING[0].equals(version)) {
                    boolean ignoreSavedState;
                    reader.close();
                    String msg = WorkbenchMessages.getString("Workbench.incompatibleSavedStateVersion");
                    boolean bl = ignoreSavedState = new MessageDialog(null, WorkbenchMessages.getString("Workbench.incompatibleUIState"), null, msg, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0).open() == 0;
                    if (ignoreSavedState) {
                        stateFile.delete();
                        result[0] = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, msg, null);
                    } else {
                        result[0] = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 2, msg, null);
                    }
                    return;
                }
                IStatus restoreResult = Workbench.this.restoreState(memento);
                reader.close();
                if (restoreResult.getSeverity() == 4) {
                    ErrorDialog.openError(null, (String)WorkbenchMessages.getString("Workspace.problemsTitle"), (String)WorkbenchMessages.getString("Workbench.problemsRestoringMsg"), (IStatus)restoreResult);
                }
            }

            public void handleException(Throwable e) {
                super.handleException(e);
                String msg = e.getMessage() == null ? "" : e.getMessage();
                result[0] = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, msg, e);
                stateFile.delete();
            }
        });
        if (result[0].isOK() && this.windowManager.getWindows().length == 0) {
            String msg = WorkbenchMessages.getString("Workbench.noWindowsRestored");
            result[0] = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, msg, null);
        }
        return result[0];
    }

    public IWorkbenchWindow openWorkbenchWindow(IAdaptable input) throws WorkbenchException {
        return this.openWorkbenchWindow(this.getPerspectiveRegistry().getDefaultPerspective(), input);
    }

    public IWorkbenchWindow openWorkbenchWindow(final String perspID, final IAdaptable input) throws WorkbenchException {
        final Object[] result = new Object[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    result[0] = Workbench.this.busyOpenWorkbenchWindow(perspID, input);
                }
                catch (WorkbenchException e) {
                    result[0] = e;
                }
            }
        });
        if (result[0] instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)result[0];
        }
        if (result[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)result[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.getString("Abnormal_Workbench_Conditi"));
    }

    private XMLMemento recordWorkbenchState() {
        XMLMemento memento = XMLMemento.createWriteRoot("workbench");
        IStatus status = this.saveState(memento);
        if (status.getSeverity() != 0) {
            ErrorDialog.openError((Shell)null, (String)WorkbenchMessages.getString("Workbench.problemsSaving"), (String)WorkbenchMessages.getString("Workbench.problemsSavingMsg"), (IStatus)status);
        }
        return memento;
    }

    public boolean restart() {
        return this.close(1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus restoreState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("Workbench.problemsRestoring"), null);
        try {
            UIStats.start(UIStats.RESTORE_WORKBENCH, "MRUList");
            IMemento mruMemento = memento.getChild("mruList");
            if (mruMemento != null) {
                result.add(this.getEditorHistory().restoreState(mruMemento));
            }
        }
        finally {
            UIStats.end(UIStats.RESTORE_WORKBENCH, "MRUList");
        }
        IMemento[] children = memento.getChildren("window");
        for (int x = 0; x < children.length; ++x) {
            IMemento childMem = children[x];
            WorkbenchWindow newWindow = this.newWorkbenchWindow();
            newWindow.create();
            this.windowManager.add((Window)newWindow);
            boolean opened = false;
            try {
                result.merge(newWindow.restoreState(childMem, null));
                try {
                    this.getAdvisor().postWindowRestore(newWindow.getWindowConfigurer());
                }
                catch (WorkbenchException e) {
                    result.add(e.getStatus());
                }
                newWindow.open();
                opened = true;
                continue;
            }
            finally {
                if (!opened) {
                    newWindow.close();
                }
            }
        }
        return result;
    }

    public String[] getEarlyActivatedPlugins() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "startup");
        IExtension[] extensions = point.getExtensions();
        String[] result = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            result[i] = extensions[i].getNamespace();
        }
        return result;
    }

    private void startPlugins() {
        Runnable work = new Runnable(){
            final String disabledPlugins;
            {
                this.disabledPlugins = Workbench.this.getPreferenceStore().getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
            }

            public void run() {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint point = registry.getExtensionPoint("org.eclipse.ui", "startup");
                IExtension[] extensions = point.getExtensions();
                for (int i = 0; i < extensions.length; ++i) {
                    IExtension extension = extensions[i];
                    if (this.disabledPlugins.indexOf(extension.getNamespace()) != -1) continue;
                    Platform.run((ISafeRunnable)new EarlyStartupRunnable(extension));
                }
            }
        };
        Thread thread = new Thread(work);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runUI() {
        UIStats.start(UIStats.START_WORKBENCH, "Workbench");
        Listener closeListener = new Listener(){

            public void handleEvent(Event event) {
                event.doit = Workbench.this.close();
            }
        };
        ExceptionHandler handler = ExceptionHandler.getInstance();
        try {
            block7: {
                try {
                    this.display.addListener(21, closeListener);
                    Window.setExceptionHandler((Window.IExceptionHandler)handler);
                    boolean initOK = this.init(this.display);
                    Platform.endSplash();
                    if (initOK) {
                        this.advisor.postStartup();
                    }
                    if (!initOK || !this.runEventLoop) break block7;
                    this.startPlugins();
                    this.display.asyncExec(new Runnable(){

                        public void run() {
                            UIStats.end(UIStats.START_WORKBENCH, "Workbench");
                        }
                    });
                    Workbench.getWorkbenchTestable().init(this.display, this);
                    this.runEventLoop(handler, this.display);
                }
                catch (Exception e) {
                    if (!this.display.isDisposed()) {
                        handler.handleException(e);
                    } else {
                        String msg = "Exception in Workbench.runUI after display was disposed";
                        WorkbenchPlugin.log(msg, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, msg, (Throwable)e));
                    }
                    Object var6_6 = null;
                    if (this.display.isDisposed()) return this.returnCode;
                    this.display.removeListener(21, closeListener);
                    return this.returnCode;
                }
            }
            Object var6_5 = null;
            if (this.display.isDisposed()) return this.returnCode;
            this.display.removeListener(21, closeListener);
            return this.returnCode;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (this.display.isDisposed()) throw throwable;
            this.display.removeListener(21, closeListener);
            throw throwable;
        }
    }

    private void runEventLoop(Window.IExceptionHandler handler, Display display) {
        this.runEventLoop = true;
        while (this.runEventLoop) {
            try {
                if (display.readAndDispatch()) continue;
                this.getAdvisor().eventLoopIdle(display);
            }
            catch (Throwable t) {
                handler.handleException(t);
            }
        }
    }

    private IStatus saveState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("Workbench.problemsSaving"), null);
        memento.putString("version", VERSION_STRING[1]);
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        for (int nX = 0; nX < windows.length; ++nX) {
            WorkbenchWindow window = (WorkbenchWindow)windows[nX];
            IMemento childMem = memento.createChild("window");
            result.merge(window.saveState(childMem));
        }
        result.add(this.getEditorHistory().saveState(memento.createChild("mruList")));
        return result;
    }

    private boolean saveMementoToFile(XMLMemento memento) {
        File stateFile = this.getWorkbenchStateFile();
        try {
            FileOutputStream stream = new FileOutputStream(stateFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
            memento.save(writer);
            writer.close();
        }
        catch (IOException e) {
            stateFile.delete();
            MessageDialog.openError((Shell)null, (String)WorkbenchMessages.getString("SavingProblem"), (String)WorkbenchMessages.getString("ProblemSavingState"));
            return false;
        }
        return true;
    }

    public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow window) throws WorkbenchException {
        Object persp;
        int i;
        WorkbenchPage page;
        Assert.isNotNull(perspectiveId);
        WorkbenchWindow win = (WorkbenchWindow)window;
        if (win != null && (page = win.getActiveWorkbenchPage()) != null) {
            IPerspectiveDescriptor[] perspectives = page.getOpenedPerspectives();
            for (i = 0; i < perspectives.length; ++i) {
                IPerspectiveDescriptor persp2 = perspectives[i];
                if (!perspectiveId.equals(persp2.getId())) continue;
                win.getShell().open();
                page.setPerspective(persp2);
                return page;
            }
        }
        IAdaptable input = this.getDefaultPageInput();
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        for (i = 0; i < windows.length; ++i) {
            WorkbenchPage page2;
            win = (WorkbenchWindow)windows[i];
            if (window == win || (page2 = win.getActiveWorkbenchPage()) == null) continue;
            boolean inputSame = false;
            inputSame = input == null ? page2.getInput() == null : input.equals(page2.getInput());
            if (!inputSame || !perspectiveId.equals(((Perspective)(persp = page2.getActivePerspective())).getDesc().getId())) continue;
            Shell shell = win.getShell();
            shell.open();
            if (shell.getMinimized()) {
                shell.setMinimized(false);
            }
            return page2;
        }
        win = (WorkbenchWindow)window;
        if (win != null) {
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            int mode = store.getInt("OPEN_PERSPECTIVE_MODE");
            IWorkbenchPage page3 = win.getActiveWorkbenchPage();
            persp = null;
            if (page3 != null) {
                persp = page3.getPerspective();
            }
            if (2 == mode && persp != null) {
                IWorkbenchWindow newWindow = this.openWorkbenchWindow(perspectiveId, input);
                return newWindow.getActivePage();
            }
            IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
            if (desc == null) {
                throw new WorkbenchException(WorkbenchMessages.getString("WorkbenchPage.ErrorRecreatingPerspective"));
            }
            win.getShell().open();
            if (page3 == null) {
                page3 = win.openPage(perspectiveId, input);
            } else {
                page3.setPerspective(desc);
            }
            return page3;
        }
        throw new WorkbenchException(WorkbenchMessages.format("Workbench.showPerspectiveError", new Object[]{perspectiveId}));
    }

    public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow window, IAdaptable input) throws WorkbenchException {
        IPreferenceStore store;
        int mode;
        Object persp;
        WorkbenchPage page;
        Assert.isNotNull(perspectiveId);
        boolean inputSameAsWindow = false;
        WorkbenchWindow win = (WorkbenchWindow)window;
        if (win != null && (page = win.getActiveWorkbenchPage()) != null) {
            boolean inputSame = false;
            inputSame = input == null ? page.getInput() == null : input.equals(page.getInput());
            if (inputSame) {
                inputSameAsWindow = true;
                IPerspectiveDescriptor[] perspectives = page.getOpenedPerspectives();
                for (int i = 0; i < perspectives.length; ++i) {
                    persp = perspectives[i];
                    if (!perspectiveId.equals(persp.getId())) continue;
                    win.getShell().open();
                    page.setPerspective((IPerspectiveDescriptor)persp);
                    return page;
                }
            }
        }
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        for (int i = 0; i < windows.length; ++i) {
            WorkbenchPage page2;
            win = (WorkbenchWindow)windows[i];
            if (window == win || (page2 = win.getActiveWorkbenchPage()) == null) continue;
            boolean inputSame = false;
            inputSame = input == null ? page2.getInput() == null : input.equals(page2.getInput());
            if (!inputSame || !perspectiveId.equals(((Perspective)(persp = page2.getActivePerspective())).getDesc().getId())) continue;
            win.getShell().open();
            return page2;
        }
        win = (WorkbenchWindow)window;
        if (inputSameAsWindow && win != null && 2 != (mode = (store = WorkbenchPlugin.getDefault().getPreferenceStore()).getInt("OPEN_PERSPECTIVE_MODE"))) {
            IWorkbenchPage page3 = win.getActiveWorkbenchPage();
            IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
            if (desc == null) {
                throw new WorkbenchException(WorkbenchMessages.getString("WorkbenchPage.ErrorRecreatingPerspective"));
            }
            win.getShell().open();
            if (page3 == null) {
                page3 = win.openPage(perspectiveId, input);
            } else {
                page3.setPerspective(desc);
            }
            return page3;
        }
        if (win != null) {
            IWorkbenchPage page4 = win.getActiveWorkbenchPage();
            IPerspectiveDescriptor persp2 = null;
            if (page4 != null) {
                persp2 = page4.getPerspective();
            }
            if (persp2 == null) {
                IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
                if (desc == null) {
                    throw new WorkbenchException(WorkbenchMessages.getString("WorkbenchPage.ErrorRecreatingPerspective"));
                }
                win.getShell().open();
                if (page4 == null) {
                    page4 = win.openPage(perspectiveId, input);
                } else {
                    page4.setPerspective(desc);
                }
                return page4;
            }
        }
        IWorkbenchWindow newWindow = this.openWorkbenchWindow(perspectiveId, input);
        return newWindow.getActivePage();
    }

    private void shutdown() {
        this.advisor.postShutdown();
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
        WorkbenchColors.shutdown();
        this.activityHelper.shutdown();
        this.uninitializeImages();
        if (WorkbenchPlugin.getDefault() != null) {
            WorkbenchPlugin.getDefault().reset();
        }
        WorkbenchThemeManager.getInstance().dispose();
    }

    public IDecoratorManager getDecoratorManager() {
        return WorkbenchPlugin.getDefault().getDecoratorManager();
    }

    private WorkbenchWindow getActivatedWindow() {
        Shell shell;
        if (this.activatedWindow != null && (shell = this.activatedWindow.getShell()) != null && !shell.isDisposed()) {
            return this.activatedWindow;
        }
        return null;
    }

    void setActivatedWindow(WorkbenchWindow window) {
        this.activatedWindow = window;
    }

    WorkbenchConfigurer getWorkbenchConfigurer() {
        if (this.workbenchConfigurer == null) {
            this.workbenchConfigurer = new WorkbenchConfigurer();
        }
        return this.workbenchConfigurer;
    }

    WorkbenchAdvisor getAdvisor() {
        return this.advisor;
    }

    public Display getDisplay() {
        return this.display;
    }

    public String getDefaultPerspectiveId() {
        String id = this.getAdvisor().getInitialWindowPerspectiveId();
        Assert.isNotNull(id);
        return id;
    }

    public IAdaptable getDefaultPageInput() {
        return this.getAdvisor().getDefaultPageInput();
    }

    public String getMainPreferencePageId() {
        String id = this.getAdvisor().getMainPreferencePageId();
        return id;
    }

    public IElementFactory getElementFactory(String factoryId) {
        Assert.isNotNull(factoryId);
        return WorkbenchPlugin.getDefault().getElementFactory(factoryId);
    }

    public IProgressService getProgressService() {
        return ProgressManager.getInstance();
    }

    public IWorkbenchActivitySupport getActivitySupport() {
        return this.workbenchActivitySupport;
    }

    public IWorkbenchCommandSupport getCommandSupport() {
        return this.workbenchCommandSupport;
    }

    public IWorkbenchContextSupport getContextSupport() {
        return this.workbenchContextSupport;
    }

    private void updateActiveWorkbenchWindowMenuManager(boolean textOnly) {
        IWorkbenchWindow workbenchWindow = this.getActiveWorkbenchWindow();
        if (workbenchWindow instanceof WorkbenchWindow) {
            WorkbenchWindow window = (WorkbenchWindow)workbenchWindow;
            if (window.isClosing()) {
                return;
            }
            MenuManager menuManager = window.getMenuManager();
            if (textOnly) {
                menuManager.update("text");
            } else {
                menuManager.updateAll(true);
            }
        }
    }

    public IIntroManager getIntroManager() {
        return this.introManager;
    }

    WorkbenchIntroManager getWorkbenchIntroManager() {
        return this.introManager;
    }

    public IntroDescriptor getIntroDescriptor() {
        return this.introDescriptor;
    }

    public void setIntroDescriptor(IntroDescriptor descriptor) {
        if (this.introManager.getIntro() != null) {
            this.introManager.closeIntro(this.introManager.getIntro());
        }
        this.introDescriptor = descriptor;
    }

    public IThemeManager getThemeManager() {
        return WorkbenchThemeManager.getInstance();
    }

    public boolean isRunning() {
        return this.runEventLoop;
    }

    public String getPresentationId() {
        String factoryId = PrefUtil.getAPIPreferenceStore().getString("presentationFactoryId");
        if (factoryId == null || factoryId.equals("")) {
            factoryId = "org.eclipse.ui.presentations.default";
        }
        return factoryId;
    }

    public final void largeUpdateStart() {
        if (this.largeUpdates++ == 0) {
            this.workbenchCommandSupport.setProcessing(false);
            this.workbenchContextSupport.setProcessing(false);
        }
    }

    public final void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            this.workbenchCommandSupport.setProcessing(true);
            this.workbenchContextSupport.setProcessing(true);
        }
    }
}

