/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.commands.CommandException;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.commands.NotHandledException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.ws.WorkbenchCommandSupport;
import org.eclipse.ui.internal.contexts.ws.WorkbenchContextSupport;
import org.eclipse.ui.internal.keys.KeyBindingState;
import org.eclipse.ui.internal.keys.OutOfOrderListener;
import org.eclipse.ui.internal.keys.OutOfOrderVerifyListener;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.util.StatusLineContributionItem;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.ParseException;
import org.eclipse.ui.keys.SWTKeySupport;

public final class WorkbenchKeyboard {
    private static final boolean DEBUG = Policy.DEBUG_KEY_BINDINGS;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_KEY_BINDINGS_VERBOSE;
    private static final int MULTI_KEY_ASSIST_SHELL_MAX_HEIGHT = 175;
    private static final int MULTI_KEY_ASSIST_SHELL_MAX_WIDTH = 300;
    static final String OUT_OF_ORDER_KEYS = "OutOfOrderKeys";
    static KeySequence outOfOrderKeys;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private final IActivityManager activityManager;
    private final ICommandManager commandManager;
    private final Listener keyDownFilter = new Listener(){

        public void handleEvent(Event event) {
            if (DEBUG && DEBUG_VERBOSE) {
                System.out.print("KEYS >>> Listener.handleEvent(type = ");
                switch (event.type) {
                    case 1: {
                        System.out.print("KeyDown");
                        break;
                    }
                    case 31: {
                        System.out.print("Traverse");
                        break;
                    }
                    default: {
                        System.out.print(event.type);
                    }
                }
                System.out.println(", stateMask = 0x" + Integer.toHexString(event.stateMask) + ", keyCode = 0x" + Integer.toHexString(event.keyCode) + ", character = 0x" + Integer.toHexString(event.character) + ")");
            }
            WorkbenchKeyboard.this.filterKeySequenceBindings(event);
        }
    };
    private Shell multiKeyAssistShell = null;
    private long startTime = Long.MAX_VALUE;
    private final KeyBindingState state;
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
            WorkbenchKeyboard.this.checkActiveWindow(window);
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    };
    private final IWorkbench workbench;
    static /* synthetic */ Class class$org$eclipse$ui$internal$keys$WorkbenchKeyboard;

    public static List generatePossibleKeyStrokes(Event event) {
        int thirdAccelerator;
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(3);
        if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
            return keyStrokes;
        }
        int firstAccelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator(event);
        keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke(firstAccelerator));
        if (event.character == '\u007f') {
            return keyStrokes;
        }
        int secondAccelerator = SWTKeySupport.convertEventToUnshiftedModifiedAccelerator(event);
        if (secondAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke(secondAccelerator));
        }
        if ((thirdAccelerator = SWTKeySupport.convertEventToModifiedAccelerator(event)) != secondAccelerator && thirdAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke(thirdAccelerator));
        }
        return keyStrokes;
    }

    private static void initializeOutOfOrderKeys() {
        String keysText = Util.translateString(RESOURCE_BUNDLE, OUT_OF_ORDER_KEYS);
        outOfOrderKeys = KeySequence.getInstance();
        try {
            outOfOrderKeys = KeySequence.getInstance(keysText);
        }
        catch (ParseException e) {
            String message = "Could not parse out-of-order keys definition: '" + keysText + "'.  Continuing with no out-of-order keys.";
            WorkbenchPlugin.log(message, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e));
        }
    }

    private static boolean isOutOfOrderKey(List keyStrokes) {
        Iterator keyStrokeItr = keyStrokes.iterator();
        List outOfOrderKeyStrokes = outOfOrderKeys.getKeyStrokes();
        while (keyStrokeItr.hasNext()) {
            if (!outOfOrderKeyStrokes.contains(keyStrokeItr.next())) continue;
            return true;
        }
        return false;
    }

    public WorkbenchKeyboard(Workbench associatedWorkbench, IActivityManager associatedActivityManager, ICommandManager associatedCommandManager) {
        this.workbench = associatedWorkbench;
        this.state = new KeyBindingState(associatedWorkbench);
        this.activityManager = associatedActivityManager;
        this.commandManager = associatedCommandManager;
        this.workbench.addWindowListener(this.windowListener);
    }

    private void checkActiveWindow(IWorkbenchWindow window) {
        if (!window.equals(this.state.getAssociatedWindow())) {
            this.resetState();
            this.state.setAssociatedWindow(window);
        }
    }

    private void closeMultiKeyAssistShell() {
        if (this.multiKeyAssistShell != null && !this.multiKeyAssistShell.isDisposed()) {
            this.workbench.getContextSupport().unregisterShell(this.multiKeyAssistShell);
            this.multiKeyAssistShell.close();
            this.multiKeyAssistShell.dispose();
            this.multiKeyAssistShell = null;
        }
    }

    private static boolean isEnabled(ICommand command) {
        try {
            Map attributeValuesByName = command.getAttributeValuesByName();
            return !attributeValuesByName.containsKey("enabled") || Boolean.TRUE.equals(attributeValuesByName.get("enabled"));
        }
        catch (NotHandledException eNotHandled) {
            return false;
        }
    }

    private boolean executeCommand(String commandId) throws CommandException {
        if (DEBUG) {
            System.out.println("KEYS >>> WorkbenchKeyboard.executeCommand(commandId = '" + commandId + "')");
        }
        this.resetState();
        ICommand command = this.commandManager.getCommand(commandId);
        if (DEBUG && DEBUG_VERBOSE) {
            if (!command.isDefined()) {
                System.out.println("KEYS >>>     not defined");
            } else if (!command.isHandled()) {
                System.out.println("KEYS >>>     not handled");
            } else if (!WorkbenchKeyboard.isEnabled(command)) {
                System.out.println("KEYS >>>     not enabled");
            } else {
                try {
                    Map attributeValuesByName = command.getAttributeValuesByName();
                    System.out.println("KEYS >>>     value for 'id' attribute = " + attributeValuesByName.get("id"));
                    System.out.println("KEYS >>>     value for 'enabled' attribute = " + attributeValuesByName.get("enabled"));
                }
                catch (NotHandledException eNotHandled) {
                    System.out.println(eNotHandled);
                }
            }
        }
        boolean commandDefined = command.isDefined();
        boolean commandHandled = command.isHandled();
        if (commandDefined && commandHandled && WorkbenchKeyboard.isEnabled(command)) {
            command.execute(null);
        }
        return commandDefined && commandHandled;
    }

    private void filterKeySequenceBindings(Event event) {
        if ((event.keyCode & SWT.MODIFIER_MASK) != 0) {
            return;
        }
        List keyStrokes = WorkbenchKeyboard.generatePossibleKeyStrokes(event);
        if (WorkbenchKeyboard.isOutOfOrderKey(keyStrokes)) {
            if (event.type == 1) {
                Widget widget = event.widget;
                if (event.character == '\u007f' && (event.stateMask & SWT.MODIFIER_MASK) == 0 && (widget instanceof Text || widget instanceof Combo)) {
                    return;
                }
                if (widget instanceof StyledText) {
                    ((StyledText)widget).addVerifyKeyListener((VerifyKeyListener)new OutOfOrderVerifyListener(new OutOfOrderListener(this)));
                } else {
                    widget.addListener(1, (Listener)new OutOfOrderListener(this));
                }
            }
        } else {
            this.processKeyEvent(keyStrokes, event);
        }
    }

    public Listener getKeyDownFilter() {
        return this.keyDownFilter;
    }

    private String getPerfectMatch(KeySequence keySequence) {
        return this.commandManager.getPerfectMatch(keySequence);
    }

    private void incrementState(KeySequence sequence) {
        final long myStartTime = this.startTime = System.currentTimeMillis();
        this.state.setCurrentSequence(sequence);
        this.state.setAssociatedWindow(this.workbench.getActiveWorkbenchWindow());
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("MULTI_KEY_ASSIST")) {
            final Display display = this.workbench.getDisplay();
            final int delay = store.getInt("MULTI_KEY_ASSIST_TIME");
            display.timerExec(delay, new Runnable(){

                public void run() {
                    if (System.currentTimeMillis() > myStartTime - (long)delay && WorkbenchKeyboard.this.startTime == myStartTime) {
                        WorkbenchKeyboard.this.openMultiKeyAssistShell(display);
                    }
                }
            });
        }
    }

    private boolean isPartialMatch(KeySequence keySequence) {
        return this.commandManager.isPartialMatch(keySequence);
    }

    private boolean isPerfectMatch(KeySequence keySequence) {
        return this.commandManager.isPerfectMatch(keySequence);
    }

    private final void logException(CommandException e) {
        Throwable nestedException = e.getCause();
        Throwable exception = nestedException == null ? e : nestedException;
        String message = Util.translateString(RESOURCE_BUNDLE, "ExecutionError.Message");
        String title = Util.translateString(RESOURCE_BUNDLE, "ExecutionError.Title");
        String exceptionMessage = exception.getMessage();
        if (exceptionMessage == null) {
            exceptionMessage = message;
        }
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, exceptionMessage, exception);
        ErrorDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (IStatus)status);
        WorkbenchPlugin.log(message, (IStatus)status);
    }

    private void openMultiKeyAssistShell(Display display) {
        StatusLineContributionItem statusLine;
        if (this.multiKeyAssistShell != null) {
            this.multiKeyAssistShell.close();
        }
        if ((statusLine = this.state.getStatusLine()) == null) {
            return;
        }
        Point statusLineLocation = statusLine.getDisplayLocation();
        if (statusLineLocation == null) {
            return;
        }
        this.multiKeyAssistShell = new Shell(display, 8);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.multiKeyAssistShell.setLayout((Layout)layout);
        this.multiKeyAssistShell.setBackground(display.getSystemColor(29));
        TreeMap partialMatches = new TreeMap(new Comparator(){

            public int compare(Object a, Object b) {
                KeySequence sequenceA = (KeySequence)a;
                KeySequence sequenceB = (KeySequence)b;
                return sequenceA.format().compareTo(sequenceB.format());
            }
        });
        partialMatches.putAll(this.commandManager.getPartialMatches(this.state.getCurrentSequence()));
        Iterator partialMatchItr = partialMatches.entrySet().iterator();
        while (partialMatchItr.hasNext()) {
            Map.Entry entry = partialMatchItr.next();
            String commandId = (String)entry.getValue();
            ICommand command = this.commandManager.getCommand(commandId);
            if (command.isDefined() && this.activityManager.getIdentifier(command.getId()).isEnabled()) continue;
            partialMatchItr.remove();
        }
        if (partialMatches.isEmpty()) {
            Label noMatchesLabel = new Label((Composite)this.multiKeyAssistShell, 0);
            noMatchesLabel.setText(Util.translateString(RESOURCE_BUNDLE, "NoMatches.Message"));
            noMatchesLabel.setLayoutData((Object)new GridData(1808));
            noMatchesLabel.setBackground(this.multiKeyAssistShell.getBackground());
        } else {
            final Table completionsTable = new Table((Composite)this.multiKeyAssistShell, 4);
            completionsTable.setBackground(this.multiKeyAssistShell.getBackground());
            GridData gridData = new GridData(1808);
            completionsTable.setLayoutData((Object)gridData);
            final ArrayList<ICommand> commands = new ArrayList<ICommand>();
            TableColumn columnKeySequence = new TableColumn(completionsTable, 16384, 0);
            TableColumn columnCommandName = new TableColumn(completionsTable, 16384, 1);
            Iterator itemsItr = partialMatches.entrySet().iterator();
            while (itemsItr.hasNext()) {
                Map.Entry entry = itemsItr.next();
                KeySequence sequence = (KeySequence)entry.getKey();
                String commandId = (String)entry.getValue();
                ICommand command = this.commandManager.getCommand(commandId);
                try {
                    String[] text = new String[]{sequence.format(), command.getName()};
                    TableItem item = new TableItem(completionsTable, 0);
                    item.setText(text);
                    commands.add(command);
                }
                catch (NotDefinedException e) {}
            }
            columnKeySequence.pack();
            columnCommandName.pack();
            completionsTable.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    int selectionIndex = completionsTable.getSelectionIndex();
                    if (selectionIndex >= 0) {
                        ICommand command = (ICommand)commands.get(selectionIndex);
                        try {
                            WorkbenchKeyboard.this.executeCommand(command.getId());
                        }
                        catch (CommandException e) {
                            WorkbenchKeyboard.this.logException(e);
                        }
                    }
                }

                public void widgetSelected(SelectionEvent event) {
                }
            });
        }
        this.multiKeyAssistShell.pack();
        Point assistShellSize = this.multiKeyAssistShell.getSize();
        if (assistShellSize.x > 300) {
            assistShellSize.x = 300;
        }
        if (assistShellSize.y > 175) {
            assistShellSize.y = 175;
        }
        this.multiKeyAssistShell.setSize(assistShellSize);
        Point assistShellLocation = new Point(statusLineLocation.x, statusLineLocation.y - assistShellSize.y);
        Rectangle displayBounds = display.getBounds();
        int displayRightEdge = displayBounds.x + displayBounds.width;
        if (assistShellLocation.x < displayBounds.x) {
            assistShellLocation.x = displayBounds.x;
        } else if (assistShellLocation.x + assistShellSize.x > displayRightEdge) {
            assistShellLocation.x = displayRightEdge - assistShellSize.x;
        }
        int displayBottomEdge = displayBounds.y + displayBounds.height;
        if (assistShellLocation.y < displayBounds.y) {
            assistShellLocation.y = displayBounds.y;
        } else if (assistShellLocation.y + assistShellSize.y > displayBottomEdge) {
            assistShellLocation.y = displayBottomEdge - assistShellSize.y;
        }
        this.multiKeyAssistShell.setLocation(assistShellLocation);
        this.multiKeyAssistShell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                WorkbenchKeyboard.this.closeMultiKeyAssistShell();
            }
        });
        this.workbench.getContextSupport().registerShell(this.multiKeyAssistShell, 2);
        this.multiKeyAssistShell.open();
    }

    public boolean press(List potentialKeyStrokes, Event event) throws CommandException {
        if (DEBUG && DEBUG_VERBOSE) {
            System.out.println("KEYS >>> WorkbenchKeyboard.press(potentialKeyStrokes = " + potentialKeyStrokes + ")");
        }
        if ("gtk".equals(SWT.getPlatform())) {
            Widget widget = event.widget;
            Shell shell = widget instanceof Control && !widget.isDisposed() ? ((Control)widget).getShell() : Display.getCurrent().getActiveShell();
            ((WorkbenchCommandSupport)this.workbench.getCommandSupport()).processHandlerSubmissions(false, shell);
            ((WorkbenchContextSupport)this.workbench.getContextSupport()).processEnabledSubmissions(false, shell);
        }
        KeySequence sequenceBeforeKeyStroke = this.state.getCurrentSequence();
        Iterator iterator = potentialKeyStrokes.iterator();
        while (iterator.hasNext()) {
            KeySequence sequenceAfterKeyStroke = KeySequence.getInstance(sequenceBeforeKeyStroke, (KeyStroke)iterator.next());
            if (this.isPartialMatch(sequenceAfterKeyStroke)) {
                this.incrementState(sequenceAfterKeyStroke);
                return true;
            }
            if (this.isPerfectMatch(sequenceAfterKeyStroke)) {
                String commandId = this.getPerfectMatch(sequenceAfterKeyStroke);
                return this.executeCommand(commandId) || !sequenceBeforeKeyStroke.isEmpty();
            }
            if (this.multiKeyAssistShell == null || event.keyCode != 0x1000002 && event.keyCode != 0x1000001 && event.keyCode != 0x1000003 && event.keyCode != 0x1000004 && event.keyCode != 13) continue;
            return false;
        }
        this.resetState();
        return false;
    }

    void processKeyEvent(List keyStrokes, Event event) {
        boolean eatKey = false;
        if (!keyStrokes.isEmpty()) {
            try {
                eatKey = this.press(keyStrokes, event);
            }
            catch (CommandException e) {
                this.logException(e);
                eatKey = true;
            }
        }
        if (eatKey) {
            switch (event.type) {
                case 1: {
                    event.doit = false;
                    break;
                }
                case 31: {
                    event.detail = 0;
                    event.doit = true;
                    break;
                }
            }
            event.type = 0;
        }
    }

    private void resetState() {
        this.startTime = Long.MAX_VALUE;
        this.state.reset();
        this.closeMultiKeyAssistShell();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RESOURCE_BUNDLE = ResourceBundle.getBundle((class$org$eclipse$ui$internal$keys$WorkbenchKeyboard == null ? (class$org$eclipse$ui$internal$keys$WorkbenchKeyboard = WorkbenchKeyboard.class$("org.eclipse.ui.internal.keys.WorkbenchKeyboard")) : class$org$eclipse$ui$internal$keys$WorkbenchKeyboard).getName());
        WorkbenchKeyboard.initializeOutOfOrderKeys();
    }
}

