/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.themes.ColorUtils;
import org.eclipse.ui.internal.themes.ICategorizedThemeElementDefinition;
import org.eclipse.ui.internal.themes.IEditable;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;

public class ColorDefinition
implements IPluginContribution,
IHierarchalThemeElementDefinition,
ICategorizedThemeElementDefinition,
IEditable {
    private String defaultsTo;
    private String description;
    private String id;
    private String label;
    private String pluginId;
    private String rawValue;
    private String categoryId;
    boolean isEditable;
    private RGB parsedValue;

    public ColorDefinition(String label, String id, String defaultsTo, String value, String categoryId, boolean isEditable, String description, String pluginId) {
        this.label = label;
        this.id = id;
        this.defaultsTo = defaultsTo;
        this.rawValue = value;
        this.categoryId = categoryId;
        this.description = description;
        this.isEditable = isEditable;
        this.pluginId = pluginId;
    }

    public ColorDefinition(ColorDefinition original, RGB value) {
        this.label = original.getLabel();
        this.id = original.getId();
        this.categoryId = original.getCategoryId();
        this.description = original.getDescription();
        this.isEditable = original.isEditable();
        this.pluginId = original.getPluginId();
        this.parsedValue = value;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getDefaultsTo() {
        return this.defaultsTo;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public RGB getValue() {
        if (this.parsedValue == null) {
            this.parsedValue = ColorUtils.getColorValue(this.rawValue);
        }
        return this.parsedValue;
    }

    public String toString() {
        return this.getId();
    }

    public boolean isEditable() {
        return this.isEditable;
    }
}

